DF-ISE text

Info {
  version   = 1.0
  type      = xyplot
  datasets  = [
    "time"
    "Source OuterVoltage" "Source InnerVoltage" "Source QuasiFermiPotential" "Source DisplacementCurrent" "Source eCurrent"
    "Source hCurrent" "Source TotalCurrent" "Source Charge" "Gate OuterVoltage" "Gate InnerVoltage"
    "Gate QuasiFermiPotential" "Gate DisplacementCurrent" "Gate eCurrent" "Gate hCurrent" "Gate TotalCurrent"
    "Gate Charge" "Drain OuterVoltage" "Drain InnerVoltage" "Drain QuasiFermiPotential" "Drain DisplacementCurrent"
    "Drain eCurrent" "Drain hCurrent" "Drain TotalCurrent" "Drain Charge" ]
  functions = [
    Time
    OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent eCurrent
    hCurrent TotalCurrent Charge OuterVoltage InnerVoltage
    QuasiFermiPotential DisplacementCurrent eCurrent hCurrent TotalCurrent
    Charge OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent
    eCurrent hCurrent TotalCurrent Charge ]
}

Data {
      5.00000000000000E-13
      0.00000000000000E+00  -3.52151091401099E-12   0.00000000000000E+00  -7.63373197567060E-10   1.59629341615401E-22
      4.28496253622213E-09   3.52158933865523E-09  -7.94952621556917E-19  -2.47846792153657E-01  -2.47846792161903E-01
      0.00000000000000E+00   0.00000000000000E+00   8.24663290356485E-09   0.00000000000000E+00   8.24663290356485E-09
      3.70485193211918E-18  -2.47846792153666E-01  -2.44139204126646E-01   0.00000000000000E+00   2.44091921809578E-11
     -9.83204380319292E-23  -1.17926314344066E-08  -1.17682222422257E-08  -2.90989931056226E-18
      1.17500000000000E-12
      0.00000000000000E+00  -3.54245151409431E-12   0.00000000000000E+00  -5.10456624961718E-11   1.52004576583293E-22
      3.59345855806122E-09   3.54241289556520E-09  -7.99779131575748E-19  -2.45758708979509E-01  -2.45758708987284E-01
      0.00000000000000E+00   0.00000000000000E+00   7.77521311474654E-09   0.00000000000000E+00   7.77521311474654E-09
      3.71010020097164E-18  -2.45758708979514E-01  -2.42193067398462E-01   0.00000000000000E+00   3.28865241633720E-11
     -9.82940725672055E-23  -1.13505125344720E-08  -1.13176260103087E-08  -2.91032106939589E-18
      1.63062500000000E-12
      0.00000000000000E+00  -3.55549346677778E-12   0.00000000000000E+00  -4.01579895463338E-12   1.46010493403270E-22
      3.55948600423028E-09   3.55547020527579E-09  -8.02853241040650E-19  -2.44452979472818E-01  -2.44452979480242E-01
      0.00000000000000E+00   0.00000000000000E+00   7.42462877088322E-09   0.00000000000000E+00   7.42462877088322E-09
      3.71348304745537E-18  -2.44452979472822E-01  -2.40993677520446E-01   0.00000000000000E+00   3.60857367363959E-11
     -9.82760747166185E-23  -1.10161847128955E-08  -1.09800989761592E-08  -2.91062980641472E-18
      2.24571875000000E-12
      0.00000000000000E+00  -3.57184183000072E-12   0.00000000000000E+00   6.59592506409123E-13   1.37576381171142E-22
      3.57118559781488E-09   3.57184519032142E-09  -8.06706042853563E-19  -2.42815955710230E-01  -2.42815955717168E-01
      0.00000000000000E+00   0.00000000000000E+00   6.93804596275584E-09   0.00000000000000E+00   6.93804596275584E-09
      3.71775059616427E-18  -2.42815955710234E-01  -2.39504795656918E-01   0.00000000000000E+00   3.69561031143019E-11
     -9.82529838228793E-23  -1.05468472561938E-08  -1.05098911530796E-08  -2.91104455331071E-18
      3.07609531250000E-12
      0.00000000000000E+00  -3.59195582744916E-12   0.00000000000000E+00   9.37089440898622E-13   1.26894946454270E-22
      3.59107293421981E-09   3.59201002366083E-09  -8.11436679895845E-19  -2.40800255159459E-01  -2.40800255165777E-01
      0.00000000000000E+00   0.00000000000000E+00   6.31788741014878E-09   0.00000000000000E+00   6.31788741014878E-09
      3.72299682179417E-18  -2.40800255159461E-01  -2.37678126630246E-01   0.00000000000000E+00   3.48666247672378E-11
     -9.82249396916468E-23  -9.94476405857481E-09  -9.90989743380767E-09  -2.91156014189833E-18
      4.19710367187500E-12
      0.00000000000000E+00  -3.61620283807195E-12   0.00000000000000E+00   8.68596537697852E-13   1.14456091950580E-22
      3.61537908722467E-09   3.61624768376249E-09  -8.17101668032582E-19  -2.38378189372847E-01  -2.38378189378435E-01
      0.00000000000000E+00   0.00000000000000E+00   5.58781989011225E-09   0.00000000000000E+00   5.58781989011225E-09
      3.72926081460167E-18  -2.38378189372847E-01  -2.35478438652267E-01   0.00000000000000E+00   3.04549794627519E-11
     -9.81923041475433E-23  -9.23452255333886E-09  -9.20406757387621E-09  -2.91215914656909E-18
      5.71046495703125E-12
      0.00000000000000E+00  -3.64449101713187E-12   0.00000000000000E+00   7.86260602592836E-13   1.00902700180947E-22
      3.64375710408349E-09   3.64454336468618E-09  -8.23686434897738E-19  -2.35551938020403E-01  -2.35551938025188E-01
      0.00000000000000E+00   0.00000000000000E+00   4.78528303513363E-09   0.00000000000000E+00   4.78528303513363E-09
      3.73650267668556E-18  -2.35551938020407E-01  -2.32896123079466E-01   0.00000000000000E+00   2.48734346375002E-11
     -9.81556867313780E-23  -8.45469983445775E-09  -8.42982639982035E-09  -2.91281624178782E-18
      7.75350269199219E-12
      0.00000000000000E+00  -3.67636114094288E-12   0.00000000000000E+00   7.21475718804409E-13   8.69457917319906E-23
      3.67574073685260E-09   3.67646221257149E-09  -8.31077810893716E-19  -2.32365739487334E-01  -2.32365739491289E-01
      0.00000000000000E+00   0.00000000000000E+00   3.95445176755779E-09   0.00000000000000E+00   3.95445176755779E-09
      3.74458177086776E-18  -2.32365739487356E-01  -2.29961640487146E-01   0.00000000000000E+00   1.91337703356127E-11
     -9.81161074521480E-23  -7.65004775046337E-09  -7.63091398012785E-09  -2.91350395997404E-18
      1.05116036341895E-11
      0.00000000000000E+00  -3.71080291739570E-12   0.00000000000000E+00   6.84831612190144E-13   7.33096299353391E-23
      3.71036804437236E-09   3.71105287598462E-09  -8.39045543359331E-19  -2.28915116591939E-01  -2.28915116595080E-01
      0.00000000000000E+00   0.00000000000000E+00   3.14087052236140E-09   0.00000000000000E+00   3.14087052236140E-09
      3.75324460881481E-18  -2.28915116591915E-01  -2.26756465907668E-01   0.00000000000000E+00   1.38931442649719E-11
     -9.80750084447932E-23  -6.86581654261098E-09  -6.85192339834610E-09  -2.91419906545547E-18
      1.42350399061558E-11
      0.00000000000000E+00  -3.74643867543222E-12   0.00000000000000E+00   6.77315123891187E-13   6.06695687902394E-23
      3.74614472040436E-09   3.74682203552831E-09  -8.47241695962920E-19  -2.25348878470504E-01  -2.25348878472891E-01
      0.00000000000000E+00   0.00000000000000E+00   2.38661385797870E-09   0.00000000000000E+00   2.38661385797870E-09
      3.76213101342078E-18  -2.25348878470411E-01  -2.23416621691302E-01   0.00000000000000E+00   9.49303904800102E-12
     -9.80341119738723E-23  -6.14292893255485E-09  -6.13343589350695E-09  -2.91488931745786E-18
      1.92616788733103E-11
      0.00000000000000E+00  -3.78143152030829E-12   0.00000000000000E+00   2.64572599404702E-13   4.95826342849365E-23
      3.78113982656544E-09   3.78140439916489E-09  -8.55226480720686E-19  -2.21859559985430E-01  -2.21859559987156E-01
      0.00000000000000E+00   0.00000000000000E+00   1.72578446151406E-09   0.00000000000000E+00   1.72578446151406E-09
      3.77080590884394E-18  -2.21859559985350E-01  -2.20124505178172E-01   0.00000000000000E+00   6.47413893243853E-12
     -9.79952576105154E-23  -5.51366299961141E-09  -5.50718886067907E-09  -2.91557942812325E-18
      2.60476414789689E-11
      0.00000000000000E+00  -3.81339348885651E-12   0.00000000000000E+00   1.79139220674870E-13   4.04418383647196E-23
      3.81321398403562E-09   3.81339312325634E-09  -8.62522110948270E-19  -2.18660687563424E-01  -2.18660687564605E-01
      0.00000000000000E+00   0.00000000000000E+00   1.18062220464022E-09   0.00000000000000E+00   1.18062220464022E-09
      3.77881756697604E-18  -2.18660687563358E-01  -2.17087308775564E-01   0.00000000000000E+00   4.05570452640708E-12
     -9.79598060809112E-23  -4.99807103242271E-09  -4.99401532789640E-09  -2.91629545602777E-18
      3.52086909966080E-11
      0.00000000000000E+00  -3.84048768633273E-12   0.00000000000000E+00   1.12461582320050E-13   3.34419034108666E-23
      3.84041500344007E-09   3.84052746502242E-09  -8.68701300031073E-19  -2.15947253417655E-01  -2.15947253418415E-01
      0.00000000000000E+00   0.00000000000000E+00   7.60671285396637E-10   0.00000000000000E+00   7.60671285396637E-10
      3.78578611428820E-18  -2.15947253417659E-01  -2.14497632068267E-01   0.00000000000000E+00   2.40587066620815E-12
     -9.79287249158465E-23  -4.60360462108507E-09  -4.60119875041896E-09  -2.91708481425713E-18
      4.75761078454208E-11
      0.00000000000000E+00  -3.86152013115325E-12   0.00000000000000E+00   6.46655429451190E-14   2.85753168880411E-23
      3.86145944735241E-09   3.86152411289539E-09  -8.73491195858645E-19  -2.13847588728185E-01  -2.13847588728648E-01
      0.00000000000000E+00   0.00000000000000E+00   4.62548650459561E-10   0.00000000000000E+00   4.62548650459561E-10
      3.79150664626129E-18  -2.13847588728133E-01  -2.12485276343803E-01   0.00000000000000E+00   1.35407327538459E-12
     -9.79020602744940E-23  -4.32542683663013E-09  -4.32407276335484E-09  -2.91801545040265E-18
      6.42721205913181E-11
      0.00000000000000E+00  -3.87621528910646E-12   0.00000000000000E+00   3.38159024364830E-14   2.56389556855228E-23
      3.87614690444425E-09   3.87618072034672E-09  -8.76860350078918E-19  -2.12381928031932E-01  -2.12381928032204E-01
      0.00000000000000E+00   0.00000000000000E+00   2.71226427538515E-10   0.00000000000000E+00   2.71226427538515E-10
      3.79603504615250E-18  -2.12381928031888E-01  -2.11075274415350E-01   0.00000000000000E+00   7.34702207047037E-13
     -9.78787909902483E-23  -4.14814185009225E-09  -4.14740714788530E-09  -2.91917469607358E-18
      8.68117377982794E-11
      0.00000000000000E+00  -3.88549160756442E-12   0.00000000000000E+00   2.30063257695929E-13   2.42743856937971E-23
      3.88544492018769E-09   3.88567498344541E-09  -8.79032908745719E-19  -2.11453875672348E-01  -2.11453875672510E-01
      0.00000000000000E+00   0.00000000000000E+00   1.62755968406869E-10   0.00000000000000E+00   1.62755968406869E-10
      3.79970350337854E-18  -2.11453875673985E-01  -2.10178471973660E-01   0.00000000000000E+00   1.90759719592086E-13
     -9.78568004676104E-23  -4.04862171157179E-09  -4.04843095185229E-09  -2.92067059463282E-18
      1.17240221027677E-10
      0.00000000000000E+00  -3.89109413653408E-12   0.00000000000000E+00   9.91905962542871E-14   2.40522221764696E-23
      3.89111902203332E-09   3.89121821262960E-09  -8.80403680648228E-19  -2.10887313072578E-01  -2.10887313072688E-01
      0.00000000000000E+00   0.00000000000000E+00   1.09633952839213E-10   0.00000000000000E+00   1.09633952839213E-10
      3.80303949827388E-18  -2.10887313074130E-01  -2.09626860535640E-01   0.00000000000000E+00   1.57530180606683E-13
     -9.78333976802306E-23  -4.00100969564935E-09  -4.00085216546884E-09  -2.92263581762565E-18
      1.58318673387364E-10
      0.00000000000000E+00  -3.89504346023400E-12   0.00000000000000E+00   3.17048627775265E-14   2.45998392993381E-23
      3.89501836069699E-09   3.89505006555979E-09  -8.81377204729511E-19  -2.10497725540032E-01  -2.10497725540119E-01
      0.00000000000000E+00   0.00000000000000E+00   8.69674039615203E-11   0.00000000000000E+00   8.69674039615203E-11
      3.80661198463436E-18  -2.10497725542772E-01  -2.09243186661402E-01   0.00000000000000E+00   1.57325442708427E-13
     -9.78053851865716E-23  -3.98217479496393E-09  -3.98201746952132E-09  -2.92523477990485E-18
      2.08318673387364E-10
      0.00000000000000E+00  -3.89825802603627E-12   0.00000000000000E+00   7.51414294956370E-15   2.55744649279383E-23
      3.89825197676099E-09   3.89825949090397E-09  -8.82177614391245E-19  -2.10174481968800E-01  -2.10174481968879E-01
      0.00000000000000E+00   0.00000000000000E+00   7.80785499376421E-11   0.00000000000000E+00   7.80785499376421E-11
      3.81051591213124E-18  -2.10174481971391E-01  -2.08921725063292E-01   0.00000000000000E+00   1.56482637839057E-13
     -9.77731027944091E-23  -3.97649452347933E-09  -3.97633804084159E-09  -2.92833829773999E-18
      2.58318673387364E-10
      0.00000000000000E+00  -3.90101336815249E-12   0.00000000000000E+00   3.15219795507817E-15   2.66161651487286E-23
      3.90102617892381E-09   3.90102933112179E-09  -8.82834609320201E-19  -2.09897100647143E-01  -2.09897100647217E-01
      0.00000000000000E+00   0.00000000000000E+00   7.41388982220984E-11   0.00000000000000E+00   7.41388982220984E-11
      3.81422285704234E-18  -2.09897100647740E-01  -2.08644710950238E-01   0.00000000000000E+00   1.50978075069274E-13
     -9.77417142392392E-23  -3.97531920741889E-09  -3.97516822934392E-09  -2.93138824772214E-18
      3.08318673387364E-10
      0.00000000000000E+00  -3.90358502079430E-12   0.00000000000000E+00   2.94095755891677E-15   2.76632211441176E-23
      3.90361867481249E-09   3.90362161577008E-09  -8.83415174761436E-19  -2.09637868280229E-01  -2.09637868280300E-01
      0.00000000000000E+00   0.00000000000000E+00   7.15937696962807E-11   0.00000000000000E+00   7.15937696962807E-11
      3.81780254552716E-18  -2.09637868285728E-01  -2.08385463634330E-01   0.00000000000000E+00   1.45655510349718E-13
     -9.77109584273724E-23  -3.97536104097655E-09  -3.97521538546629E-09  -2.93438737076572E-18
      3.58318673387364E-10
      0.00000000000000E+00  -3.90606482869891E-12   0.00000000000000E+00   2.57880238766510E-15   2.87002903084340E-23
      3.90610589110032E-09   3.90610846990274E-09  -8.83940731032611E-19  -2.09389158830442E-01  -2.09389158830512E-01
      0.00000000000000E+00   0.00000000000000E+00   6.95105734132382E-11   0.00000000000000E+00   6.95105734132382E-11
      3.82127807419782E-18  -2.09389158828756E-01  -2.08136626842402E-01   0.00000000000000E+00   1.41940498655647E-13
     -9.76807436911424E-23  -3.97576098381454E-09  -3.97561904331598E-09  -2.93733734316521E-18
      4.08318673387364E-10
      0.00000000000000E+00  -3.90854463660351E-12   0.00000000000000E+00   1.70228459197642E-15   2.97241357048549E-23
      3.90851155908710E-09   3.90851326137172E-09  -8.84420463053694E-19  -2.09148600905533E-01  -2.09148600905601E-01
      0.00000000000000E+00   0.00000000000000E+00   6.76368201238655E-11   0.00000000000000E+00   6.76368201238655E-11
      3.82465991520401E-18  -2.09148600894482E-01  -2.07895901274847E-01   0.00000000000000E+00   1.39364297485876E-13
     -9.76510385473349E-23  -3.97628944579301E-09  -3.97615008149562E-09  -2.94023945215032E-18
      4.58318673387364E-10
      0.00000000000000E+00  -3.91084075503370E-12   0.00000000000000E+00   2.14151214008515E-15   3.07345338439298E-23
      3.91084542039534E-09   3.91084756190751E-09  -8.84860011639738E-19  -2.08915224061850E-01  -2.08915224061916E-01
      0.00000000000000E+00   0.00000000000000E+00   6.58978489210135E-11   0.00000000000000E+00   6.58978489210135E-11
      3.82795480765006E-18  -2.08915224039802E-01  -2.07662336945084E-01   0.00000000000000E+00   1.35843303617649E-13
     -9.76218089088055E-23  -3.97688125413202E-09  -3.97674541082850E-09  -2.94309479601032E-18
      5.08318673387364E-10
      0.00000000000000E+00  -3.91313687346389E-12   0.00000000000000E+00   1.73308814799091E-15   3.17320263254892E-23
      3.91311319314386E-09   3.91311492623204E-09  -8.85263768851525E-19  -2.08688454088982E-01  -2.08688454089046E-01
      0.00000000000000E+00   0.00000000000000E+00   6.42664143125573E-11   0.00000000000000E+00   6.42664143125573E-11
      3.83116812836569E-18  -2.08688454057920E-01  -2.07435366428799E-01   0.00000000000000E+00   1.33420718876828E-13
     -9.75930424156243E-23  -3.97751476126342E-09  -3.97738134054464E-09  -2.94590435951417E-18
      5.58318673387364E-10
      0.00000000000000E+00  -3.91534114715687E-12   0.00000000000000E+00   2.04175189963317E-15   3.27172404766756E-23
      3.91531931377712E-09   3.91532135552905E-09  -8.85635500081493E-19  -2.08467849684585E-01  -2.08467849684648E-01
      0.00000000000000E+00   0.00000000000000E+00   6.27283889494907E-11   0.00000000000000E+00   6.27283889494907E-11
      3.83430454781317E-18  -2.08467849653712E-01  -2.07214551485032E-01   0.00000000000000E+00   1.30479962068227E-13
     -9.75647187941072E-23  -3.97818022444049E-09  -3.97804974447852E-09  -2.94866904773167E-18
      6.08318673387364E-10
      0.00000000000000E+00  -3.91745357611264E-12   0.00000000000000E+00   1.78835989752410E-15   3.36908010972917E-23
      3.91746754450108E-09   3.91746933286101E-09  -8.85978534326379E-19  -2.08253032679298E-01  -2.08253032679359E-01
      0.00000000000000E+00   0.00000000000000E+00   6.12738971710294E-11   0.00000000000000E+00   6.12738971710294E-11
      3.83736824267172E-18  -2.08253032665973E-01  -2.06999515878097E-01   0.00000000000000E+00   1.28255407327566E-13
     -9.75368262596372E-23  -3.97887148543926E-09  -3.97874323003203E-09  -2.95138970834534E-18
      6.58318673387364E-10
      0.00000000000000E+00  -3.91947416033120E-12   0.00000000000000E+00  -1.49952223617089E-16   3.46532632583747E-23
      3.91956128494097E-09   3.91956113498878E-09  -8.86295844401917E-19  -2.08043664245150E-01  -2.08043664245210E-01
      0.00000000000000E+00   0.00000000000000E+00   5.98949250620295E-11   0.00000000000000E+00   5.98949250620295E-11
      3.84036298892482E-18  -2.08043664256469E-01  -2.06789922224179E-01   0.00000000000000E+00   1.27834502423297E-13
     -9.75093517266974E-23  -3.97958389455314E-09  -3.97945606005081E-09  -2.95406714452290E-18
      7.08318673387364E-10
      0.00000000000000E+00  -3.92158658928698E-12   0.00000000000000E+00   1.79309272821713E-15   3.56051001952995E-23
      3.92160359223209E-09   3.92160538532486E-09  -8.86590082110052E-19  -2.07839439887617E-01  -2.07839439887676E-01
      0.00000000000000E+00   0.00000000000000E+00   5.85843555502259E-11   0.00000000000000E+00   5.85843555502259E-11
      3.84329220670233E-18  -2.07839439960602E-01  -2.06585467338063E-01   0.00000000000000E+00   1.23659966228393E-13
     -9.74822841970352E-23  -3.98031340084120E-09  -3.98018974087507E-09  -2.95670212459228E-18
      7.58318673387364E-10
      0.00000000000000E+00  -3.92360717350554E-12   0.00000000000000E+00   5.83119250782791E-16   3.65467797064147E-23
      3.92359722210282E-09   3.92359780522211E-09  -8.86863627539478E-19  -2.07640081301574E-01  -2.07640081301632E-01
      0.00000000000000E+00   0.00000000000000E+00   5.73362378238140E-11   0.00000000000000E+00   5.73362378238140E-11
      3.84615901859352E-18  -2.07640081457385E-01  -2.06385873903735E-01   0.00000000000000E+00   1.22714430967473E-13
     -9.74556136487753E-23  -3.98105675747681E-09  -3.98093404304594E-09  -2.95929539105404E-18
      8.08318673387364E-10
      0.00000000000000E+00  -3.92553591298690E-12   0.00000000000000E+00   1.76748111261926E-15   3.74786656993689E-23
      3.92554472580621E-09   3.92554649328736E-09  -8.87118600788428E-19  -2.07445336816068E-01  -2.07445336816124E-01
      0.00000000000000E+00   0.00000000000000E+00   5.61448956907870E-11   0.00000000000000E+00   5.61448956907870E-11
      3.84896626337806E-18  -2.07445337024969E-01  -2.06190891186229E-01   0.00000000000000E+00   1.19467394806900E-13
     -9.74293305909355E-23  -3.98181085637284E-09  -3.98169138897813E-09  -2.96184766258963E-18
      8.58318673387364E-10
      0.00000000000000E+00  -3.92746465246826E-12   0.00000000000000E+00   1.01849390731775E-15   3.84011252476144E-23
      3.92744838374927E-09   3.92744940224321E-09  -8.87356902705038E-19  -2.07254975831181E-01  -2.07254975831236E-01
      0.00000000000000E+00   0.00000000000000E+00   5.50056063132450E-11   0.00000000000000E+00   5.50056063132450E-11
      3.85171654369372E-18  -2.07254976044743E-01  -2.06000289334538E-01   0.00000000000000E+00   1.18209341755612E-13
     -9.74034264986894E-23  -3.98257321789812E-09  -3.98245500855646E-09  -2.96435964098868E-18
      9.08318673387364E-10
      0.00000000000000E+00  -3.92930154721241E-12   0.00000000000000E+00   1.72373068699762E-15   3.93144472224905E-23
      3.92931031713980E-09   3.92931204087053E-09  -8.87580226169541E-19  -2.07068788939012E-01  -2.07068788939066E-01
      0.00000000000000E+00   0.00000000000000E+00   5.39138613189868E-11   0.00000000000000E+00   5.39138613189868E-11
      3.85441223675967E-18  -2.07068789044929E-01  -2.05813859630686E-01   0.00000000000000E+00   1.15570545117580E-13
     -9.73778931792694E-23  -3.98334147273454E-09  -3.98322590218952E-09  -2.96683201059013E-18
      9.58318673387365E-10
      0.00000000000000E+00  -3.93113844195656E-12   0.00000000000000E+00   1.26531385082777E-15   4.02189207181553E-23
      3.93113242686020E-09   3.93113369217409E-09  -8.87790087131940E-19  -2.06886583786160E-01  -2.06886583786213E-01
      0.00000000000000E+00   0.00000000000000E+00   5.28658703457308E-11   0.00000000000000E+00   5.28658703457308E-11
      3.85705553027696E-18  -2.06886583630983E-01  -2.05631410274034E-01   0.00000000000000E+00   1.14138400968793E-13
     -9.73527232293770E-23  -3.98411370092068E-09  -3.98399956251981E-09  -2.96926544314502E-18
      1.00831867338736E-09
      0.00000000000000E+00  -3.93288349196350E-12   0.00000000000000E+00   1.67058943694512E-15   4.11147758082261E-23
      3.93291648410965E-09   3.93291815469913E-09  -8.87987835453553E-19  -2.06708184992751E-01  -2.06708184992803E-01
      0.00000000000000E+00   0.00000000000000E+00   5.18580324810870E-11   0.00000000000000E+00   5.18580324810870E-11
      3.85964843190101E-18  -2.06708184434618E-01  -2.05452766474038E-01   0.00000000000000E+00   1.11903462814115E-13
     -9.73279092967094E-23  -3.98488809064294E-09  -3.98477618718022E-09  -2.97166059644746E-18
      1.05831867338736E-09
      0.00000000000000E+00  -3.93462854197045E-12   0.00000000000000E+00   1.39367600241244E-15   4.20022409796082E-23
      3.93466407446932E-09   3.93466546814536E-09  -8.88174678864994E-19  -2.06533430961435E-01  -2.06533430961486E-01
      0.00000000000000E+00   0.00000000000000E+00   5.08872974190014E-11   0.00000000000000E+00   5.08872974190014E-11
      3.86219279677196E-18  -2.06533429935502E-01  -2.05277767170784E-01   0.00000000000000E+00   1.10385522351017E-13
     -9.73034448124365E-23  -3.98566315108661E-09  -3.98555276556436E-09  -2.97401811790697E-18
      1.10831867338736E-09
      0.00000000000000E+00  -3.93637359197739E-12   0.00000000000000E+00   1.61341747113657E-15   4.28814998503708E-23
      3.93637668823314E-09   3.93637830165065E-09  -8.88351692611660E-19  -2.06362173776853E-01  -2.06362173776903E-01
      0.00000000000000E+00   0.00000000000000E+00   4.99507708026451E-11   0.00000000000000E+00   4.99507708026451E-11
      3.86469033531209E-18  -2.06362172411725E-01  -2.05106265085709E-01   0.00000000000000E+00   1.08423194691119E-13
     -9.72793232307526E-23  -3.98643749564791E-09  -3.98632907245331E-09  -2.97633864270043E-18
      1.15831867338736E-09
      0.00000000000000E+00  -3.93802679724712E-12   0.00000000000000E+00   1.44881117953172E-15   4.37527336181936E-23
      3.93805565186175E-09   3.93805710067297E-09  -8.88519838215354E-19  -2.06194276637441E-01  -2.06194276637491E-01
      0.00000000000000E+00   0.00000000000000E+00   4.90459912810513E-11   0.00000000000000E+00   4.90459912810513E-11
      3.86714263487615E-18  -2.06194275334337E-01  -2.04938124046597E-01   0.00000000000000E+00   1.06874484055104E-13
     -9.72555386526663E-23  -3.98720996643796E-09  -3.98710309195400E-09  -2.97862279666079E-18
      1.20831867338736E-09
      0.00000000000000E+00  -3.93968000251686E-12   0.00000000000000E+00   1.55537074874107E-15   4.46160895319243E-23
      3.93970223687458E-09   3.93970379224537E-09  -8.88679971510024E-19  -2.06029613881384E-01  -2.06029613881432E-01
      0.00000000000000E+00   0.00000000000000E+00   4.81706154215112E-11   0.00000000000000E+00   4.81706154215112E-11
      3.86955116564722E-18  -2.06029613379545E-01  -2.04773219068152E-01   0.00000000000000E+00   1.05100684811051E-13
     -9.72320851405272E-23  -3.98797950835159E-09  -3.98787440766688E-09  -2.98087119413720E-18
      1.25831867338736E-09
      0.00000000000000E+00  -3.94133320778660E-12   0.00000000000000E+00   1.45947533134615E-15   4.54717124205038E-23
      3.94131758763430E-09   3.94131904710967E-09  -8.88832857282769E-19  -2.05868068958915E-01  -2.05868068958962E-01
      0.00000000000000E+00   0.00000000000000E+00   4.73226370785621E-11   0.00000000000000E+00   4.73226370785621E-11
      3.87191729750115E-18  -2.05868070203355E-01  -2.04611434077216E-01   0.00000000000000E+00   1.03554887022004E-13
     -9.72089573055544E-23  -3.98874523907520E-09  -3.98864168418827E-09  -2.98308444021838E-18
      1.30831867338736E-09
      0.00000000000000E+00  -3.94298641305633E-12   0.00000000000000E+00   1.49832508446812E-15   4.63197215485012E-23
      3.94290282355050E-09   3.94290432187563E-09  -8.88979175981685E-19  -2.05709534482635E-01  -2.05709534482682E-01
      0.00000000000000E+00   0.00000000000000E+00   4.65001370121944E-11   0.00000000000000E+00   4.65001370121944E-11
      3.87424230435176E-18  -2.05709538356894E-01  -2.04452661877549E-01   0.00000000000000E+00   1.01916033689182E-13
     -9.71861496559571E-23  -3.98950637492141E-09  -3.98940445888782E-09  -2.98526312837008E-18
      1.35831867338736E-09
      0.00000000000000E+00  -3.94445592885165E-12   0.00000000000000E+00   1.44386295849835E-15   4.71602343490460E-23
      3.94445898517641E-09   3.94446042903942E-09  -8.89119534979620E-19  -2.05553910705282E-01  -2.05553910705328E-01
      0.00000000000000E+00   0.00000000000000E+00   4.57014577979255E-11   0.00000000000000E+00   4.57014577979255E-11
      3.87652737724166E-18  -2.05553917496189E-01  -2.04296802318957E-01   0.00000000000000E+00   1.00393727904828E-13
     -9.71636571496747E-23  -3.99026228056513E-09  -3.99016188683732E-09  -2.98740784226204E-18
      1.40831867338736E-09
      0.00000000000000E+00  -3.94601728938418E-12   0.00000000000000E+00   1.44341214311252E-15   4.79933490874515E-23
      3.94598710414091E-09   3.94598854755310E-09  -8.89254474352392E-19  -2.05401105465941E-01  -2.05401105465985E-01
      0.00000000000000E+00   0.00000000000000E+00   4.49250119201201E-11   0.00000000000000E+00   4.49250119201201E-11
      3.87877362783766E-18  -2.05401114196795E-01  -2.04143762152668E-01   0.00000000000000E+00   9.88561352371723E-14
     -9.71414745873167E-23  -3.99101241560837E-09  -3.99091355947323E-09  -2.98951915348527E-18
      1.45831867338736E-09
      0.00000000000000E+00  -3.94748680517950E-12   0.00000000000000E+00   1.41342680904720E-15   4.88191621407327E-23
      3.94748812095660E-09   3.94748953438346E-09  -8.89384476224098E-19  -2.05251032733614E-01  -2.05251032733659E-01
      0.00000000000000E+00   0.00000000000000E+00   4.41694454838109E-11   0.00000000000000E+00   4.41694454838109E-11
      3.88098210011185E-18  -2.05251040589229E-01  -2.03993453638949E-01   0.00000000000000E+00   9.73698911823318E-14
     -9.71195971095270E-23  -3.99175634975838E-09  -3.99165897986729E-09  -2.99159762388776E-18
      1.50831867338736E-09
      0.00000000000000E+00  -3.94904816571203E-12   0.00000000000000E+00   1.39117233317303E-15   4.96377542059503E-23
      3.94896291785174E-09   3.94896430902412E-09  -8.89509970124265E-19  -2.05103612273479E-01  -2.05103612273523E-01
      0.00000000000000E+00   0.00000000000000E+00   4.34334873705824E-11   0.00000000000000E+00   4.34334873705824E-11
      3.88315377448038E-18  -2.05103614429131E-01  -2.03845794656446E-01   0.00000000000000E+00   9.59120436425469E-14
     -9.70980197629139E-23  -3.99249370843823E-09  -3.99239779639469E-09  -2.99364380435612E-18
      1.55831867338736E-09
      0.00000000000000E+00  -3.95042583677014E-12   0.00000000000000E+00   1.37499857937330E-15   5.04492023425802E-23
      3.95041221004766E-09   3.95041358504628E-09  -8.89631341119297E-19  -2.04958768103033E-01  -2.04958768103076E-01
      0.00000000000000E+00   0.00000000000000E+00   4.27161034083053E-11   0.00000000000000E+00   4.27161034083053E-11
      3.88528957965080E-18  -2.04958758493281E-01  -2.03700708082022E-01   0.00000000000000E+00   9.44679472945243E-14
     -9.70767380575310E-23  -3.99322415640180E-09  -3.99312968845460E-09  -2.99565823853150E-18
      1.60831867338736E-09
      0.00000000000000E+00  -3.95189535256546E-12   0.00000000000000E+00   1.34126002889564E-15   5.12535686804500E-23
      3.95183653735256E-09   3.95183787861263E-09  -8.89748934996947E-19  -2.04816427823647E-01  -2.04816427823689E-01
      0.00000000000000E+00   0.00000000000000E+00   4.20163751993915E-11   0.00000000000000E+00   4.20163751993915E-11
      3.88739039841077E-18  -2.04816401218537E-01  -2.03558122472280E-01   0.00000000000000E+00   9.30734885601074E-14
     -9.70557476212268E-23  -3.99394732730048E-09  -3.99385425381201E-09  -2.99764146341382E-18
      1.65831867338736E-09
      0.00000000000000E+00  -3.95327302362357E-12   0.00000000000000E+00   1.33205100458892E-15   5.20509093223445E-23
      3.95323618785872E-09   3.95323751990978E-09  -8.89863064791696E-19  -2.04676521318562E-01  -2.04676521318603E-01
      0.00000000000000E+00   0.00000000000000E+00   4.13336008152064E-11   0.00000000000000E+00   4.13336008152064E-11
      3.88945707845152E-18  -2.04676476685429E-01  -2.03417972037800E-01   0.00000000000000E+00   9.16701444538408E-14
     -9.70350447732404E-23  -3.99466279086934E-09  -3.99457112072498E-09  -2.99959401365983E-18
      1.70831867338737E-09
      0.00000000000000E+00  -3.95465069468169E-12   0.00000000000000E+00   1.29241294692569E-15   5.28412670147276E-23
      3.95461126705349E-09   3.95461255946649E-09  -8.89974014006511E-19  -2.04538980660725E-01  -2.04538980660766E-01
      0.00000000000000E+00   0.00000000000000E+00   4.06671424827061E-11   0.00000000000000E+00   4.06671424827061E-11
      3.89149043557566E-18  -2.04538925384919E-01  -2.03280197437673E-01   0.00000000000000E+00   9.03232477469020E-14
     -9.70146261791847E-23  -3.99537002519682E-09  -3.99527970194917E-09  -3.00151642156915E-18
      1.75831867338737E-09
      0.00000000000000E+00  -3.95593652100259E-12   0.00000000000000E+00   1.28612179346505E-15   5.36246813724851E-23
      3.95596181276115E-09   3.95596309888299E-09  -8.90082038899479E-19  -2.04403740412204E-01  -2.04403740412244E-01
      0.00000000000000E+00   0.00000000000000E+00   4.00164193969686E-11   0.00000000000000E+00   4.00164193969686E-11
      3.89349125654551E-18  -2.04403693768072E-01  -2.03144745293684E-01   0.00000000000000E+00   8.89537132935360E-14
     -9.69944891761409E-23  -3.99606847199322E-09  -3.99597951828002E-09  -3.00340921764604E-18
      1.80831867338737E-09
      0.00000000000000E+00  -3.95731419206070E-12   0.00000000000000E+00   1.24400668470671E-15   5.44011890673941E-23
      3.95728808625420E-09   3.95728933026094E-09  -8.90187366729400E-19  -2.04270739622127E-01  -2.04270739622166E-01
      0.00000000000000E+00   0.00000000000000E+00   3.93806745539908E-11   0.00000000000000E+00   3.93806745539908E-11
      3.89546029027321E-18  -2.04270733152681E-01  -2.03011567080081E-01   0.00000000000000E+00   8.76426404952590E-14
     -9.69746310542197E-23  -3.99675764745531E-09  -3.99667000481491E-09  -3.00527292354381E-18
      1.85831867338737E-09
      0.00000000000000E+00  -3.95860001838161E-12   0.00000000000000E+00   1.23951760174427E-15   5.51708380631696E-23
      3.95859092494604E-09   3.95859216446370E-09  -8.90290192178557E-19  -2.04139924631247E-01  -2.04139924631285E-01
      0.00000000000000E+00   0.00000000000000E+00   3.87588954588988E-11   0.00000000000000E+00   3.87588954588988E-11
      3.89739823504616E-18  -2.04139996501202E-01  -2.02880615813959E-01   0.00000000000000E+00   8.63070258132034E-14
     -9.69550487942730E-23  -3.99743736694832E-09  -3.99735105992260E-09  -3.00710804286760E-18
      1.90831867338736E-09
      0.00000000000000E+00  -3.95988584470252E-12   0.00000000000000E+00   1.19927978038502E-15   5.59336941127358E-23
      3.95987214689430E-09   3.95987334617414E-09  -8.90390671522508E-19  -2.04011252831658E-01  -2.04011252831696E-01
      0.00000000000000E+00   0.00000000000000E+00   3.81496197380639E-11   0.00000000000000E+00   3.81496197380639E-11
      3.89930571603306E-18  -2.04011433885822E-01  -2.02751841455457E-01   0.00000000000000E+00   8.50391967178234E-14
     -9.69357378336933E-23  -3.99810800510881E-09  -3.99802296591219E-09  -3.00891504451055E-18
      1.95831867338736E-09
      0.00000000000000E+00  -3.96117167102342E-12   0.00000000000000E+00   1.19800351265162E-15   5.66898514787387E-23
      3.96113472240809E-09   3.96113592041165E-09  -8.90488919533835E-19  -2.03884695083476E-01  -2.03884695083514E-01
      0.00000000000000E+00   0.00000000000000E+00   3.75510471728840E-11   0.00000000000000E+00   3.75510471728840E-11
      3.90118326839170E-18  -2.03884986602893E-01  -2.02625184931600E-01   0.00000000000000E+00   8.37640888580114E-14
     -9.69166915271065E-23  -3.99877073167327E-09  -3.99868696758451E-09  -3.01069434885787E-18
      2.00831867338737E-09
      0.00000000000000E+00  -3.96236565260712E-12   0.00000000000000E+00   1.16602147485267E-15   5.74394285251889E-23
      3.96238254285688E-09   3.96238370887841E-09  -8.90585012485324E-19  -2.03760235177797E-01  -2.03760235177834E-01
      0.00000000000000E+00   0.00000000000000E+00   3.69612521296930E-11   0.00000000000000E+00   3.69612521296930E-11
      3.90303133099819E-18  -2.03760582621103E-01  -2.02500573591764E-01   0.00000000000000E+00   8.25754989861920E-14
     -9.68979003762105E-23  -3.99942753650703E-09  -3.99934496100814E-09  -3.01244631851286E-18
      2.05831867338737E-09
      0.00000000000000E+00  -3.96355963419082E-12   0.00000000000000E+00   1.16838933888499E-15   5.81825521186392E-23
      3.96361944082785E-09   3.96362060921725E-09  -8.90679004133801E-19  -2.03637863049542E-01  -2.03637863049579E-01
      0.00000000000000E+00   0.00000000000000E+00   3.63788649310220E-11   0.00000000000000E+00   3.63788649310220E-11
      3.90485027424474E-18  -2.03638135824644E-01  -2.02377920543896E-01   0.00000000000000E+00   8.14068922292180E-14
     -9.68793529522868E-23  -4.00008088104037E-09  -3.99999947414823E-09  -3.01417127011094E-18
      2.10831867338737E-09
      0.00000000000000E+00  -3.96484546051172E-12   0.00000000000000E+00   1.14650313553941E-15   5.89193156311390E-23
      3.96484745023678E-09   3.96484859673997E-09  -8.90770956893890E-19  -2.03517560653465E-01  -2.03517560653501E-01
      0.00000000000000E+00   0.00000000000000E+00   3.58038913271825E-11   0.00000000000000E+00   3.58038913271825E-11
      3.90664046881110E-18  -2.03517553576105E-01  -2.02257132508793E-01   0.00000000000000E+00   8.03240898504568E-14
     -9.68610378408583E-23  -4.00073281215691E-09  -4.00065248806716E-09  -3.01586951191721E-18
      2.15831867338737E-09
      0.00000000000000E+00  -3.96613128683263E-12   0.00000000000000E+00   1.14489846397034E-15   5.96497242345935E-23
      3.96606439568189E-09   3.96606554058041E-09  -8.90860988372714E-19  -2.03399280309218E-01  -2.03399280309253E-01
      0.00000000000000E+00   0.00000000000000E+00   3.52387408469451E-11   0.00000000000000E+00   3.52387408469451E-11
      3.90840240585345E-18  -2.03398754767066E-01  -2.02138128305297E-01   0.00000000000000E+00   7.92493468809456E-14
     -9.68429480764580E-23  -4.00138353077414E-09  -4.00130428142735E-09  -3.01754141748073E-18
      2.20831867338737E-09
      0.00000000000000E+00  -3.96732526841633E-12   0.00000000000000E+00   1.11705552840673E-15   6.03736267090803E-23
      3.96726164293957E-09   3.96726275999516E-09  -8.90949321258807E-19  -2.03282921167494E-01  -2.03282921167528E-01
      0.00000000000000E+00   0.00000000000000E+00   3.46887434287628E-11   0.00000000000000E+00   3.46887434287628E-11
      3.91013684302488E-18  -2.03281699118436E-01  -2.02020868697595E-01   0.00000000000000E+00   7.81863812286666E-14
     -9.68250864186847E-23  -4.00202968980505E-09  -4.00195150342392E-09  -3.01918752176608E-18
      2.25831867338737E-09
      0.00000000000000E+00  -3.96842740526282E-12   0.00000000000000E+00   1.09351167873047E-15   6.10906803306372E-23
      3.96842312338045E-09   3.96842421689219E-09  -8.91036316957365E-19  -2.03168313033220E-01  -2.03168313033254E-01
      0.00000000000000E+00   0.00000000000000E+00   3.41618042790966E-11   0.00000000000000E+00   3.41618042790966E-11
      3.91184493323884E-18  -2.03166421184599E-01  -2.01905390814086E-01   0.00000000000000E+00   7.70206121195905E-14
     -9.68074709209885E-23  -4.00266304178332E-09  -4.00258602117129E-09  -3.02080861628147E-18
      2.30831867338737E-09
      0.00000000000000E+00  -3.96952954210931E-12   0.00000000000000E+00   1.02783546957299E-15   6.18003717240615E-23
      3.96952744863087E-09   3.96952847646640E-09  -8.91122459696857E-19  -2.03055223460258E-01  -2.03055223460291E-01
      0.00000000000000E+00   0.00000000000000E+00   3.36662673054860E-11   0.00000000000000E+00   3.36662673054860E-11
      3.91352824660411E-18  -2.03053056549119E-01  -2.01791834349958E-01   0.00000000000000E+00   7.57231285012180E-14
     -9.67901367895740E-23  -4.00327046690030E-09  -4.00319474377190E-09  -3.02240578690726E-18
      2.35831867338737E-09
      0.00000000000000E+00  -3.97063167895580E-12   0.00000000000000E+00   9.82291099535781E-16   6.25021541086089E-23
      3.97055447542532E-09   3.97055545771648E-09  -8.91208259769431E-19  -2.02943403201643E-01  -2.02943403201676E-01
      0.00000000000000E+00   0.00000000000000E+00   3.32069023188709E-11   0.00000000000000E+00   3.32069023188709E-11
      3.91518859172005E-18  -2.02941839097682E-01  -2.01680438033840E-01   0.00000000000000E+00   7.41687643406152E-14
     -9.67731316976822E-23  -4.00383652879959E-09  -4.00376236003534E-09  -3.02398033195063E-18
      2.40831867338737E-09
      0.00000000000000E+00  -3.97155012632787E-12   0.00000000000000E+00   8.71408824253692E-16   6.31957230253240E-23
      3.97149699942447E-09   3.97149787083336E-09  -8.91294054258777E-19  -2.02832680799808E-01  -2.02832680799840E-01
      0.00000000000000E+00   0.00000000000000E+00   3.27790979700943E-11   0.00000000000000E+00   3.27790979700943E-11
      3.91682754661856E-18  -2.02833046234844E-01  -2.01571482989177E-01   0.00000000000000E+00   7.24812573497251E-14
     -9.67565000268735E-23  -4.00434945006071E-09  -4.00427696880346E-09  -3.02553349235978E-18
      2.45831867338737E-09
      0.00000000000000E+00  -3.97237672896274E-12   0.00000000000000E+00   8.60777492705370E-16   6.38813934733803E-23
      3.97237582036845E-09   3.97237668114601E-09  -8.91379720692457E-19  -2.02723099510153E-01  -2.02723099510185E-01
      0.00000000000000E+00   0.00000000000000E+00   3.23630247518251E-11   0.00000000000000E+00   3.23630247518251E-11
      3.91844569785615E-18  -2.02726874815178E-01  -2.01465165755925E-01   0.00000000000000E+00   7.06477360436395E-14
     -9.67402557760981E-23  -4.00481035363380E-09  -4.00473970589785E-09  -3.02706597716370E-18
      2.50831867338737E-09
      0.00000000000000E+00  -3.97329517633482E-12   0.00000000000000E+00   8.01293783265474E-16   6.45605213292433E-23
      3.97325345807959E-09   3.97325425937344E-09  -8.91464376919581E-19  -2.02615062375231E-01  -2.02615062375263E-01
      0.00000000000000E+00   0.00000000000000E+00   3.19204820985338E-11   0.00000000000000E+00   3.19204820985338E-11
      3.92004172196108E-18  -2.02623252148059E-01  -2.01361405968953E-01   0.00000000000000E+00   6.91718341533334E-14
     -9.67243471655904E-23  -4.00524391330602E-09  -4.00517474147196E-09  -3.02857734504150E-18
      2.55831867338737E-09
      0.00000000000000E+00  -3.97421362370689E-12   0.00000000000000E+00   9.12284947048946E-16   6.52356991924620E-23
      3.97423815649526E-09   3.97423906878027E-09  -8.91546208378169E-19  -2.02509418525850E-01  -2.02509418525881E-01
      0.00000000000000E+00   0.00000000000000E+00   3.13986084278116E-11   0.00000000000000E+00   3.13986084278116E-11
      3.92161165238247E-18  -2.02521622984651E-01  -2.01259630916123E-01   0.00000000000000E+00   6.83004181165127E-14
     -9.67086251087847E-23  -4.00570597762611E-09  -4.00563767720809E-09  -3.03006544400430E-18
      2.60831867338737E-09
      0.00000000000000E+00  -3.97540760529059E-12   0.00000000000000E+00   1.16100267399318E-15   6.59105372785341E-23
      3.97546785861826E-09   3.97546901962100E-09  -8.91622625068168E-19  -2.02407394135512E-01  -2.02407394135543E-01
      0.00000000000000E+00   0.00000000000000E+00   3.07442440685645E-11   0.00000000000000E+00   3.07442440685645E-11
      3.92314886458590E-18  -2.02420801589543E-01  -2.01158628141580E-01   0.00000000000000E+00   6.85873257100216E-14
     -9.66928339868711E-23  -4.00628185101515E-09  -4.00621326368954E-09  -3.03152623951773E-18
      2.65831867338737E-09
      0.00000000000000E+00  -3.97715265529753E-12   0.00000000000000E+00   1.64605990208709E-15   6.65886820002754E-23
      3.97706503979574E-09   3.97706668585571E-09  -8.91690948757883E-19  -2.02310271003763E-01  -2.02310271003793E-01
      0.00000000000000E+00   0.00000000000000E+00   2.99309601581575E-11   0.00000000000000E+00   2.99309601581575E-11
      3.92464541259381E-18  -2.02319020869890E-01  -2.01056600296487E-01   0.00000000000000E+00   7.02121107427425E-14
     -9.66766499192564E-23  -4.00706785812454E-09  -4.00699764601390E-09  -3.03295446383592E-18
      2.70831867338737E-09
      0.00000000000000E+00  -3.97898955004168E-12   0.00000000000000E+00   2.00210325424162E-15   6.72719314776657E-23
      3.97906037420344E-09   3.97906237630677E-09  -8.91749742537729E-19  -2.02218756593531E-01  -2.02218756593560E-01
      0.00000000000000E+00   0.00000000000000E+00   2.89957240416862E-11   0.00000000000000E+00   2.89957240416862E-11
      3.92609519879589E-18  -2.02214322577668E-01  -2.00951567850414E-01   0.00000000000000E+00   7.32760713989070E-14
     -9.66597867815864E-23  -4.00813137641975E-09  -4.00805810034844E-09  -3.03434545625816E-18
      2.75831867338737E-09
      0.00000000000000E+00  -3.98128566847187E-12   0.00000000000000E+00   2.19480950986549E-15   6.79577473519899E-23
      3.98129784502176E-09   3.98130003983134E-09  -8.91800634216890E-19  -2.02132112663481E-01  -2.02132112663509E-01
      0.00000000000000E+00   0.00000000000000E+00   2.80742278209522E-11   0.00000000000000E+00   2.80742278209522E-11
      3.92749891018694E-18  -2.02105386572619E-01  -2.00842217123904E-01   0.00000000000000E+00   7.66600667484888E-14
     -9.66421744887171E-23  -4.00945092771895E-09  -4.00937426765230E-09  -3.03569827597004E-18
      2.80831867338737E-09
      0.00000000000000E+00  -3.98330625269044E-12   0.00000000000000E+00   1.99181248753419E-15   6.86366997943926E-23
      3.98335373091496E-09   3.98335572272751E-09  -8.91850148886375E-19  -2.02047268944365E-01  -2.02047268944392E-01
      0.00000000000000E+00   0.00000000000000E+00   2.74166508462039E-11   0.00000000000000E+00   2.74166508462039E-11
      3.92886974272925E-18  -2.01992745516193E-01  -2.00729135536912E-01   0.00000000000000E+00   7.83593573172563E-14
     -9.66241805965782E-23  -4.01085073293091E-09  -4.01077237357369E-09  -3.03701959384287E-18
      2.85831867338737E-09
      0.00000000000000E+00  -3.98450023427413E-12   0.00000000000000E+00   1.11030863535444E-15   6.92913521505256E-23
      3.98452344569157E-09   3.98452455600027E-09  -8.91910593816921E-19  -2.01958376053641E-01  -2.01958376053668E-01
      0.00000000000000E+00   0.00000000000000E+00   2.73574729829614E-11   0.00000000000000E+00   2.73574729829614E-11
      3.93023761637840E-18  -2.01880097878294E-01  -2.00616138251510E-01   0.00000000000000E+00   7.55873685341815E-14
     -9.66067971950298E-23  -4.01195761635169E-09  -4.01188202898325E-09  -3.03832702256148E-18
      2.88331867338737E-09
      0.00000000000000E+00  -3.98477576848576E-12   0.00000000000000E+00  -1.84088473974487E-14   6.96104560138320E-23
      3.98475922797840E-09   3.98474081913107E-09  -8.91945456770536E-19  -2.01912010433110E-01  -2.01912010433137E-01
      0.00000000000000E+00   0.00000000000000E+00   2.75146878334616E-11   0.00000000000000E+00   2.75146878334616E-11
      3.93092548357423E-18  -2.01824345603921E-01  -2.00560262353087E-01   0.00000000000000E+00   9.16113335468255E-14
     -9.66119039675675E-23  -4.01234711829797E-09  -4.01225550696452E-09  -3.03898002680370E-18
      2.89175617338737E-09
      0.00000000000000E+00  -3.98477576848576E-12   0.00000000000000E+00   3.78747427222582E-16   6.97169159919160E-23
      3.98483457125190E-09   3.98483494999939E-09  -8.91957781063735E-19  -2.01896128311213E-01  -2.01896128311240E-01
      0.00000000000000E+00   0.00000000000000E+00   2.75976452922651E-11   0.00000000000000E+00   2.75976452922651E-11
      3.93115833870639E-18  -2.01805720767604E-01  -2.00541587647861E-01   0.00000000000000E+00   7.13108161546297E-14
     -9.65959476160705E-23  -4.01250390610795E-09  -4.01243259529189E-09  -3.03920055764265E-18
      2.90314679838737E-09
      0.00000000000000E+00  -3.98486761322296E-12   0.00000000000000E+00  -1.73938732877573E-16   6.98585183563659E-23
      3.98480973006754E-09   3.98480955612888E-09  -8.91975763100220E-19  -2.01874104688801E-01  -2.01874104688828E-01
      0.00000000000000E+00   0.00000000000000E+00   2.77572022371441E-11   0.00000000000000E+00   2.77572022371441E-11
      3.93147451058812E-18  -2.01780835798096E-01  -2.00516660398651E-01   0.00000000000000E+00   6.95455684231016E-14
     -9.65920031939655E-23  -4.01263630393436E-09  -4.01256675836604E-09  -3.03949874748790E-18
      2.91852414213737E-09
      0.00000000000000E+00  -3.98459207901134E-12   0.00000000000000E+00  -7.77731504623222E-16   7.00446521667529E-23
      3.98459136297521E-09   3.98459058524378E-09  -8.92002996751455E-19  -2.01843071363567E-01  -2.01843071363595E-01
      0.00000000000000E+00   0.00000000000000E+00   2.80655937214209E-11   0.00000000000000E+00   2.80655937214209E-11
      3.93190608487032E-18  -2.01747995657205E-01  -2.00483792069246E-01   0.00000000000000E+00   6.61723319493141E-14
     -9.65872726024119E-23  -4.01272235129683E-09  -4.01265617896498E-09  -3.03990308811886E-18
      2.93928355619987E-09
      0.00000000000000E+00  -3.98385732111368E-12   0.00000000000000E+00  -1.76127554295299E-15   7.02847477073738E-23
      3.98388913402840E-09   3.98388737275293E-09  -8.92046569697368E-19  -2.01798122390562E-01  -2.01798122390591E-01
      0.00000000000000E+00   0.00000000000000E+00   2.86800374304817E-11   0.00000000000000E+00   2.86800374304817E-11
      3.93250146564267E-18  -2.01705809373664E-01  -2.00441633731256E-01   0.00000000000000E+00   5.99593606631057E-14
     -9.65814997023800E-23  -4.01262736954406E-09  -4.01256741018349E-09  -3.04045489594530E-18
      2.96730876518424E-09
      0.00000000000000E+00  -3.98202042636953E-12   0.00000000000000E+00  -3.19805108973689E-15   7.05832829705315E-23
      3.98202064837503E-09   3.98201745032401E-09  -8.92121567937216E-19  -2.01730054042979E-01  -2.01730054043009E-01
      0.00000000000000E+00   0.00000000000000E+00   2.99195058724835E-11   0.00000000000000E+00   2.99195058724835E-11
      3.93333996604745E-18  -2.01655097592575E-01  -2.00391120614697E-01   0.00000000000000E+00   4.78776826017135E-14
     -9.65751940349011E-23  -4.01198483387896E-09  -4.01193695619646E-09  -3.04121839811024E-18
      3.00514279731315E-09
      0.00000000000000E+00  -3.97752003424636E-12   0.00000000000000E+00  -5.96507300609243E-15   7.09296086763355E-23
      3.97754106159137E-09   3.97753509651844E-09  -8.92260009034236E-19  -2.01620915234738E-01  -2.01620915234771E-01
      0.00000000000000E+00   0.00000000000000E+00   3.23207407718571E-11   0.00000000000000E+00   3.23207407718571E-11
      3.93456278999224E-18  -2.01604770601346E-01  -2.00341449199092E-01   0.00000000000000E+00   2.54580888639835E-14
     -9.65705072297696E-23  -4.00988129537904E-09  -4.00985583729028E-09  -3.04230278095801E-18
      3.05514279731315E-09
      0.00000000000000E+00  -3.96879478421165E-12   0.00000000000000E+00  -8.74329606507885E-15   7.12930104517605E-23
      3.96877405332863E-09   3.96876531003263E-09  -8.92507037027918E-19  -2.01446599050036E-01  -2.01446599050071E-01
      0.00000000000000E+00   0.00000000000000E+00   3.60086642817268E-11   0.00000000000000E+00   3.60086642817268E-11
      3.93636322320633E-18  -2.01583477944710E-01  -2.00321757598867E-01   0.00000000000000E+00  -1.09912369080030E-14
     -9.65724523548442E-23  -4.00476298307738E-09  -4.00477397431438E-09  -3.04385618617841E-18
      3.10514279731315E-09
      0.00000000000000E+00  -3.95970215522810E-12   0.00000000000000E+00  -9.19299961690448E-15   7.16166972449386E-23
      3.95969217121999E-09   3.95968297822044E-09  -8.92782810593411E-19  -2.01258582378117E-01  -2.01258582378156E-01
      0.00000000000000E+00   0.00000000000000E+00   3.85344155901360E-11   0.00000000000000E+00   3.85344155901360E-11
      3.93828994398584E-18  -2.01610053463136E-01  -2.00350398750565E-01   0.00000000000000E+00  -4.10560510559262E-14
     -9.65811541458447E-23  -3.99817633775943E-09  -3.99821739381058E-09  -3.04550713339243E-18
      3.15514279731315E-09
      0.00000000000000E+00  -3.95520176310493E-12   0.00000000000000E+00  -4.56983634134311E-15   7.20202172916458E-23
      3.95515966932012E-09   3.95515509948385E-09  -8.93005997829036E-19  -2.01095284099432E-01  -2.01095284099469E-01
      0.00000000000000E+00   0.00000000000000E+00   3.73785431095739E-11   0.00000000000000E+00   3.73785431095739E-11
      3.94015887114132E-18  -2.01665580088912E-01  -2.00407716115403E-01   0.00000000000000E+00  -4.46785738597783E-14
     -9.65906528976534E-23  -3.99248896401946E-09  -3.99253364259342E-09  -3.04715287331228E-18
      3.20514279731315E-09
      0.00000000000000E+00  -3.96190642892108E-12   0.00000000000000E+00   7.70301388301555E-15   7.26830492393849E-23
      3.96187363172114E-09   3.96188133473510E-09  -8.93051713090183E-19  -2.01016247433641E-01  -2.01016247433671E-01
      0.00000000000000E+00   0.00000000000000E+00   2.97616388439403E-11   0.00000000000000E+00   2.97616388439403E-11
      3.94164695308352E-18  -2.01700812853746E-01  -2.00443229859893E-01   0.00000000000000E+00   1.73045073192645E-15
     -9.65895548533465E-23  -3.99164470402969E-09  -3.99164297357905E-09  -3.04859523999333E-18
      3.25514279731315E-09
      0.00000000000000E+00  -3.98652081849270E-12   0.00000000000000E+00   4.03845366499992E-14   7.38047431763129E-23
      3.98652032554834E-09   3.98656071008507E-09  -8.92778997085637E-19  -2.01089315211023E-01  -2.01089315211037E-01
      0.00000000000000E+00   0.00000000000000E+00   1.38545260522084E-11   0.00000000000000E+00   1.38545260522084E-11
      3.94233967938612E-18  -2.01635204542967E-01  -2.00374862502017E-01   0.00000000000000E+00   1.04078352821812E-13
     -9.65622673137154E-23  -4.00051931449001E-09  -4.00041523613728E-09  -3.04956068230049E-18
      3.30514279731315E-09
      0.00000000000000E+00  -4.03244318709646E-12   0.00000000000000E+00   5.71859057738760E-14   7.55197297314994E-23
      4.03237921313093E-09   4.03243639903678E-09  -8.92090795349394E-19  -2.01362242389619E-01  -2.01362242389609E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.47687602930289E-12   0.00000000000000E+00  -9.47687602930289E-12
      3.94186583558466E-18  -2.01370466023053E-01  -2.00103019916023E-01   0.00000000000000E+00   2.94337860544177E-13
     -9.64932278187562E-23  -4.02325386086792E-09  -4.02295952300748E-09  -3.04977504023527E-18
      3.35514279731315E-09
      0.00000000000000E+00  -4.09480576366037E-12   0.00000000000000E+00   1.42480609165419E-13   7.77721884311413E-23
      4.09475441606171E-09   4.09489689667095E-09  -8.91019195263248E-19  -2.01822031470839E-01  -2.01822031470804E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.49231429392963E-11   0.00000000000000E+00  -3.49231429392963E-11
      3.94011967843770E-18  -2.00825204717674E-01  -1.99546118671461E-01   0.00000000000000E+00   4.42267654205147E-13
     -9.63750162029339E-23  -4.06041602138575E-09  -4.05997375373164E-09  -3.04910048317445E-18
      3.40514279731315E-09
      0.00000000000000E+00  -4.15652542706383E-12   0.00000000000000E+00   6.56710096899274E-14   8.01692874936408E-23
      4.15641759027976E-09   4.15648326128953E-09  -8.89818076827820E-19  -2.02350502521217E-01  -2.02350502521165E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.15895062747669E-11   0.00000000000000E+00  -5.15895062747669E-11
      3.93754020312396E-18  -1.99990752620230E-01  -1.98697490103968E-01   0.00000000000000E+00   6.84197296180915E-13
     -9.62189217206273E-23  -4.10557795231083E-09  -4.10489375501475E-09  -3.04772212629614E-18
      3.45514279731315E-09
      0.00000000000000E+00  -4.18518098507258E-12   0.00000000000000E+00   2.91421371861858E-14   8.18869921281630E-23
      4.18515661601468E-09   4.18518575815195E-09  -8.89016516531902E-19  -2.02697717208858E-01  -2.02697717208814E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.36523599823608E-11   0.00000000000000E+00  -4.36523599823608E-11
      3.93535758512484E-18  -1.99004927193423E-01  -1.97700119613043E-01   0.00000000000000E+00   6.74236910397909E-13
     -9.60650279272085E-23  -4.14220763507988E-09  -4.14153339816958E-09  -3.04634106859294E-18
      3.50514279731315E-09
      0.00000000000000E+00  -4.13732987698746E-12   0.00000000000000E+00   2.50051303535912E-14   8.17162142324326E-23
      4.13741108090399E-09   4.13743608603443E-09  -8.89398035479797E-19  -2.02489939316695E-01  -2.02489939316702E-01
      0.00000000000000E+00   0.00000000000000E+00   6.36474794755488E-12   0.00000000000000E+00   6.36474794755488E-12
      3.93567582252222E-18  -1.98209797117432E-01  -1.96904297411042E-01   0.00000000000000E+00   2.61357026522103E-13
     -9.59883442972575E-23  -4.14406219100839E-09  -4.14380083398196E-09  -3.04627778704242E-18
      3.55514279731315E-09
      0.00000000000000E+00  -3.97155012632787E-12   0.00000000000000E+00  -1.65902739948959E-13   7.83917080129030E-23
      3.97175568156410E-09   3.97158977882423E-09  -8.91852361146233E-19  -2.01297409171498E-01  -2.01297409171609E-01
      0.00000000000000E+00   0.00000000000000E+00   1.10183216809330E-10   0.00000000000000E+00   1.10183216809330E-10
      3.94118498336268E-18  -1.98143026494048E-01  -1.96857045429714E-01   0.00000000000000E+00  -4.48466338416608E-13
     -9.60901388186605E-23  -4.08132452929506E-09  -4.08177299563357E-09  -3.04933262221645E-18
      3.60514279731315E-09
      0.00000000000000E+00  -3.67489162514756E-12   0.00000000000000E+00  -2.97907462941520E-13   7.12840568480613E-23
      3.67513490048311E-09   3.67483699302024E-09  -8.97029099694537E-19  -1.98797062200659E-01  -1.98797062200920E-01
      0.00000000000000E+00   0.00000000000000E+00   2.60876114540494E-10   0.00000000000000E+00   2.60876114540494E-10
      3.95422878908971E-18  -1.99394789188208E-01  -1.98154824462554E-01   0.00000000000000E+00  -1.67708983118390E-12
     -9.64689436057189E-23  -3.93403601772947E-09  -3.93571310756075E-09  -3.05719968939517E-18
      3.65514279731315E-09
      0.00000000000000E+00  -3.29428703415957E-12   0.00000000000000E+00  -3.83143448250757E-13   6.12645636477460E-23
      3.29468049667461E-09   3.29429735322642E-09  -9.04755195360958E-19  -1.95052466481590E-01  -1.95052466482008E-01
      0.00000000000000E+00   0.00000000000000E+00   4.18141305663589E-10   0.00000000000000E+00   4.18141305663589E-10
      3.97513585437289E-18  -2.02311417973712E-01  -2.01141796874547E-01   0.00000000000000E+00  -3.11207351465100E-12
     -9.71576171799383E-23  -3.70932658537526E-09  -3.71243865889001E-09  -3.07038065901193E-18
      3.70514279731315E-09
      0.00000000000000E+00  -2.95593102228704E-12   0.00000000000000E+00  -3.42837160956991E-13   5.12605611455061E-23
      2.95624462484633E-09   2.95590178768542E-09  -9.13254563658793E-19  -1.90896876509272E-01  -1.90896876509773E-01
      0.00000000000000E+00   0.00000000000000E+00   5.01051488284093E-10   0.00000000000000E+00   5.01051488284093E-10
      4.00018842878709E-18  -2.06668632771631E-01  -2.05579504144031E-01   0.00000000000000E+00  -4.14021110537997E-12
     -9.80472462653873E-23  -3.45281306486405E-09  -3.45695327596953E-09  -3.08693386512830E-18
      3.75514279731315E-09
      0.00000000000000E+00  -2.84727869817054E-12   0.00000000000000E+00  -1.13084178544784E-13   4.60172098299598E-23
      2.84736023192906E-09   2.84724714775056E-09  -9.18627495044242E-19  -1.88199129160658E-01  -1.88199129161064E-01
      0.00000000000000E+00   0.00000000000000E+00   4.05752453234502E-10   0.00000000000000E+00   4.05752453234502E-10
      4.02047605144882E-18  -2.11511095541391E-01  -2.10486225413116E-01   0.00000000000000E+00  -3.79209256630768E-12
     -9.88384187445157E-23  -3.24920750841864E-09  -3.25299960098505E-09  -3.10184855640457E-18
      3.80514279731315E-09
      0.00000000000000E+00  -3.16515333364579E-12   0.00000000000000E+00   3.16672438310651E-13   5.12884129529184E-23
      3.16484951867400E-09   3.16516619111237E-09  -9.15703300294049E-19  -1.89453886493274E-01  -1.89453886493335E-01
      0.00000000000000E+00   0.00000000000000E+00   6.10424769730893E-11   0.00000000000000E+00   6.10424769730893E-11
      4.02352817529747E-18  -2.15162142272702E-01  -2.14145716392578E-01   0.00000000000000E+00  -1.20084474289688E-12
     -9.90866362331049E-23  -3.22500782334248E-09  -3.22620866808548E-09  -3.10782487500342E-18
      3.85514279731315E-09
      0.00000000000000E+00  -4.04943446347985E-12   0.00000000000000E+00   8.89631402139958E-13   7.28435516794645E-23
      4.04851919876991E-09   4.04940883017213E-09  -9.01207275723458E-19  -1.96224311318600E-01  -1.96224311318105E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.95444646337005E-10   0.00000000000000E+00  -4.95444646337005E-10
      3.99875594298062E-18  -2.15176526850146E-01  -2.14056845229942E-01   0.00000000000000E+00   3.45946131476379E-12
     -9.83721624698163E-23  -3.55742364514977E-09  -3.55396418383511E-09  -3.09754866725716E-18
      3.90514279731315E-09
      0.00000000000000E+00  -5.49332557711938E-12   0.00000000000000E+00   1.44842392715887E-12   1.13598106132272E-22
      5.49190968697343E-09   5.49335811090071E-09  -8.77288575920953E-19  -2.07471723048535E-01  -2.07471723047432E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10364696554384E-09   0.00000000000000E+00  -1.10364696554384E-09
      3.94357359470343E-18  -2.08458956164960E-01  -2.07075969879229E-01   0.00000000000000E+00   8.59953431250530E-12
     -9.64968480860679E-23  -4.39831067966924E-09  -4.38971114535683E-09  -3.06628501878248E-18
      3.95514279731315E-09
      0.00000000000000E+00  -7.25913249467129E-12   0.00000000000000E+00   1.76665734475792E-12   1.68437764614567E-22
      7.25736384669785E-09   7.25913050404278E-09  -8.50298022416409E-19  -2.20274384549605E-01  -2.20274384547987E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.61781741167197E-09   0.00000000000000E+00  -1.61781741167197E-09
      3.86268272411983E-18  -1.92226912208637E-01  -1.90449596893444E-01   0.00000000000000E+00   1.25307802832284E-11
     -9.34874457910183E-23  -5.65384387265394E-09  -5.64131309237081E-09  -3.01238470170342E-18
      4.00514279731315E-09
      0.00000000000000E+00  -8.98186423047287E-12   0.00000000000000E+00   1.72323024642757E-12   2.25136023029840E-22
      8.98012405609771E-09   8.98184728634436E-09  -8.25235371457522E-19  -2.32472153652115E-01  -2.32472153650068E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.04620145910880E-09   0.00000000000000E+00  -2.04620145910880E-09
      3.76037265116439E-18  -1.65286079155283E-01  -1.63100963373282E-01   0.00000000000000E+00   1.46998511090700E-11
     -8.95811590067945E-23  -6.95034567834455E-09  -6.93564582723557E-09  -2.93513727970687E-18
      4.05514279731315E-09
      0.00000000000000E+00  -1.03013057251962E-11   0.00000000000000E+00   1.31896902182264E-12   2.70263609869538E-22
      1.02999447755558E-08   1.03012637445779E-08  -8.04144867296547E-19  -2.43258680940184E-01  -2.43258680937775E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.40826221934439E-09   0.00000000000000E+00  -2.40826221934439E-09
      3.63995954019717E-18  -1.29399443870242E-01  -1.26912686024157E-01   0.00000000000000E+00   1.46817389925853E-11
     -8.50315083697019E-23  -7.90768326422605E-09  -7.89300152523355E-09  -2.83581467290062E-18
      4.10514279731314E-09
      0.00000000000000E+00  -1.08125135324933E-11   0.00000000000000E+00   5.16875209722364E-13   2.89428821161244E-22
      1.08119910352145E-08   1.08125079104246E-08  -7.88632099007227E-19  -2.51865331183953E-01  -2.51865331181410E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.54227982508623E-09   0.00000000000000E+00  -2.54227982508623E-09
      3.51284554894286E-18  -9.08633861585475E-02  -8.82577603497230E-02   0.00000000000000E+00   1.20775940562740E-11
     -7.02027557673345E-23  -8.28230567939451E-09  -8.27022808533831E-09  -2.72421344993563E-18
      4.15514279731314E-09
      0.00000000000000E+00  -1.00635197005659E-11   0.00000000000000E+00  -7.32263072092539E-13   2.73438831469814E-22
      1.00642872827906E-08   1.00635550197188E-08  -7.80851494695440E-19  -2.56974489814352E-01  -2.56974489812213E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.13912201476147E-09   0.00000000000000E+00  -2.13912201476147E-09
      3.40588944820479E-18  -5.97660167961647E-02  -5.72693237538729E-02   0.00000000000000E+00   7.78919207463694E-12
     -1.70820758485344E-23  -7.93222219703195E-09  -7.92443300495733E-09  -2.62503795350935E-18
      4.20514279731314E-09
      0.00000000000000E+00  -8.04706849517466E-12   0.00000000000000E+00  -1.94449815373238E-12   2.25938262719288E-22
      8.04899146144411E-09   8.04704696329061E-09  -7.85029629779310E-19  -2.56196087449587E-01  -2.56196087448592E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.95354019399869E-10   0.00000000000000E+00  -9.95354019399869E-10
      3.35612174723479E-18  -4.34314578475210E-02  -4.12097403389078E-02   0.00000000000000E+00   3.16620000828825E-12
      2.90637413566638E-23  -7.05485914389908E-09  -7.05169294389076E-09  -2.57109211745548E-18
      4.25514279731314E-09
      0.00000000000000E+00  -5.48836596131018E-12   0.00000000000000E+00  -2.54281406325608E-12   1.51895383334888E-22
      5.49092876570257E-09   5.48838595163946E-09  -8.08985514368056E-19  -2.45846803643948E-01  -2.45846803644599E-01
      0.00000000000000E+00   0.00000000000000E+00   6.50728728989879E-10   0.00000000000000E+00   6.50728728989879E-10
      3.38865818368429E-18  -4.11770312441435E-02  -3.92428162324173E-02   0.00000000000000E+00  -1.33004847451302E-12
     -2.29159272228330E-24  -6.13778463215484E-09  -6.13911468062936E-09  -2.57967266931623E-18
      4.30514279731314E-09
      0.00000000000000E+00  -2.77077203207667E-12   0.00000000000000E+00  -2.56803645192074E-12   6.86672511607539E-23
      2.77347651702849E-09   2.77090848057663E-09  -8.56784398153835E-19  -2.23720986099953E-01  -2.23720986102367E-01
      0.00000000000000E+00   0.00000000000000E+00   2.41415874091666E-09   0.00000000000000E+00   2.41415874091666E-09
      3.50936612073012E-18  -5.25612011733028E-02  -5.09276201618610E-02   0.00000000000000E+00  -7.13968615511365E-12
     -6.45935037882907E-23  -5.17792753533810E-09  -5.18506722149328E-09  -2.65258172257628E-18
      4.35514279731314E-09
      0.00000000000000E+00  -2.17029114021386E-13   0.00000000000000E+00  -2.59547690848436E-12  -1.05557487852231E-24
      2.19618372493460E-10   2.17022895584974E-10  -9.28554956873432E-19  -1.89016610630625E-01  -1.89016610634569E-01
      0.00000000000000E+00   0.00000000000000E+00   3.94381092559379E-09   0.00000000000000E+00   3.94381092559379E-09
      3.70655666700981E-18  -7.73695680820687E-02  -7.60586349124423E-02   0.00000000000000E+00  -1.60847240217623E-11
     -8.65683459433221E-23  -4.14474909715694E-09  -4.16083382117879E-09  -2.77800171013637E-18
      4.40514279731314E-09
      0.00000000000000E+00   1.27700922613345E-12   0.00000000000000E+00  -1.57706953980630E-12  -3.59033911004987E-23
     -1.27539846998417E-09  -1.27697553952402E-09  -1.01731090092941E-18  -1.44239138951036E-01  -1.44239138955722E-01
      0.00000000000000E+00   0.00000000000000E+00   4.68515150139573E-09   0.00000000000000E+00   4.68515150139573E-09
      3.94081424207960E-18  -1.08445737062237E-01  -1.07371941045819E-01   0.00000000000000E+00  -2.87867341384545E-11
     -9.36002133715040E-23  -3.37938922773312E-09  -3.40817596187167E-09  -2.92350334115018E-18
      4.45514279731314E-09
      0.00000000000000E+00   1.66716566979103E-12   0.00000000000000E+00  -5.42186197886190E-13  -4.45261718477818E-23
     -1.66662040335608E-09  -1.66716258955401E-09  -1.10627941889665E-18  -9.70839135653325E-02  -9.70839135698642E-02
      0.00000000000000E+00   0.00000000000000E+00   4.53178153319532E-09   0.00000000000000E+00   4.53178153319532E-09
      4.16740331873936E-18  -1.39960653128542E-01  -1.39058104237781E-01   0.00000000000000E+00  -4.16679887442100E-11
     -1.02314553440492E-22  -2.82295095489704E-09  -2.86461894364135E-09  -3.06112389984270E-18
      4.50514279731314E-09
      0.00000000000000E+00   1.42846119778866E-12   0.00000000000000E+00   7.55026383986714E-14  -4.62921133115455E-23
     -1.42857320606354E-09  -1.42849770342518E-09  -1.17827267870749E-18  -5.70356299785318E-02  -5.70356299822718E-02
      0.00000000000000E+00   0.00000000000000E+00   3.74004448539186E-09   0.00000000000000E+00   3.74004448539186E-09
      4.35440554300895E-18  -1.69759028756805E-01  -1.69030732643654E-01   0.00000000000000E+00  -4.90608744004411E-11
     -1.10507394246334E-22  -2.26248590756612E-09  -2.31154678196667E-09  -3.17613286430147E-18
      4.55514279731314E-09
      0.00000000000000E+00   8.82536079827125E-13   0.00000000000000E+00   4.27631755094781E-13  -4.69115659445522E-23
     -8.82928236626956E-10  -8.82500604871909E-10  -1.22174569316275E-18  -3.20291724876576E-02  -3.20291724901957E-02
      0.00000000000000E+00   0.00000000000000E+00   2.53811474785258E-09   0.00000000000000E+00   2.53811474785258E-09
      4.48131128040159E-18  -1.96556863946793E-01  -1.96035230539391E-01   0.00000000000000E+00  -4.50670650993933E-11
     -1.16957148174896E-22  -1.61054707788115E-09  -1.65561414298067E-09  -3.25956558723884E-18
      4.60514279731314E-09
      0.00000000000000E+00   4.42232409654241E-13   0.00000000000000E+00   3.80016775609255E-13  -4.71732919577995E-23
     -4.42657480904541E-10  -4.42277464128978E-10  -1.24289921447844E-18  -1.97728041038879E-02  -1.97728041054096E-02
      0.00000000000000E+00   0.00000000000000E+00   1.52171131267654E-09   0.00000000000000E+00   1.52171131267654E-09
      4.55739684603541E-18  -2.17951553243289E-01  -2.17611456693714E-01   0.00000000000000E+00  -3.35890061114459E-11
     -1.21334699454432E-22  -1.04584484243597E-09  -1.07943384854754E-09  -3.31449763155697E-18
      4.65514279731314E-09
      0.00000000000000E+00   2.32918253558288E-13   0.00000000000000E+00   1.82929162591764E-13  -4.72900457160499E-23
     -2.33070299458149E-10  -2.32887370295605E-10  -1.25349847856362E-18  -1.37869698631380E-02  -1.37869698640844E-02
      0.00000000000000E+00   0.00000000000000E+00   9.46312196238650E-10   0.00000000000000E+00   9.46312196238650E-10
      4.60471245584734E-18  -2.33538583595427E-01  -2.33313806182136E-01   0.00000000000000E+00  -2.31264366103771E-11
     -1.24176088660044E-22  -6.90298389332578E-10  -7.13424825943079E-10  -3.35121397728372E-18
      4.70514279731314E-09
      0.00000000000000E+00   1.43277790043742E-13   0.00000000000000E+00   7.75768407253204E-14  -4.73456361933911E-23
     -1.43379810606851E-10  -1.43302233766173E-10  -1.25960033702061E-18  -1.05319273253100E-02  -1.05319273259603E-02
      0.00000000000000E+00   0.00000000000000E+00   6.50264819738404E-10   0.00000000000000E+00   6.50264819738404E-10
      4.63722569683426E-18  -2.44889178826833E-01  -2.44729452058362E-01   0.00000000000000E+00  -1.60659119583677E-11
     -1.26074120290915E-22  -4.90896674013718E-10  -5.06962585972212E-10  -3.37762535981365E-18
      4.75514279731314E-09
      0.00000000000000E+00   9.84575582864687E-14   0.00000000000000E+00   3.99229789420703E-14  -4.73697907364008E-23
     -9.84983205123949E-11  -9.84583975335002E-11  -1.26346908384255E-18  -8.63795234189742E-03  -8.63795234238677E-03
      0.00000000000000E+00   0.00000000000000E+00   4.89354034580760E-10   0.00000000000000E+00   4.89354034580760E-10
      4.66169339856330E-18  -2.53630501343238E-01  -2.53507344343924E-01   0.00000000000000E+00  -1.16842346528099E-11
     -1.27415607966461E-22  -3.79211402394338E-10  -3.90895637047276E-10  -3.39822431472075E-18
      4.80514279731314E-09
      0.00000000000000E+00   7.05367581753806E-14   0.00000000000000E+00   2.71554829201603E-14  -4.73741251730104E-23
     -7.05305412559958E-11  -7.05033857731230E-11  -1.26596609783143E-18  -7.55299953182635E-03  -7.55299953223610E-03
      0.00000000000000E+00   0.00000000000000E+00   4.09748831587919E-10   0.00000000000000E+00   4.09748831587919E-10
      4.68218084014270E-18  -2.61417703955950E-01  -2.61310820664721E-01   0.00000000000000E+00  -9.77252183204103E-12
     -1.28511302150401E-22  -3.29472923982641E-10  -3.39245445814810E-10  -3.41621474231127E-18
      4.85514279731314E-09
      0.00000000000000E+00   4.45446975456505E-14   0.00000000000000E+00   2.86813349501729E-14  -4.73597359183921E-23
     -4.46137121525237E-11  -4.45850308176209E-11  -1.26721469942780E-18  -7.12938280540520E-03  -7.12938280581766E-03
      0.00000000000000E+00   0.00000000000000E+00   4.12455256204041E-10   0.00000000000000E+00   4.12455256204041E-10
      4.70280360295290E-18  -2.70935688006716E-01  -2.70819785703807E-01   0.00000000000000E+00  -1.16394351289642E-11
     -1.29789672926082E-22  -3.56230790257347E-10  -3.67870225386441E-10  -3.43558890352510E-18
      4.90514279731314E-09
      0.00000000000000E+00   6.24544213011182E-15   0.00000000000000E+00   4.62516050248954E-14  -4.73164915434563E-23
     -6.30002404945601E-12  -6.25377244447844E-12  -1.26663019203396E-18  -7.67193528159377E-03  -7.67193528202746E-03
      0.00000000000000E+00   0.00000000000000E+00   4.33681627580347E-10   0.00000000000000E+00   4.33681627580347E-10
      4.72448768433191E-18  -2.83564417298375E-01  -2.83429749814834E-01   0.00000000000000E+00  -1.51857874603628E-11
     -1.31426775927528E-22  -4.12242067675321E-10  -4.27427855135815E-10  -3.45785749229796E-18
      4.93014279731314E-09
      0.00000000000000E+00  -2.95740053808236E-14   0.00000000000000E+00   8.41749664948563E-14  -4.72802522855665E-23
      2.94910977485666E-11   2.95752727150142E-11  -1.26547183920664E-18  -8.42623564615600E-03  -8.42623564656631E-03
      0.00000000000000E+00   0.00000000000000E+00   4.10303317298227E-10   0.00000000000000E+00   4.10303317298227E-10
      4.73474526726437E-18  -2.90580294168977E-01  -2.90441703684055E-01   0.00000000000000E+00  -1.62944282836331E-11
     -1.32291756844167E-22  -4.23584161729503E-10  -4.39878590013268E-10  -3.46927342805773E-18
      4.96389279731314E-09
      0.00000000000000E+00  -1.37491571599668E-13   0.00000000000000E+00   1.86671436275987E-13  -4.71716149301364E-23
      1.37320800525963E-10   1.37507471962192E-10  -1.26036791275942E-18  -1.14890887718274E-02  -1.14890887720724E-02
      0.00000000000000E+00   0.00000000000000E+00   2.45017515041037E-10   0.00000000000000E+00   2.45017515041037E-10
      4.74301460839701E-18  -3.00562653355996E-01  -3.00442133990986E-01   0.00000000000000E+00  -1.32966459955103E-11
     -1.33239739331451E-22  -3.69228341007624E-10  -3.82524987003268E-10  -3.48264669563760E-18
      5.00945529731314E-09
      0.00000000000000E+00  -4.96053425657852E-13   0.00000000000000E+00   4.65104752539065E-13  -4.67592005251932E-23
      4.95569968263627E-10   4.96035073016120E-10  -1.23773897738171E-18  -2.46330833960294E-02  -2.46330833956919E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.37503616792594E-10   0.00000000000000E+00  -3.37503616792594E-10
      4.72763709985690E-18  -3.14873072160881E-01  -3.14823129196207E-01   0.00000000000000E+00  -2.65826004367501E-13
     -1.33285253165900E-22  -1.58265630218985E-10  -1.58531456223485E-10  -3.48989812247519E-18
      5.03445529731314E-09
      0.00000000000000E+00  -8.26970013816571E-13   0.00000000000000E+00   7.66494045076274E-13  -4.63759827124396E-23
      8.26210974465664E-10   8.26977468510694E-10  -1.21745565885921E-18  -3.61877907326581E-02  -3.61877907317973E-02
      0.00000000000000E+00   0.00000000000000E+00  -8.60791303907587E-10   0.00000000000000E+00  -8.60791303907587E-10
      4.70611731725920E-18  -3.23111953288758E-01  -3.23122615245892E-01   0.00000000000000E+00   1.12564723448092E-11
     -1.32711758456660E-22   2.25573630521926E-11   3.38138353968692E-11  -3.48866165840000E-18
      5.06820529731314E-09
      0.00000000000000E+00  -1.15705999934042E-12   0.00000000000000E+00   6.21207356086008E-13  -4.55133914972393E-23
      1.15647158392622E-09   1.15709279128226E-09  -1.18051969770317E-18  -5.67217675988587E-02  -5.67217675975161E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.34260150621796E-09   0.00000000000000E+00  -1.34260150621796E-09
      4.66080451642435E-18  -3.34242308974736E-01  -3.34300769096079E-01   0.00000000000000E+00   2.11514568422057E-11
     -1.31198003549591E-22   1.64357258093608E-10   1.85508714935682E-10  -3.48028481872119E-18
      5.11376779731314E-09
      0.00000000000000E+00  -1.50083485070819E-12   0.00000000000000E+00   5.10420464232843E-13  -4.23653990264204E-23
      1.50034492864202E-09   1.50085534910621E-09  -1.12225204248700E-18  -8.79328829619985E-02  -8.79328829603192E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.67929715029721E-09   0.00000000000000E+00  -1.67929715029721E-09
      4.58429154001393E-18  -3.47995464429547E-01  -3.48051705508558E-01   0.00000000000000E+00   2.69031553408818E-11
     -1.28459241699708E-22   1.51538645850257E-10   1.78441801191011E-10  -3.46203949752693E-18
      5.16376779731314E-09
      0.00000000000000E+00  -2.08707980830384E-12   0.00000000000000E+00   6.99533805825777E-13  -2.87744304864790E-23
      2.08638898975299E-09   2.08708852355878E-09  -1.05335944295983E-18  -1.23149313309971E-01  -1.23149313308051E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.92029270661629E-09   0.00000000000000E+00  -1.92029270661629E-09
      4.48827690468312E-18  -3.59761345723561E-01  -3.59708831935363E-01   0.00000000000000E+00   3.00082043212051E-11
     -1.24871800694809E-22  -1.96804021263599E-10  -1.66795816942518E-10  -3.43491746172329E-18
      5.21376779731314E-09
      0.00000000000000E+00  -3.42397180309660E-12   0.00000000000000E+00   1.41829695318630E-12   1.66841301299388E-23
      3.42255186076704E-09   3.42397015772025E-09  -9.82098593175307E-19  -1.57848383771142E-01  -1.57848383768933E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.20949377067854E-09   0.00000000000000E+00  -2.20949377067854E-09
      4.37780221614919E-18  -3.64233687964224E-01  -3.63851125470824E-01   0.00000000000000E+00   3.43613490706124E-11
     -1.20437946030579E-22  -1.24883773611221E-09  -1.21447638704171E-09  -3.39570362297388E-18
      5.26376779731314E-09
      0.00000000000000E+00  -6.00306386862116E-12   0.00000000000000E+00   2.61767468683628E-12   1.08215987274920E-22
      6.00044390384789E-09   6.00306157853483E-09  -9.15259700137684E-19  -1.89081590558773E-01  -1.89081590556224E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.54899256691781E-09   0.00000000000000E+00  -2.54899256691781E-09
      4.25035258780330E-18  -3.53935687914565E-01  -3.52847568920959E-01   0.00000000000000E+00   4.04422482604945E-11
     -1.14794203429349E-22  -3.49451125987741E-09  -3.45406901161703E-09  -3.33509288766562E-18
      5.31376779731314E-09
      0.00000000000000E+00  -9.23746813412142E-12   0.00000000000000E+00   3.23788172566616E-12   2.25208338070508E-22
      9.23425856755126E-09   9.23749644927715E-09  -8.62885824745927E-19  -2.13112730828228E-01  -2.13112730825409E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.81897328235437E-09   0.00000000000000E+00  -2.81897328235437E-09
      4.10940392368558E-18  -3.22731109960247E-01  -3.20709038625122E-01   0.00000000000000E+00   4.42329541250449E-11
     -1.08199972059760E-22  -6.46275612104768E-09  -6.41852316692275E-09  -3.24651809893965E-18
      5.36376779731314E-09
      0.00000000000000E+00  -1.17130511808131E-11   0.00000000000000E+00   2.47062836198953E-12   3.17807362510885E-22
      1.17105792968070E-08   1.17130499251693E-08  -8.27534609471567E-19  -2.29689767621842E-01  -2.29689767618849E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.99282452750316E-09   0.00000000000000E+00  -2.99282452750316E-09
      3.95976269731043E-18  -2.73395550302984E-01  -2.70648284199351E-01   0.00000000000000E+00   4.17159620149816E-11
     -1.01204982005278E-22  -8.76194135968099E-09  -8.72022539766611E-09  -3.13222808783886E-18
      5.41376779731314E-09
      0.00000000000000E+00  -1.30061332359579E-11   0.00000000000000E+00   1.29331801935236E-12   3.66364594343008E-22
      1.30048153419626E-08   1.30061086599823E-08  -8.03816869988927E-19  -2.41487052151045E-01  -2.41487052147982E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.06381474965154E-09   0.00000000000000E+00  -3.06381474965154E-09
      3.80657195982785E-18  -2.16399682930380E-01  -2.13267343952142E-01   0.00000000000000E+00   3.32655185069496E-11
     -9.40984508112216E-23  -9.97555942883764E-09  -9.94229391033079E-09  -3.00275508983892E-18
      5.46376779731314E-09
      0.00000000000000E+00  -1.33980347296224E-11   0.00000000000000E+00   3.98263170214724E-13   3.80082896010394E-22
      1.33976594248830E-08   1.33980576880536E-08  -7.86855405750388E-19  -2.50645518604696E-01  -2.50645518601622E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.07389317916703E-09   0.00000000000000E+00  -3.07389317916703E-09
      3.65287730086950E-18  -1.58505516591380E-01  -1.55252818939141E-01   0.00000000000000E+00   2.48708795151327E-11
     -8.76421394212771E-23  -1.03490353884016E-08  -1.03241645088866E-08  -2.86602189511911E-18
      5.51376779731314E-09
      0.00000000000000E+00  -1.32387759553045E-11   0.00000000000000E+00  -1.48663578784013E-13   3.72287059608317E-22
      1.32389586687198E-08   1.32388100051414E-08  -7.73539899214391E-19  -2.58459184816507E-01  -2.58459184813456E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.05076381378504E-09   0.00000000000000E+00  -3.05076381378504E-09
      3.50033911018024E-18  -1.04140005732826E-01  -1.00930158342031E-01   0.00000000000000E+00   1.79851849084541E-11
     -7.49202964003106E-23  -1.02060313762647E-08  -1.01880461913564E-08  -2.72679921096585E-18
      5.56376779731314E-09
      0.00000000000000E+00  -1.26231406818025E-11   0.00000000000000E+00  -5.98802267309530E-13   3.53904219148944E-22
      1.26237551553514E-08   1.26231563530844E-08  -7.60033362076382E-19  -2.66410023039539E-01  -2.66410023036558E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.98054850454923E-09   0.00000000000000E+00  -2.98054850454923E-09
      3.35131168495278E-18  -5.96791390483375E-02  -5.66411145434554E-02   0.00000000000000E+00   1.19655633535439E-11
      8.29834448040825E-24  -9.65457341188873E-09  -9.64260784853518E-09  -2.59127832287640E-18
      5.61376779731314E-09
      0.00000000000000E+00  -1.14069326717004E-11   0.00000000000000E+00  -1.18601620958021E-12   3.50493091848552E-22
      1.14080740025050E-08   1.14068879862958E-08  -7.39000258048417E-19  -2.77190306126135E-01  -2.77190306123327E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.80813049561730E-09   0.00000000000000E+00  -2.80813049561730E-09
      3.21090516017192E-18  -3.27013887464929E-02  -2.99922296640481E-02   0.00000000000000E+00   7.25874477599757E-12
      1.79614487019410E-22  -8.60601623545465E-09  -8.59875749067848E-09  -2.47190490212350E-18
      5.66376779731314E-09
      0.00000000000000E+00  -1.02390349933695E-11   0.00000000000000E+00  -1.13136657597057E-12   3.62887818461648E-22
      1.02401585136834E-08   1.02390271471078E-08  -7.10628703194249E-19  -2.90662072854769E-01  -2.90662072852151E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.61792945341416E-09   0.00000000000000E+00  -2.61792945341416E-09
      3.08000868750121E-18  -2.01254383900290E-02  -1.77242991177615E-02   0.00000000000000E+00   4.30606733548353E-12
      3.37012718847764E-22  -7.62540376102949E-09  -7.62109769369367E-09  -2.36937998430696E-18
      5.71376779731314E-09
      0.00000000000000E+00  -9.52631983263909E-12   0.00000000000000E+00  -6.85542753858430E-13   3.70524741378828E-22
      9.52696383252337E-09   9.52627828976988E-09  -6.80200293796747E-19  -3.04895585858450E-01  -3.04895585855943E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.50682781414663E-09   0.00000000000000E+00  -2.50682781414663E-09
      2.95466729679388E-18  -1.42720803932966E-02  -1.20604943272235E-02   0.00000000000000E+00   2.76072641158226E-12
      4.38048747276156E-22  -7.02221120203523E-09  -7.01945047562321E-09  -2.27446700299713E-18
      5.76376779731314E-09
      0.00000000000000E+00  -9.22562016302165E-12   0.00000000000000E+00  -2.79437923299646E-13   3.67424131089162E-22
      9.22590753431346E-09   9.22562809639053E-09  -6.48730002622671E-19  -3.19659078922542E-01  -3.19659078920000E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.54200493989748E-09   0.00000000000000E+00  -2.54200493989748E-09
      2.82756704979900E-18  -1.10939767383056E-02  -8.98819575951278E-03   0.00000000000000E+00   2.10891487906295E-12
      4.90957266576828E-22  -6.68573207137259E-09  -6.68362315649304E-09  -2.17883704717633E-18
      5.81376779731313E-09
      0.00000000000000E+00  -9.24215221571900E-12   0.00000000000000E+00   3.36825022288853E-14   3.54749033099567E-22
      9.24208186283571E-09   9.24211554533829E-09  -6.14859454479979E-19  -3.35569757184687E-01  -3.35569757181960E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.72708757133513E-09   0.00000000000000E+00  -2.72708757133513E-09
      2.69121267123225E-18  -9.08858807882893E-03  -7.03592361582245E-03   0.00000000000000E+00   1.88147306401010E-12
      5.10087470102097E-22  -6.51690944706769E-09  -6.51502797400317E-09  -2.07635321675227E-18
      5.86376779731313E-09
      0.00000000000000E+00  -9.15287913115329E-12   0.00000000000000E+00  -7.19305378579892E-14   3.24041491442701E-22
      9.15287419628075E-09   9.15280226574322E-09  -5.82153134982816E-19  -3.51058513604005E-01  -3.51058513601278E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.72711558797844E-09   0.00000000000000E+00  -2.72711558797844E-09
      2.55485689183332E-18  -7.71803957390202E-03  -5.69352154702678E-03   0.00000000000000E+00   1.62697013502546E-12
      4.87894644129958E-22  -6.42731364790034E-09  -6.42568667776483E-09  -1.97270375685051E-18
      5.91376779731313E-09
      0.00000000000000E+00  -8.87422219846565E-12   0.00000000000000E+00  -2.61336781498946E-13   2.77276688386466E-22
      8.87445685441791E-09   8.87419551763669E-09  -5.53633968166377E-19  -3.64732336150983E-01  -3.64732336148487E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.49573631038354E-09   0.00000000000000E+00  -2.49573631038354E-09
      2.43007007631415E-18  -6.77751765217248E-03  -4.76787764825290E-03   0.00000000000000E+00   1.31105393680206E-12
      4.29303341013557E-22  -6.37977026119035E-09  -6.37845920725312E-09  -1.87643610814777E-18
      5.96376779731313E-09
      0.00000000000000E+00  -8.31433668044857E-12   0.00000000000000E+00  -5.42892294681388E-13   2.21147346752044E-22
      8.31490062029242E-09   8.31435772799796E-09  -5.33554770242951E-19  -3.74688225048183E-01  -3.74688225046251E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.93191014992006E-09   0.00000000000000E+00  -1.93191014992006E-09
      2.33347456881814E-18  -6.16927533676769E-03  -4.15837723084757E-03   0.00000000000000E+00   8.46498933885584E-13
      3.47364832582317E-22  -6.38329407701213E-09  -6.38244757807790E-09  -1.79991979857520E-18
      6.01376779731313E-09
      0.00000000000000E+00  -7.05771698597519E-12   0.00000000000000E+00  -1.23842263792319E-12   1.59149640191255E-22
      7.05891854273138E-09   7.05768012009362E-09  -5.33733981654534E-19  -3.75983243021077E-01  -3.75983243020473E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.04679262857398E-10   0.00000000000000E+00  -6.04679262857398E-10
      2.30324060567528E-18  -5.89184365018308E-03  -3.85871547659033E-03   0.00000000000000E+00  -8.56305441999319E-14
      2.49886443525710E-22  -6.45291522669226E-09  -6.45300085723621E-09  -1.76950662402074E-18
      6.06376779731313E-09
      0.00000000000000E+00  -4.65028273429149E-12   0.00000000000000E+00  -2.39043975538128E-12   9.04986479377364E-23
      4.65267170106876E-09   4.65028126131347E-09  -5.74459718376636E-19  -3.60340695079567E-01  -3.60340695081393E-01
      0.00000000000000E+00   0.00000000000000E+00   1.82640365211912E-09   0.00000000000000E+00   1.82640365211912E-09
      2.39456078828123E-18  -6.10631987126724E-03  -4.06572956567550E-03   0.00000000000000E+00  -1.86520436122489E-12
      1.36203482351717E-22  -6.47481970907150E-09  -6.47668491343259E-09  -1.82010106990460E-18
      6.11376779731313E-09
      0.00000000000000E+00  -1.93755657612998E-12   0.00000000000000E+00  -2.72228170398130E-12   1.93769372341909E-23
      1.94024367600998E-09   1.93752139430602E-09  -6.65748745432274E-19  -3.23279436962341E-01  -3.23279436966760E-01
      0.00000000000000E+00   0.00000000000000E+00   4.41952417181547E-09   0.00000000000000E+00   4.41952417181547E-09
      2.61553699687201E-18  -8.03405145028612E-03  -6.03115704552825E-03   0.00000000000000E+00  -4.96352110928295E-12
      1.02277337813751E-23  -6.35208204501222E-09  -6.35704556612150E-09  -1.94978825143973E-18
      6.16376779731313E-09
      0.00000000000000E+00   2.83800237971258E-14   0.00000000000000E+00  -1.99961917411098E-12  -2.81347967446184E-23
     -2.63516695455001E-11  -2.83512887196393E-11  -7.89389990715307E-19  -2.69976720952640E-01  -2.69976720958516E-01
      0.00000000000000E+00   0.00000000000000E+00   5.87587935424927E-09   0.00000000000000E+00   5.87587935424927E-09
      2.90933096458447E-18  -1.70294824042128E-02  -1.51871313087633E-02   0.00000000000000E+00  -1.01818769878847E-11
     -6.97266837178808E-23  -5.83734618854168E-09  -5.84752806552963E-09  -2.11994097386916E-18
      6.21376779731313E-09
      0.00000000000000E+00   1.53830750348887E-12   0.00000000000000E+00  -1.61423528194839E-12  -4.13587772489545E-23
     -1.53666453952952E-09  -1.53827877481151E-09  -9.13833434308173E-19  -2.11524989436244E-01  -2.11524989442481E-01
      0.00000000000000E+00   0.00000000000000E+00   6.23742367521188E-09   0.00000000000000E+00   6.23742367521188E-09
      3.22120214834506E-18  -4.13521390498571E-02  -3.98715962695330E-02   0.00000000000000E+00  -1.92209321479382E-11
     -8.42691967106834E-23  -4.67992396825240E-09  -4.69914490040042E-09  -2.30736871403689E-18
      6.26376779731313E-09
      0.00000000000000E+00   2.10820409786157E-12   0.00000000000000E+00  -7.24602990419140E-13  -4.40665194751829E-23
     -2.10747662375724E-09  -2.10820122674770E-09  -1.02848552982105E-18  -1.53392978030369E-01  -1.53392978036263E-01
      0.00000000000000E+00   0.00000000000000E+00   5.89364082418693E-09   0.00000000000000E+00   5.89364082418693E-09
      3.51588418955441E-18  -7.43020256194981E-02  -7.31093580528851E-02   0.00000000000000E+00  -3.25317543855067E-11
     -9.32527776494481E-23  -3.75290784305355E-09  -3.78543959743915E-09  -2.48739865973335E-18
      6.31376779731313E-09
      0.00000000000000E+00   2.02232926857253E-12   0.00000000000000E+00  -1.09386001267422E-13  -4.55455750849981E-23
     -2.02215261337918E-09  -2.02226199938049E-09  -1.12913258331300E-18  -9.88774047907843E-02  -9.88774047959858E-02
      0.00000000000000E+00   0.00000000000000E+00   5.20154511626919E-09   0.00000000000000E+00   5.20154511626919E-09
      3.77596144536787E-18  -1.09409585946667E-01  -1.08407895849487E-01   0.00000000000000E+00  -4.74360073287244E-11
     -1.03019999891572E-22  -3.13184710955988E-09  -3.17928311688871E-09  -2.64682886205486E-18
      6.36376779731313E-09
      0.00000000000000E+00   1.60195590637368E-12   0.00000000000000E+00   2.22165589595192E-13  -4.68229935373852E-23
     -1.60216335334925E-09  -1.60194118775970E-09  -1.20671433814598E-18  -5.44020007400421E-02  -5.44020007442597E-02
      0.00000000000000E+00   0.00000000000000E+00   4.21758754996994E-09   0.00000000000000E+00   4.21758754996994E-09
      3.98684082286637E-18  -1.44891429833036E-01  -1.44067321800488E-01   0.00000000000000E+00  -5.84235983631173E-11
     -1.12333539815727E-22  -2.55722276384701E-09  -2.61564636221024E-09  -2.78012648472039E-18
      6.41376779731313E-09
      0.00000000000000E+00   9.19825043133380E-13   0.00000000000000E+00   5.49806407593349E-13  -4.75130123399789E-23
     -9.20300221284161E-10  -9.19750414876615E-10  -1.24987795371691E-18  -2.86381887706604E-02  -2.86381887735159E-02
      0.00000000000000E+00   0.00000000000000E+00   2.85552436325964E-09   0.00000000000000E+00   2.85552436325964E-09
      4.12961704102935E-18  -1.80192170525424E-01  -1.79582267654295E-01   0.00000000000000E+00  -5.73125603264298E-11
     -1.20155317692971E-22  -1.87846138805649E-09  -1.93577394838304E-09  -2.87973908731244E-18
      6.46376779731313E-09
      0.00000000000000E+00   4.27537251701037E-13   0.00000000000000E+00   4.35064202017857E-13  -4.77700846904298E-23
     -4.27927219287371E-10  -4.27492155085401E-10  -1.26843732875515E-18  -1.73461191214984E-02  -1.73461191232621E-02
      0.00000000000000E+00   0.00000000000000E+00   1.76369598730701E-09   0.00000000000000E+00   1.76369598730701E-09
      4.21780184039470E-18  -2.10996131831589E-01  -2.10575135077883E-01   0.00000000000000E+00  -4.69287543519932E-11
     -1.25914774831091E-22  -1.28927507786949E-09  -1.33620383222160E-09  -2.94936451163955E-18
      6.51376779731313E-09
      0.00000000000000E+00   2.24560382472403E-13   0.00000000000000E+00   1.81998611825501E-13  -4.78623552799026E-23
     -2.24712054051016E-10  -2.24530055439238E-10  -1.27689957126625E-18  -1.22830091537072E-02  -1.22830091548422E-02
      0.00000000000000E+00   0.00000000000000E+00   1.13507846660058E-09   0.00000000000000E+00   1.13507846660058E-09
      4.27455576372473E-18  -2.33786127420371E-01  -2.33499242524111E-01   0.00000000000000E+00  -3.41887725358806E-11
     -1.29822703707574E-22  -8.76359638625329E-10  -9.10548411161339E-10  -2.99765619245847E-18
      6.56376779731313E-09
      0.00000000000000E+00   1.50533524283136E-13   0.00000000000000E+00   6.66433996221078E-14  -4.78976072380574E-23
     -1.50559912637206E-10  -1.50493269237632E-10  -1.28170992197286E-18  -9.59262193509221E-03  -9.59262193586815E-03
      0.00000000000000E+00   0.00000000000000E+00   7.75946363598043E-10   0.00000000000000E+00   7.75946363598043E-10
      4.31335308190463E-18  -2.49067683064202E-01  -2.48870624527437E-01   0.00000000000000E+00  -2.27503061558817E-11
     -1.32311569829088E-22  -6.02702788204405E-10  -6.25453094360420E-10  -3.03164315993177E-18
      6.61376779731313E-09
      0.00000000000000E+00   1.18479710997710E-13   0.00000000000000E+00   2.98637566009640E-14  -4.79087280589745E-23
     -1.18538828798716E-10  -1.18508965042163E-10  -1.28496723895409E-18  -7.92830812198466E-03  -7.92830812257183E-03
      0.00000000000000E+00   0.00000000000000E+00   5.87168851046300E-10   0.00000000000000E+00   5.87168851046300E-10
      4.34271152445695E-18  -2.59864760625536E-01  -2.59717103967204E-01   0.00000000000000E+00  -1.56394435416820E-11
     -1.33973570123074E-22  -4.53020442462331E-10  -4.68659886004147E-10  -3.05774428550286E-18
      6.66376779731313E-09
      0.00000000000000E+00   1.01121055665487E-13   0.00000000000000E+00   1.77971746117833E-14  -4.79072310216659E-23
     -1.01120185413744E-10  -1.01102388239180E-10  -1.28739867636457E-18  -6.79088473538158E-03  -6.79088473587333E-03
      0.00000000000000E+00   0.00000000000000E+00   4.91749922146068E-10   0.00000000000000E+00   4.91749922146068E-10
      4.36729902056425E-18  -2.68443579432760E-01  -2.68320502731819E-01   0.00000000000000E+00  -1.19707268321298E-11
     -1.35216481235767E-22  -3.78676807074621E-10  -3.90647533906886E-10  -3.07990034419968E-18
      6.71376779731313E-09
      0.00000000000000E+00   8.91812398285085E-14   0.00000000000000E+00   1.37981583574648E-14  -4.78975392505483E-23
     -8.92202280500163E-11  -8.92064298917067E-11  -1.28927937053486E-18  -5.98778642561164E-03  -5.98778642604950E-03
      0.00000000000000E+00   0.00000000000000E+00   4.37860688739023E-10   0.00000000000000E+00   4.37860688739023E-10
      4.38919205500120E-18  -2.75884647633374E-01  -2.75774802112051E-01   0.00000000000000E+00  -9.99713122845373E-12
     -1.36234014552748E-22  -3.38657127618702E-10  -3.48654258847292E-10  -3.09991268446634E-18
      6.73876779731313E-09
      0.00000000000000E+00   8.33950213844343E-14   0.00000000000000E+00   1.41628011803276E-14  -4.78906541916035E-23
     -8.34420397493913E-11  -8.34278769482589E-11  -1.29008629765736E-18  -5.66590960362499E-03  -5.66590960403993E-03
      0.00000000000000E+00   0.00000000000000E+00   4.14943110105071E-10   0.00000000000000E+00   4.14943110105071E-10
      4.39956563275383E-18  -2.79385387240275E-01  -2.79280941835139E-01   0.00000000000000E+00  -9.21892098567388E-12
     -1.36697409943019E-22  -3.22296312171124E-10  -3.31515233156935E-10  -3.10947933509646E-18
      6.77251779731313E-09
      0.00000000000000E+00   7.59555976706246E-14   0.00000000000000E+00   1.45570426924130E-14  -4.78778607495108E-23
     -7.59878265778718E-11  -7.59732695352272E-11  -1.29094578576836E-18  -5.33862090215512E-03  -5.33862090258549E-03
      0.00000000000000E+00   0.00000000000000E+00   4.30367858897593E-10   0.00000000000000E+00   4.30367858897593E-10
      4.41409054799162E-18  -2.84824728457227E-01  -2.84713074215481E-01   0.00000000000000E+00  -1.08943367905828E-11
     -1.37424142433778E-22  -3.43500252571615E-10  -3.54394589362336E-10  -3.12314476222326E-18
      6.81808029731313E-09
      0.00000000000000E+00   6.52097634173440E-14   0.00000000000000E+00   1.65929285429702E-14  -4.78536500882409E-23
     -6.52676744719694E-11  -6.52510815434743E-11  -1.29166427717664E-18  -5.06336379771391E-03  -5.06336379821277E-03
      0.00000000000000E+00   0.00000000000000E+00   4.98867311682230E-10   0.00000000000000E+00   4.98867311682230E-10
      4.43682018988014E-18  -2.95066704187813E-01  -2.94930088854592E-01   0.00000000000000E+00  -1.62547165744734E-11
     -1.38857411954108E-22  -4.17361513564139E-10  -4.33616230138751E-10  -3.14515591270350E-18
      6.86808029731313E-09
      0.00000000000000E+00   5.32699475803655E-14   0.00000000000000E+00   1.82990899728073E-14  -4.78186934196327E-23
     -5.32747266744382E-11  -5.32564275845132E-11  -1.29191775575741E-18  -4.98455558246079E-03  -4.98455558301532E-03
      0.00000000000000E+00   0.00000000000000E+00   5.54532360967348E-10   0.00000000000000E+00   5.54532360967348E-10
      4.46454680792851E-18  -3.09112674890706E-01  -3.08954741452742E-01   0.00000000000000E+00  -2.13274251159623E-11
     -1.40872311788889E-22  -4.79948508266737E-10  -5.01275933382840E-10  -3.17262905217110E-18
      6.91808029731313E-09
      0.00000000000000E+00   2.78289553738806E-14   0.00000000000000E+00   3.52202998477581E-14  -4.77629971401876E-23
     -2.78807443188632E-11  -2.78455240190632E-11  -1.29097493116490E-18  -5.58937637276182E-03  -5.58937637328468E-03
      0.00000000000000E+00   0.00000000000000E+00   5.22862969046588E-10   0.00000000000000E+00   5.22862969046588E-10
      4.49068995638084E-18  -3.23639821704990E-01  -3.23483860336963E-01   0.00000000000000E+00  -2.17850872244312E-11
     -1.42879752314360E-22  -4.73232357802960E-10  -4.95017445027534E-10  -3.19971502521593E-18
      6.96808029731313E-09
      0.00000000000000E+00  -8.08233687426235E-14   0.00000000000000E+00   1.34291038325705E-13  -4.76107577687754E-23
      8.06427167565743E-11   8.07770077948524E-11  -1.28472102908821E-18  -9.34168658371414E-03  -9.34168658403992E-03
      0.00000000000000E+00   0.00000000000000E+00   3.25780956753222E-10   0.00000000000000E+00   3.25780956753222E-10
      4.50697900421850E-18  -3.37850960290258E-01  -3.37722871108513E-01   0.00000000000000E+00  -1.61447711189294E-11
     -1.44341867462818E-22  -3.90413193428989E-10  -4.06557964548062E-10  -3.22225797513029E-18
      7.01808029731313E-09
      0.00000000000000E+00  -4.96145270395060E-13   0.00000000000000E+00   4.98018175596507E-13  -4.70906236026272E-23
      4.95664932261800E-10   4.96162950437350E-10  -1.25810680014899E-18  -2.49575855602031E-02  -2.49575855598377E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.65469383670166E-10   0.00000000000000E+00  -3.65469383670166E-10
      4.48870553503499E-18  -3.52716470103617E-01  -3.52675301648949E-01   0.00000000000000E+00   4.23623621893538E-12
     -1.43998246863161E-22  -1.34929802985945E-10  -1.30693566767154E-10  -3.23059873488600E-18
      7.06808029731313E-09
      0.00000000000000E+00  -1.03665154886135E-12   0.00000000000000E+00   6.84233350164292E-13  -4.61573124365605E-23
      1.03593245051906E-09   1.03661668386917E-09  -1.20600969771546E-18  -5.45625682473203E-02  -5.45625682461036E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.21674389320948E-09   0.00000000000000E+00  -1.21674389320948E-09
      4.42786834037452E-18  -3.68240957589923E-01  -3.68297726584948E-01   0.00000000000000E+00   2.75629530018572E-11
     -1.41548649853683E-22   1.52564256338546E-10   1.80127209340262E-10  -3.22185864265905E-18
      7.11808029731313E-09
      0.00000000000000E+00  -1.36371065805736E-12   0.00000000000000E+00   4.71254908083787E-13  -4.50966008982856E-23
      1.36324185460660E-09   1.36371310951464E-09  -1.14243871027839E-18  -8.91146424557357E-02  -8.91146424541250E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.61067584167764E-09   0.00000000000000E+00  -1.61067584167764E-09
      4.34733454829064E-18  -3.82774482844626E-01  -3.82852314517915E-01   0.00000000000000E+00   3.54284224313946E-11
     -1.38228402195884E-22   2.11534309731752E-10   2.46962732163008E-10  -3.20489583801224E-18
      7.14308029731313E-09
      0.00000000000000E+00  -1.56981024835105E-12   0.00000000000000E+00   5.43170570159707E-13  -4.43996404992705E-23
      1.56924564682946E-09   1.56978881739957E-09  -1.10822026150641E-18  -1.07062437852221E-01  -1.07062437850442E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.77855425242988E-09   0.00000000000000E+00  -1.77855425242988E-09
      4.30287069197989E-18  -3.89565737838933E-01  -3.89631539732147E-01   0.00000000000000E+00   3.69099476137365E-11
     -1.36414977269078E-22   1.71855487416684E-10   2.08765435030284E-10  -3.19465043047348E-18
      7.17683029731313E-09
      0.00000000000000E+00  -1.89778780491913E-12   0.00000000000000E+00   6.03706432879872E-13  -4.26302121290998E-23
      1.89717382515277E-09   1.89777753158561E-09  -1.06038941491204E-18  -1.31409166972334E-01  -1.31409166970436E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.89772397585371E-09   0.00000000000000E+00  -1.89772397585371E-09
      4.23882250779483E-18  -3.97430105607360E-01  -3.97430128074540E-01   0.00000000000000E+00   3.80221124212877E-11
     -1.33767357532044E-22  -3.80756681529915E-11  -5.35557318375310E-14  -3.17843309288278E-18
      7.22239279731313E-09
      0.00000000000000E+00  -2.84287015078458E-12   0.00000000000000E+00   1.13085428774534E-12  -3.50207734047538E-23
      2.84169731600377E-09   2.84282817029148E-09  -9.92923632680974E-19  -1.64362269957019E-01  -1.64362269954890E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.12921798399534E-09   0.00000000000000E+00  -2.12921798399534E-09
      4.14181001339904E-18  -4.03530258669934E-01  -4.03305499226825E-01   0.00000000000000E+00   4.18941115407293E-11
     -1.29529597497981E-22  -7.55504297836783E-10  -7.13610186296184E-10  -3.14888638071806E-18
      7.27239279731313E-09
      0.00000000000000E+00  -5.03382635687013E-12   0.00000000000000E+00   2.24463450145300E-12  -8.71484474641316E-24
      5.03158598449998E-09   5.03383061900143E-09  -9.20406947807549E-19  -1.98135187439247E-01  -1.98135187436814E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.43332585248234E-09   0.00000000000000E+00  -2.43332585248234E-09
      4.02014372077492E-18  -3.98312541972029E-01  -3.97493358574482E-01   0.00000000000000E+00   4.84319147386531E-11
     -1.23576635479941E-22  -2.64893668125760E-09  -2.60050476651907E-09  -3.09973677296737E-18
      7.32239279731313E-09
      0.00000000000000E+00  -8.27080227501220E-12   0.00000000000000E+00   3.24773742025075E-12   3.80675994728004E-23
      8.26757650193624E-09   8.27082423935653E-09  -8.60659128005399E-19  -2.24997395746318E-01  -2.24997395743660E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.65735985921489E-09   0.00000000000000E+00  -2.65735985921489E-09
      3.88727572781418E-18  -3.73444944214683E-01  -3.71676554613604E-01   0.00000000000000E+00   5.37022609713588E-11
     -1.16246356703284E-22  -5.66716664111288E-09  -5.61346438014164E-09  -3.02661659980878E-18
      7.37239279731313E-09
      0.00000000000000E+00  -1.11845765629210E-11   0.00000000000000E+00   2.90786452792687E-12   8.19372053225774E-23
      1.11816236908123E-08   1.11845315553403E-08  -8.19187324314578E-19  -2.43615209904961E-01  -2.43615209902144E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.81684137128712E-09   0.00000000000000E+00  -2.81684137128712E-09
      3.74643365924982E-18  -3.27446163750496E-01  -3.24810028795322E-01   0.00000000000000E+00   5.37968798624378E-11
     -1.08401248817567E-22  -8.42148706391559E-09  -8.36769018405326E-09  -2.92724633493524E-18
      7.42239279731313E-09
      0.00000000000000E+00  -1.27334462111887E-11   0.00000000000000E+00   1.54755546130215E-12   1.06800259557418E-22
      1.27319397076305E-08   1.27334872630919E-08  -7.92801760270110E-19  -2.56002314833969E-01  -2.56002314831057E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.91208122864256E-09   0.00000000000000E+00  -2.91208122864256E-09
      3.60082959781769E-18  -2.68248271160837E-01  -2.65154078096480E-01   0.00000000000000E+00   4.57941728811481E-11
     -1.00573242674596E-22  -9.86720020733036E-09  -9.82140603444932E-09  -2.80802783754758E-18
      7.47239279731313E-09
      0.00000000000000E+00  -1.33033428055614E-11   0.00000000000000E+00   5.76910426008902E-13   1.15160281144831E-22
      1.33027580401458E-08   1.33033349505719E-08  -7.74215966413753E-19  -2.65337999945246E-01  -2.65337999942321E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.92518891039842E-09   0.00000000000000E+00  -2.92518891039842E-09
      3.45457015229777E-18  -2.07293499414042E-01  -2.04023840521611E-01   0.00000000000000E+00   3.36026893505671E-11
     -9.28277817123901E-23  -1.04117487295240E-08  -1.03781460401735E-08  -2.68035418588402E-18
      7.52239279731313E-09
      0.00000000000000E+00  -1.33242834056447E-11   0.00000000000000E+00   2.96585908766792E-14   1.13946107443569E-22
      1.33242282221045E-08   1.33242578806955E-08  -7.59774255309084E-19  -2.73141441791066E-01  -2.73141441788164E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.90166726220674E-09   0.00000000000000E+00  -2.90166726220674E-09
      3.30948678918743E-18  -1.48509351156174E-01  -1.45225640758683E-01   0.00000000000000E+00   2.43451490396010E-11
     -8.68524001867086E-23  -1.04469357675282E-08  -1.04225906184887E-08  -2.54971253387835E-18
      7.54739279731313E-09
      0.00000000000000E+00  -1.31430737391343E-11   0.00000000000000E+00  -3.49889585797308E-13   1.10967133912344E-22
      1.31434239803413E-08   1.31430740907556E-08  -7.53678306877251E-19  -2.76632884215983E-01  -2.76632884213088E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.89484777360598E-09   0.00000000000000E+00  -2.89484777360598E-09
      3.23711559484729E-18  -1.20014172979503E-01  -1.16785377946302E-01   0.00000000000000E+00   1.95498087085527E-11
     -8.39551590020559E-23  -1.02677761258580E-08  -1.02482263171496E-08  -2.48343728797003E-18
      7.58114279731313E-09
      0.00000000000000E+00  -1.28940826565647E-11   0.00000000000000E+00  -3.52864977903645E-13   1.07315032260933E-22
      1.28944699646763E-08   1.28941170996985E-08  -7.45310407118180E-19  -2.81443112090587E-01  -2.81443112087738E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.84861577816068E-09   0.00000000000000E+00  -2.84861577816068E-09
      3.14097481233436E-18  -8.48132342266113E-02  -8.16482904768771E-02   0.00000000000000E+00   1.57244910693583E-11
     -7.68623980722837E-23  -1.00612258126071E-08  -1.00455013215378E-08  -2.39566440521618E-18
      7.62670529731313E-09
      0.00000000000000E+00  -1.21927562432480E-11   0.00000000000000E+00  -7.33680632604570E-13   1.06425218531245E-22
      1.21935121434017E-08   1.21927784627692E-08  -7.30420774751924E-19  -2.89295304357041E-01  -2.89295304354305E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.73604606279534E-09   0.00000000000000E+00  -2.73604606279534E-09
      3.01631371359825E-18  -4.77781145389933E-02  -4.47986534531282E-02   0.00000000000000E+00   1.11344196050908E-11
     -3.78407123234491E-23  -9.46786681957890E-09  -9.45673239997385E-09  -2.28589293884633E-18
      7.67670529731313E-09
      0.00000000000000E+00  -1.08795601906548E-11   0.00000000000000E+00  -1.27461427291717E-12   1.18854188219469E-22
      1.08808689591445E-08   1.08795943448717E-08  -7.03882463783983E-19  -3.01579972614882E-01  -3.01579972612361E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.52166597419916E-09   0.00000000000000E+00  -2.52166597419916E-09
      2.89023041488829E-18  -2.56424025201000E-02  -2.30091186082637E-02   0.00000000000000E+00   6.89722628115741E-12
      5.18726583255651E-23  -8.36482559695375E-09  -8.35792837067255E-09  -2.18634795110431E-18
      7.72670529731313E-09
      0.00000000000000E+00  -9.80754841796854E-12   0.00000000000000E+00  -1.03855981353325E-12   1.39140044303461E-22
      9.80863142224923E-09   9.80759286243584E-09  -6.71227690466044E-19  -3.15956769455969E-01  -3.15956769453639E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.32985316844131E-09   0.00000000000000E+00  -2.32985316844131E-09
      2.77373775646623E-18  -1.60214578225403E-02  -1.36654823596822E-02   0.00000000000000E+00   4.18656974300505E-12
      1.34294338607618E-22  -7.48192626373767E-09  -7.47773969399454E-09  -2.10251006600018E-18
      7.77670529731313E-09
      0.00000000000000E+00  -9.17143176806921E-12   0.00000000000000E+00  -6.09944054785194E-13   1.55738762320253E-22
      9.17201199716081E-09   9.17140205310618E-09  -6.38299896844502E-19  -3.30337391875961E-01  -3.30337391873750E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.21078519387327E-09   0.00000000000000E+00  -2.21078519387327E-09
      2.66319849677256E-18  -1.15648653150323E-02  -9.37181346909766E-03   0.00000000000000E+00   2.77472685723621E-12
      1.92621153083687E-22  -6.96339158609031E-09  -6.96061685923289E-09  -2.02489859992806E-18
      7.82670529731313E-09
      0.00000000000000E+00  -8.84023964569887E-12   0.00000000000000E+00  -3.10435043738127E-13   1.63976856317373E-22
      8.84057311465418E-09   8.84026267961060E-09  -6.06149015212407E-19  -3.44445367003073E-01  -3.44445367000887E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.18572233201074E-09   0.00000000000000E+00  -2.18572233201074E-09
      2.55391238017203E-18  -9.12579593075401E-03  -7.02917571444757E-03   0.00000000000000E+00   2.11715977086888E-12
      2.27101900596989E-22  -6.65665750737099E-09  -6.65454034759989E-09  -1.94776336495962E-18
      7.87670529731313E-09
      0.00000000000000E+00  -8.85034256679169E-12   0.00000000000000E+00   3.12514329799456E-14   1.65131780809855E-22
      8.85028847700105E-09   8.85031972843420E-09  -5.71925170249490E-19  -3.59473866128369E-01  -3.59473866126015E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.35484595996243E-09   0.00000000000000E+00  -2.35484595996243E-09
      2.43617008217390E-18  -7.59615994400952E-03  -5.54965576755597E-03   0.00000000000000E+00   1.86131695471112E-12
      2.43603563554531E-22  -6.49733508542675E-09  -6.49547376847180E-09  -1.86424491192441E-18
      7.92670529731313E-09
      0.00000000000000E+00  -8.89112163011184E-12   0.00000000000000E+00   5.58748403481912E-14   1.55639877132215E-22
      8.89106972251590E-09   8.89112559735640E-09  -5.36893999586708E-19  -3.74839911471981E-01  -3.74839911469511E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.46975464506496E-09   0.00000000000000E+00  -2.46975464506496E-09
      2.31268234992066E-18  -6.54048408193129E-03  -4.51732358809767E-03   0.00000000000000E+00   1.66682528582031E-12
      2.38374278231316E-22  -6.42303777757746E-09  -6.42137095229140E-09  -1.77578835033395E-18
      7.97670529731313E-09
      0.00000000000000E+00  -8.73498557685904E-12   0.00000000000000E+00  -1.40297224725187E-13   1.34075732947648E-22
      8.73512971680303E-09   8.73498941957844E-09  -5.04587698810704E-19  -3.89010214828124E-01  -3.89010214825770E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.35432975454899E-09   0.00000000000000E+00  -2.35432975454899E-09
      2.19496586219320E-18  -5.78405705574546E-03  -3.77372150901618E-03   0.00000000000000E+00   1.39720847489704E-12
      2.09653974700527E-22  -6.38205687350454E-09  -6.38065966502943E-09  -1.69037816338250E-18
      8.02670529731313E-09
      0.00000000000000E+00  -8.37486236226833E-12   0.00000000000000E+00  -3.44461367532236E-13   1.05254201879323E-22
      8.37518991750829E-09   8.37484545614086E-09  -4.77947849523335E-19  -4.00705561754967E-01  -4.00705561752962E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.00483364958531E-09   0.00000000000000E+00  -2.00483364958531E-09
      2.09472417971394E-18  -5.25598314801316E-03  -3.24900082835658E-03   0.00000000000000E+00   1.05842727621498E-12
      1.65886681016985E-22  -6.37107023383196E-09  -6.37001180655558E-09  -1.61677633019061E-18
      8.07670529731313E-09
      0.00000000000000E+00  -7.60171336445537E-12   0.00000000000000E+00  -7.56338931726826E-13   7.47312923687108E-23
      7.60247782636920E-09   7.60172148743755E-09  -4.63959137464956E-19  -4.07050329336206E-01  -4.07050329335033E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17357871573739E-09   0.00000000000000E+00  -1.17357871573739E-09
      2.03604524392707E-18  -4.92903859905104E-03  -2.90373995018472E-03   0.00000000000000E+00   4.75718796261911E-13
      1.17112371525042E-22  -6.42861849049649E-09  -6.42814277170012E-09  -1.57208610646212E-18
      8.12670529731313E-09
      0.00000000000000E+00  -5.81248603891554E-12   0.00000000000000E+00  -1.76876840045004E-12   4.50621944503847E-23
      5.81427307887983E-09   5.81250431047943E-09  -4.79412708490077E-19  -4.01293448864016E-01  -4.01293448864710E-01
      0.00000000000000E+00   0.00000000000000E+00   6.93845338204896E-10   0.00000000000000E+00   6.93845338204896E-10
      2.07073751083732E-18  -4.77179388518784E-03  -2.72185404442986E-03   0.00000000000000E+00  -6.26442413047859E-13
      6.82250072937851E-23  -6.50572320627134E-09  -6.50634964868432E-09  -1.59132480234724E-18
      8.17670529731313E-09
      0.00000000000000E+00  -3.03537671997155E-12   0.00000000000000E+00  -2.76168904774538E-12   1.37084888881721E-23
      3.03811719979120E-09   3.03535551074347E-09  -5.43637598172418E-19  -3.75835920122412E-01  -3.75835920125881E-01
      0.00000000000000E+00   0.00000000000000E+00   3.46886325396888E-09   0.00000000000000E+00   3.46886325396888E-09
      2.24418067353576E-18  -4.98644155663429E-03  -2.93717394233849E-03   0.00000000000000E+00  -2.58302100339906E-12
      1.37305723220339E-23  -6.50163574370899E-09  -6.50421876471238E-09  -1.70054307536334E-18
      8.22670529731313E-09
      0.00000000000000E+00  -6.39055681489971E-13   0.00000000000000E+00  -2.42057784504722E-12  -1.99767425381043E-23
      6.41526740675025E-10   6.39106162829958E-10  -6.58371427114623E-19  -3.29396849383832E-01  -3.29396849389564E-01
      0.00000000000000E+00   0.00000000000000E+00   5.73176965983736E-09   0.00000000000000E+00   5.73176965983736E-09
      2.53076915652763E-18  -6.92898091406928E-03  -4.92172723726014E-03   0.00000000000000E+00  -5.87451248894080E-12
     -4.72388081350355E-23  -6.36500131017832E-09  -6.37087582266731E-09  -1.87239772941300E-18
      8.27670529731313E-09
      0.00000000000000E+00   7.33012847653271E-13   0.00000000000000E+00  -1.42907952331591E-12  -3.79917584107785E-23
     -7.31591505685400E-10  -7.33020585208754E-10  -7.96347428647232E-19  -2.69916534493849E-01  -2.69916534500396E-01
      0.00000000000000E+00   0.00000000000000E+00   6.54763729586556E-09   0.00000000000000E+00   6.54763729586556E-09
      2.85815102132091E-18  -1.66627825492930E-02  -1.48307984480845E-02   0.00000000000000E+00  -1.13309356230882E-11
     -7.65045736218841E-23  -5.80328577503365E-09  -5.81461671065681E-09  -2.06180359267367E-18
      8.32670529731313E-09
      0.00000000000000E+00   1.83818057047144E-12   0.00000000000000E+00  -1.22385045721170E-12  -4.24676451548634E-23
     -1.83695517516956E-09  -1.83817902562682E-09  -9.25507821962366E-19  -2.08858174134430E-01  -2.08858174140899E-01
      0.00000000000000E+00   0.00000000000000E+00   6.46886377081570E-09   0.00000000000000E+00   6.46886377081570E-09
      3.18159420986169E-18  -4.22061975349743E-02  -4.07472233739482E-02   0.00000000000000E+00  -2.06909429717739E-11
     -8.48501692600753E-23  -4.60999380221701E-09  -4.63068474518887E-09  -2.25608638789933E-18
      8.37670529731313E-09
      0.00000000000000E+00   2.17561813497189E-12   0.00000000000000E+00  -5.01755483628831E-13  -4.41879369405256E-23
     -2.17508541247186E-09  -2.17558716795554E-09  -1.04048796936272E-18  -1.50082145468102E-01  -1.50082145474022E-01
      0.00000000000000E+00   0.00000000000000E+00   5.92052630494591E-09   0.00000000000000E+00   5.92052630494591E-09
      3.47762052510898E-18  -7.57808579477500E-02  -7.46009502461600E-02   0.00000000000000E+00  -3.42322485719823E-11
     -9.43243577595639E-23  -3.71070688841830E-09  -3.74493913699037E-09  -2.43713255574627E-18
      8.40170529731313E-09
      0.00000000000000E+00   2.09810117676874E-12   0.00000000000000E+00  -4.51501018794909E-14  -4.50016849871875E-23
     -2.09807173868960E-09  -2.09811688879152E-09  -1.09344230396230E-18  -1.21580548907634E-01  -1.21580548913096E-01
      0.00000000000000E+00   0.00000000000000E+00   5.46189988624117E-09   0.00000000000000E+00   5.46189988624117E-09
      3.61416802226502E-18  -9.36221173716748E-02  -9.25622942115305E-02   0.00000000000000E+00  -4.63213537634538E-11
     -9.92575468788231E-23  -3.31746164368608E-09  -3.36378299744963E-09  -2.52072571830271E-18
      8.41858029731313E-09
      0.00000000000000E+00   1.99679643162884E-12   0.00000000000000E+00   8.67207310937599E-14  -4.55428191414128E-23
     -1.99691401863466E-09  -1.99682729790361E-09  -1.12684882578209E-18  -1.03100705326892E-01  -1.03100705332037E-01
      0.00000000000000E+00   0.00000000000000E+00   5.14509955181456E-09   0.00000000000000E+00   5.14509955181456E-09
      3.70099157720189E-18  -1.05881264604339E-01  -1.04889339632968E-01   0.00000000000000E+00  -5.31647173605235E-11
     -1.02603335237576E-22  -3.09510753655031E-09  -3.14827225391094E-09  -2.57414275141979E-18
      8.44136154731313E-09
      0.00000000000000E+00   1.83377202308548E-12   0.00000000000000E+00   1.42849547925573E-13  -4.62212533264392E-23
     -1.83389354286806E-09  -1.83375069332018E-09  -1.16761774136691E-18  -8.00041135764854E-02  -8.00041135812245E-02
      0.00000000000000E+00   0.00000000000000E+00   4.73907870715645E-09   0.00000000000000E+00   4.73907870715645E-09
      3.80895371399930E-18  -1.22496383230093E-01  -1.21581002325862E-01   0.00000000000000E+00  -5.82452319836021E-11
     -1.07074145605666E-22  -2.84708278185253E-09  -2.90532801383624E-09  -2.64133597263238E-18
      8.47211623481313E-09
      0.00000000000000E+00   1.51902010867528E-12   0.00000000000000E+00   3.11729179349417E-13  -4.69689088123422E-23
     -1.51933827649598E-09  -1.51902654731668E-09  -1.21252833909098E-18  -5.38467583977306E-02  -5.38467584018048E-02
      0.00000000000000E+00   0.00000000000000E+00   4.07423086597288E-09   0.00000000000000E+00   4.07423086597288E-09
      3.93425541108514E-18  -1.45010401152725E-01  -1.44205333677451E-01   0.00000000000000E+00  -6.21699842438747E-11
     -1.12878552489770E-22  -2.49303433441222E-09  -2.55520431865621E-09  -2.72172707199416E-18
      8.51363506293813E-09
      0.00000000000000E+00   9.72268388078878E-13   0.00000000000000E+00   5.17438637773064E-13  -4.75682238090426E-23
     -9.72819693688201E-10  -9.72302255050475E-10  -1.25028395415491E-18  -3.12279951014801E-02  -3.12279951044689E-02
      0.00000000000000E+00   0.00000000000000E+00   2.98882127607150E-09   0.00000000000000E+00   2.98882127607150E-09
      4.05834776794270E-18  -1.75268629418643E-01  -1.74633285385771E-01   0.00000000000000E+00  -5.99236984790537E-11
     -1.19668996250073E-22  -1.95659532254190E-09  -2.01651902102107E-09  -2.80806381378779E-18
      8.56363506293813E-09
      0.00000000000000E+00   4.79521372960497E-13   0.00000000000000E+00   4.27091971341099E-13  -4.78593657266298E-23
     -4.79946141493034E-10  -4.79519049521741E-10  -1.27113743575089E-18  -1.84789144434951E-02  -1.84789144454095E-02
      0.00000000000000E+00   0.00000000000000E+00   1.91440114470507E-09   0.00000000000000E+00   1.91440114470507E-09
      4.15406782517795E-18  -2.07844357745821E-01  -2.07392270296046E-01   0.00000000000000E+00  -5.03333648061530E-11
     -1.25877074486963E-22  -1.38454873037705E-09  -1.43488209518333E-09  -2.88293038942706E-18
      8.61363506293813E-09
      0.00000000000000E+00   2.50552443102133E-13   0.00000000000000E+00   2.04257552501951E-13  -4.79631871809682E-23
     -2.50729269919944E-10  -2.50525012367490E-10  -1.28060444980212E-18  -1.27321495544948E-02  -1.27321495557398E-02
      0.00000000000000E+00   0.00000000000000E+00   1.24505137191019E-09   0.00000000000000E+00   1.24505137191019E-09
      4.21632039377346E-18  -2.32777858357813E-01  -2.32464514431558E-01   0.00000000000000E+00  -3.80387341482320E-11
     -1.30213944336552E-22  -9.56487625394373E-10  -9.94526359542735E-10  -2.93571594397135E-18
      8.66363506293813E-09
      0.00000000000000E+00   1.64034700652643E-13   0.00000000000000E+00   7.77624405291388E-14  -4.80011089634650E-23
     -1.64085031507971E-10  -1.64007269067490E-10  -1.28580387057353E-18  -9.75019134406278E-03  -9.75019134490972E-03
      0.00000000000000E+00   0.00000000000000E+00   8.46940914908083E-10   0.00000000000000E+00   8.46940914908083E-10
      4.25866743951887E-18  -2.49682743459048E-01  -2.49467574461980E-01   0.00000000000000E+00  -2.57273354025104E-11
     -1.33005130287864E-22  -6.57206310437903E-10  -6.82933645840547E-10  -2.97286356894534E-18
      8.71363506293814E-09
      0.00000000000000E+00   1.27388650506840E-13   0.00000000000000E+00   3.41532119060867E-14  -4.80121547811880E-23
     -1.27382195668036E-10  -1.27348042456178E-10  -1.28922111811772E-18  -7.96492615826437E-03  -7.96492615888306E-03
      0.00000000000000E+00   0.00000000000000E+00   6.18689221410954E-10   0.00000000000000E+00   6.18689221410954E-10
      4.28960190058942E-18  -2.61008907921691E-01  -2.60854105275962E-01   0.00000000000000E+00  -1.67818312077443E-11
     -1.34772022468778E-22  -4.74559347746908E-10  -4.91341178954787E-10  -3.00038078247169E-18
      8.76363506293814E-09
      0.00000000000000E+00   1.07733876744429E-13   0.00000000000000E+00   2.00580800871182E-14  -4.80094219938263E-23
     -1.07732069057869E-10  -1.07712010977830E-10  -1.29170427388710E-18  -6.78039588007182E-03  -6.78039588058223E-03
      0.00000000000000E+00   0.00000000000000E+00   5.10411861792289E-10   0.00000000000000E+00   5.10411861792289E-10
      4.31512249367903E-18  -2.69804465769167E-01  -2.69677592051447E-01   0.00000000000000E+00  -1.25004182956605E-11
     -1.36056862395374E-22  -3.90199432518697E-10  -4.02699850814493E-10  -3.02341821979193E-18
      8.81363506293814E-09
      0.00000000000000E+00   9.57022161702429E-14   0.00000000000000E+00   1.39629579212045E-14  -4.79990312809450E-23
     -9.57291585069271E-11  -9.57151955490539E-11  -1.29363390450712E-18  -5.93504998727423E-03  -5.93504998772643E-03
      0.00000000000000E+00   0.00000000000000E+00   4.52204181181560E-10   0.00000000000000E+00   4.52204181181560E-10
      4.33773270273811E-18  -2.77312625054819E-01  -2.77200311399429E-01   0.00000000000000E+00  -1.02589561163489E-11
     -1.37090029953687E-22  -3.46230029515996E-10  -3.56488985632482E-10  -3.04409879823099E-18
      8.83863506293814E-09
      0.00000000000000E+00   8.99159977261687E-14   0.00000000000000E+00   1.42061188199806E-14  -4.79919101478370E-23
     -8.99579621531110E-11  -8.99437560343390E-11  -1.29446582314859E-18  -5.59516184491619E-03  -5.59516184533828E-03
      0.00000000000000E+00   0.00000000000000E+00   4.22091497017142E-10   0.00000000000000E+00   4.22091497017142E-10
      4.34828499016354E-18  -2.80714584732474E-01  -2.80609940477097E-01   0.00000000000000E+00  -9.01457050698940E-12
     -1.37538959850815E-22  -3.23133170475641E-10  -3.32147740982768E-10  -3.05381916701495E-18
      8.87238506293814E-09
      0.00000000000000E+00   8.35787108588493E-14   0.00000000000000E+00   1.28378666335807E-14  -4.79796692552837E-23
     -8.35905535350227E-11  -8.35777156684371E-11  -1.29539543074736E-18  -5.23585820261100E-03  -5.23585820302896E-03
      0.00000000000000E+00   0.00000000000000E+00   4.17957742991636E-10   0.00000000000000E+00   4.17957742991636E-10
      4.36239106398950E-18  -2.85495616285488E-01  -2.85390268666969E-01   0.00000000000000E+00  -9.41132775266804E-12
     -1.38162303758402E-22  -3.24968699570381E-10  -3.34380027323187E-10  -3.06699563324214E-18
      8.91794756293814E-09
      0.00000000000000E+00   7.49453055613418E-14   0.00000000000000E+00   1.39022263162952E-14  -4.79580729233108E-23
     -7.49286608616060E-11  -7.49147586353376E-11  -1.29629872859606E-18  -4.89688367976553E-03  -4.89688368021862E-03
      0.00000000000000E+00   0.00000000000000E+00   4.53092953207218E-10   0.00000000000000E+00   4.53092953207218E-10
      4.38303511167001E-18  -2.93631446439517E-01  -2.93512298909378E-01   0.00000000000000E+00  -1.25223639780500E-11
     -1.39259720581820E-22  -3.65655830593682E-10  -3.78178194571871E-10  -3.08673638307395E-18
      8.96794756293814E-09
      0.00000000000000E+00   6.42913160452687E-14   0.00000000000000E+00   1.62524664388650E-14  -4.79272554562578E-23
     -6.43258919345280E-11  -6.43096394681371E-11  -1.29682070034442E-18  -4.68456463780165E-03  -4.68456463833730E-03
      0.00000000000000E+00   0.00000000000000E+00   5.35646583185102E-10   0.00000000000000E+00   5.35646583185102E-10
      4.40981744082926E-18  -3.06272161604834E-01  -3.06123661658642E-01   0.00000000000000E+00  -1.91684302249205E-11
     -1.41058970555387E-22  -4.52168513491875E-10  -4.71336943716937E-10  -3.11299674048484E-18
      9.01794756293814E-09
      0.00000000000000E+00   5.37291712664031E-14   0.00000000000000E+00   1.74953290488967E-14  -4.78894508406825E-23
     -5.37424380074800E-11  -5.37249426784790E-11  -1.29688017584773E-18  -4.68139656437424E-03  -4.68139656494056E-03
      0.00000000000000E+00   0.00000000000000E+00   5.66320666460614E-10   0.00000000000000E+00   5.66320666460614E-10
      4.43813347415229E-18  -3.20733837201844E-01  -3.20572337536385E-01   0.00000000000000E+00  -2.28076663690131E-11
     -1.43146044915725E-22  -4.89788057412950E-10  -5.12595723782106E-10  -3.14125329830456E-18
      9.06794756293814E-09
      0.00000000000000E+00   2.10324448205236E-14   0.00000000000000E+00   4.42088772043306E-14  -4.78241870543044E-23
     -2.10990016239186E-11  -2.10547927467621E-11  -1.29538242061342E-18  -5.59640424405983E-03  -5.59640424456584E-03
      0.00000000000000E+00   0.00000000000000E+00   5.06004863366236E-10   0.00000000000000E+00   5.06004863366236E-10
      4.46343371732061E-18  -3.35087736640048E-01  -3.34934947767131E-01   0.00000000000000E+00  -2.17335123507894E-11
     -1.45086531451924E-22  -4.63216558268574E-10  -4.84950070619509E-10  -3.16805129670718E-18
      9.11794756293814E-09
      0.00000000000000E+00  -1.30603216309103E-13   0.00000000000000E+00   1.85607705398266E-13  -4.76233218855940E-23
      1.30467528763006E-10   1.30653136468356E-10  -1.28643447842228E-18  -1.09310490963494E-02  -1.09310490965856E-02
      0.00000000000000E+00   0.00000000000000E+00   2.36174286937620E-10   0.00000000000000E+00   2.36174286937620E-10
      4.47524243166749E-18  -3.49168762706941E-01  -3.49053192483822E-01   0.00000000000000E+00  -1.34336318363590E-11
     -1.46271169311731E-22  -3.53393791569418E-10  -3.66827423405924E-10  -3.18880795324520E-18
      9.16794756293814E-09
      0.00000000000000E+00  -6.30697810404086E-13   0.00000000000000E+00   6.01522997539948E-13  -4.69813805142756E-23
      6.30134491047018E-10   6.30736014044511E-10  -1.25298488647562E-18  -3.04742852892366E-02  -3.04742852886492E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.87359163565624E-10   0.00000000000000E+00  -5.87359163565624E-10
      4.44587447348921E-18  -3.64197400925855E-01  -3.64183745446994E-01   0.00000000000000E+00   1.15461541238910E-11
     -1.45303301478538E-22  -5.49230046026512E-11  -4.33768504789055E-11  -3.19288958701359E-18
      9.21794756293814E-09
      0.00000000000000E+00  -1.11674015970632E-12   0.00000000000000E+00   6.32923096631710E-13  -4.59839939278696E-23
      1.11611337414728E-09   1.11674629724386E-09  -1.19705959711775E-18  -6.20178245302819E-02  -6.20178245289439E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.33798847631330E-09   0.00000000000000E+00  -1.33798847631330E-09
      4.37897504967354E-18  -3.79526121979730E-01  -3.79595845675719E-01   0.00000000000000E+00   3.20095057329807E-11
     -1.42500231619228E-22   1.89232673336551E-10   2.21242179069389E-10  -3.18191545255579E-18
      9.23044756293814E-09
      0.00000000000000E+00  -1.25818105500591E-12   0.00000000000000E+00   7.09438365018530E-13  -4.57180336414691E-23
      1.25745429901081E-09   1.25816373737578E-09  -1.18153422390216E-18  -7.05500764374496E-02  -7.05500764359128E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.53678280813211E-09   0.00000000000000E+00  -1.53678280813211E-09
      4.35976526457189E-18  -3.83308986386117E-01  -3.83396788951692E-01   0.00000000000000E+00   3.56121550255955E-11
     -1.41700758876185E-22   2.43006915731098E-10   2.78619070756551E-10  -3.17823104066973E-18
      9.24732256293814E-09
      0.00000000000000E+00  -1.36049609225509E-12   0.00000000000000E+00   4.50416219081914E-13  -4.53541613419978E-23
      1.36008470731341E-09   1.36053512353245E-09  -1.15942497102612E-18  -8.25201833334135E-02  -8.25201833317595E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.65397113125096E-09   0.00000000000000E+00  -1.65397113125096E-09
      4.33185450173203E-18  -3.88295046977859E-01  -3.88387519869721E-01   0.00000000000000E+00   3.75524009470126E-11
     -1.40540847614317E-22   2.55883606771630E-10   2.93436007718502E-10  -3.17242953070591E-18
      9.27010381293814E-09
      0.00000000000000E+00  -1.48834396644797E-12   0.00000000000000E+00   4.20640883807868E-13  -4.48368617148302E-23
      1.48791138806917E-09   1.48833202895293E-09  -1.12832770162257E-18  -9.90226681788298E-02  -9.90226681770751E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.75469596901933E-09   0.00000000000000E+00  -1.75469596901933E-09
      4.29188033418781E-18  -3.94687505212397E-01  -3.94771452260910E-01   0.00000000000000E+00   3.86824374633822E-11
     -1.38883574269380E-22   2.27681502603112E-10   2.66363940066355E-10  -3.16355263256524E-18
      9.30085850043814E-09
      0.00000000000000E+00  -1.70978162785532E-12   0.00000000000000E+00   4.87190963481468E-13  -4.39220803295109E-23
      1.70933990873264E-09   1.70982709969608E-09  -1.08502311912578E-18  -1.21385984646045E-01  -1.21385984644194E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.85068825678300E-09   0.00000000000000E+00  -1.85068825678300E-09
      4.23496299519053E-18  -4.02430159743223E-01  -4.02474573406517E-01   0.00000000000000E+00   3.92699623294847E-11
     -1.36516526012991E-22   1.01591194757579E-10   1.40861157086927E-10  -3.14993987606475E-18
      9.34237732856314E-09
      0.00000000000000E+00  -2.29621027492538E-12   0.00000000000000E+00   8.12851231458572E-13  -4.09741097361386E-23
      2.29535587173312E-09   2.29616872296454E-09  -1.02426107053435E-18  -1.51610166265188E-01  -1.51610166263173E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.01571204912257E-09   0.00000000000000E+00  -2.01571204912257E-09
      4.15127299307351E-18  -4.10183915030911E-01  -4.10095608967806E-01   0.00000000000000E+00   4.13753480077100E-11
     -1.32929558895255E-22  -3.21832021849581E-10  -2.80456673842004E-10  -3.12701192253917E-18
      9.39237732856314E-09
      0.00000000000000E+00  -3.91221842609181E-12   0.00000000000000E+00   1.68928758458985E-12  -2.82958633782708E-23
      3.91054196668224E-09   3.91223125426680E-09  -9.49402268110330E-19  -1.87097432576466E-01  -1.87097432574159E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.30637067787217E-09   0.00000000000000E+00  -2.30637067787217E-09
      4.03595445917991E-18  -4.11024685844275E-01  -4.10518849366191E-01   0.00000000000000E+00   4.71577721902646E-11
     -1.27519591004553E-22  -1.65301834858471E-09  -1.60586057639457E-09  -3.08655219106958E-18
      9.44237732856314E-09
      0.00000000000000E+00  -6.79660239809419E-12   0.00000000000000E+00   2.91157424429095E-12   3.67693713695256E-24
      6.79365299595154E-09   6.79656457019583E-09  -8.82631677044880E-19  -2.17354251660364E-01  -2.17354251657809E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.55523337106604E-09   0.00000000000000E+00  -2.55523337106604E-09
      3.90819279062661E-18  -3.95376851298367E-01  -3.94040751768121E-01   0.00000000000000E+00   5.32227418737019E-11
     -1.20662538422056E-22  -4.29455394100341E-09  -4.24133119912983E-09  -3.02556111358172E-18
      9.49237732856314E-09
      0.00000000000000E+00  -1.00698569874332E-11   0.00000000000000E+00   3.26995089772501E-12   4.40910009562815E-23
      1.00665461788311E-08   1.00698161297288E-08  -8.32820298434904E-19  -2.39465734469261E-01  -2.39465734466532E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.72905667726280E-09   0.00000000000000E+00  -2.72905667726280E-09
      3.77173995676347E-18  -3.58268776841975E-01  -3.55956202833732E-01   0.00000000000000E+00   5.61781809539347E-11
     -1.12731599261686E-22  -7.39693763341983E-09  -7.34075945246601E-09  -2.93891965832856E-18
      9.54237732856314E-09
      0.00000000000000E+00  -1.22485059987330E-11   0.00000000000000E+00   2.17352909907519E-12   7.26972678235446E-23
      1.22463428300419E-08   1.22485163591410E-08  -8.00550960620930E-19  -2.54114628125873E-01  -2.54114628123019E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.85442029585107E-09   0.00000000000000E+00  -2.85442029585107E-09
      3.62901894197091E-18  -3.03088467753081E-01  -3.00128936781671E-01   0.00000000000000E+00   5.19318996014244E-11
     -1.04829890074348E-22  -9.44602796289130E-09  -9.39409606328998E-09  -2.82846798134998E-18
      9.59237732856314E-09
      0.00000000000000E+00  -1.31411449996529E-11   0.00000000000000E+00   8.95263579148074E-13   8.46710669590606E-23
      1.31402076962803E-08   1.31411029598595E-08  -7.79441739193836E-19  -2.64317457970846E-01  -2.64317457967942E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.90406110143410E-09   0.00000000000000E+00  -2.90406110143410E-09
      3.48381588689921E-18  -2.41206670400380E-01  -2.37981499151476E-01   0.00000000000000E+00   4.03597188960364E-11
     -9.67222510564457E-23  -1.02774015773214E-08  -1.02370418584254E-08  -2.70437414770537E-18
      9.64237732856314E-09
      0.00000000000000E+00  -1.33524797399674E-11   0.00000000000000E+00   2.18652577923800E-13   8.61735443198379E-23
      1.33522801144974E-08   1.33524987670754E-08  -7.63489945843650E-19  -2.72579161983722E-01  -2.72579161980832E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.89021457557664E-09   0.00000000000000E+00  -2.89021457557664E-09
      3.33930515812037E-18  -1.80797265801520E-01  -1.77501073379001E-01   0.00000000000000E+00   2.88243968525634E-11
     -8.96238670012061E-23  -1.04911085883512E-08  -1.04622841914987E-08  -2.57581521227673E-18
      9.65487732856314E-09
      0.00000000000000E+00  -1.32480522737625E-11   0.00000000000000E+00  -4.02526773723438E-13   8.51254559844384E-23
      1.32484764070269E-08   1.32480738802533E-08  -7.60242073045984E-19  -2.74360489864589E-01  -2.74360489861683E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.90675425637295E-09   0.00000000000000E+00  -2.90675425637295E-09
      3.30297072991571E-18  -1.65631536674055E-01  -1.62373441775329E-01   0.00000000000000E+00   2.44818779480473E-11
     -8.82142110255464E-23  -1.03658015018283E-08  -1.03413196238803E-08  -2.54272865686973E-18
      9.67175232856314E-09
      0.00000000000000E+00  -1.31783421182220E-11   0.00000000000000E+00  -1.97486952490674E-13   8.35327663345410E-23
      1.31785045652958E-08   1.31783070783434E-08  -7.55963281424692E-19  -2.76744902617866E-01  -2.76744902614976E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.88984072860035E-09   0.00000000000000E+00  -2.88984072860035E-09
      3.25420466762058E-18  -1.45774393359574E-01  -1.42532936133842E-01   0.00000000000000E+00   2.17675413009899E-11
     -8.64583832384524E-23  -1.03102338910441E-08  -1.02884663497432E-08  -2.49824138619589E-18
      9.68314295356314E-09
      0.00000000000000E+00  -1.31039478810839E-11   0.00000000000000E+00  -3.14846744270202E-13   8.23030520913388E-23
      1.31042479173052E-08   1.31039330705610E-08  -7.53200155134476E-19  -2.78312077403127E-01  -2.78312077400246E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.88109907991593E-09   0.00000000000000E+00  -2.88109907991593E-09
      3.22138714841341E-18  -1.32623924177346E-01  -1.29403136156011E-01   0.00000000000000E+00   1.99870841598442E-11
     -8.52589752519381E-23  -1.02428210748046E-08  -1.02228339906448E-08  -2.46818699327893E-18
      9.69852029731314E-09
      0.00000000000000E+00  -1.30143992623065E-11   0.00000000000000E+00  -2.80592904257450E-13   8.07915071238786E-23
      1.30146411805640E-08   1.30143605876598E-08  -7.49473236155301E-19  -2.80438340737011E-01  -2.80438340734150E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.86149107373671E-09   0.00000000000000E+00  -2.86149107373671E-09
      3.17738501653501E-18  -1.15458696695259E-01  -1.12259941046950E-01   0.00000000000000E+00   1.81813588316731E-11
     -8.34876593823639E-23  -1.01710508727548E-08  -1.01528695139232E-08  -2.42791178037971E-18
      9.71927971137564E-09
      0.00000000000000E+00  -1.28702030248907E-11   0.00000000000000E+00  -3.35377479095061E-13   7.90279316057392E-23
      1.28705156744064E-08   1.28701802969274E-08  -7.44382274397579E-19  -2.83347317880183E-01  -2.83347317877351E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.83252967156599E-09   0.00000000000000E+00  -2.83252967156599E-09
      3.11858336023865E-18  -9.35026445383568E-02  -9.03401771130904E-02   0.00000000000000E+00   1.60054229546071E-11
     -8.02833985341541E-23  -1.00536560483160E-08  -1.00376506253614E-08  -2.37420108584107E-18
      9.74730492036001E-09
      0.00000000000000E+00  -1.25635334473548E-11   0.00000000000000E+00  -5.31216503225071E-13   7.73877490491542E-23
      1.25641288634294E-08   1.25635976469263E-08  -7.36806277524227E-19  -2.87554576743919E-01  -2.87554576741138E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.78046583520993E-09   0.00000000000000E+00  -2.78046583520993E-09
      3.04066022413298E-18  -6.70012371559698E-02  -6.39189444901871E-02   0.00000000000000E+00   1.31952421095400E-11
     -7.01625276525242E-23  -9.79632705382584E-09  -9.78313181171636E-09  -2.30385394660875E-18
      9.78513895248892E-09
      0.00000000000000E+00  -1.17846900758350E-11   0.00000000000000E+00  -1.00291158141420E-12   7.96987885074302E-23
      1.17856816171250E-08   1.17846787055437E-08  -7.22149049868498E-19  -2.94858570826616E-01  -2.94858570823961E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.65466513849352E-09   0.00000000000000E+00  -2.65466513849352E-09
      2.94022353799173E-18  -4.05179511097723E-02  -3.76414178856993E-02   0.00000000000000E+00   9.62654706754709E-12
     -3.28182088805455E-23  -9.13964011411767E-09  -9.13001356705016E-09  -2.21807448812323E-18
      9.83513895248892E-09
      0.00000000000000E+00  -1.05361527182358E-11   0.00000000000000E+00  -1.21369182468667E-12   9.37813819503974E-23
      1.05373811134357E-08   1.05361674216111E-08  -6.93050083514611E-19  -3.07958285714714E-01  -3.07958285712277E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.43698940913065E-09   0.00000000000000E+00  -2.43698940913065E-09
      2.81837406753520E-18  -2.25087182416795E-02  -1.99569537840530E-02   0.00000000000000E+00   5.98541337225990E-12
      4.42735892742558E-23  -8.10516342585275E-09  -8.09917801248045E-09  -2.12532398402059E-18
      9.88513895248892E-09
      0.00000000000000E+00  -9.59906086450745E-12   0.00000000000000E+00  -9.05492480139913E-13   1.12111890735931E-22
      9.59994224338601E-09   9.59903675090599E-09  -6.59582238549491E-19  -3.22479960002371E-01  -3.22479960000109E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.26168637537076E-09   0.00000000000000E+00  -2.26168637537076E-09
      2.70528974876666E-18  -1.45967944377477E-02  -1.22850494086066E-02   0.00000000000000E+00   3.73472564854733E-12
      1.11248752629259E-22  -7.34108510118388E-09  -7.33735037553523E-09  -2.04570751021717E-18
      9.93513895248892E-09
      0.00000000000000E+00  -9.03651184911135E-12   0.00000000000000E+00  -5.37533791650655E-13   1.26283692288622E-22
      9.03701592854484E-09   9.03647839475332E-09  -6.26454790918070E-19  -3.36771270603102E-01  -3.36771270600949E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.15293162471541E-09   0.00000000000000E+00  -2.15293162471541E-09
      2.59764316753089E-18  -1.07622169243188E-02  -8.59344627701820E-03   0.00000000000000E+00   2.57872989065499E-12
      1.58258575584739E-22  -6.88612549992876E-09  -6.88354677003795E-09  -1.97118837661282E-18
      9.98513895248892E-09
      0.00000000000000E+00  -8.75482404009586E-12   0.00000000000000E+00  -2.61830940106470E-13   1.33415594635533E-22
      8.75506981835052E-09   8.75480798741055E-09  -5.93910295875916E-19  -3.50856825010840E-01  -3.50856825008696E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.14380177580431E-09   0.00000000000000E+00  -2.14380177580431E-09
      2.49045307874067E-18  -8.59007239582829E-03  -6.50716752210859E-03   0.00000000000000E+00   2.03232900914715E-12
      1.86167226800276E-22  -6.61303854061553E-09  -6.61100621160620E-09  -1.89654278286475E-18
      1.00351389524889E-08
      0.00000000000000E+00  -8.80432835345072E-12   0.00000000000000E+00   6.47914392139999E-14   1.34493106714664E-22
      8.80423481004040E-09   8.80429960147975E-09  -5.58953331168960E-19  -3.65972095877053E-01  -3.65972095874722E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.33000290743394E-09   0.00000000000000E+00  -2.33000290743394E-09
      2.37395293336898E-18  -7.20452187008413E-03  -5.16468750231179E-03   0.00000000000000E+00   1.82492608935562E-12
      1.99255856008350E-22  -6.47612162013537E-09  -6.47429669404582E-09  -1.81499960220001E-18
      1.00601389524889E-08
      0.00000000000000E+00  -8.85401635627999E-12   0.00000000000000E+00   1.13809701159548E-13   1.31669311949583E-22
      8.85388862973656E-09   8.85400243943785E-09  -5.40968574498135E-19  -3.73725192149394E-01  -3.73725192146959E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.43489555074524E-09   0.00000000000000E+00  -2.43489555074524E-09
      2.31308054460034E-18  -6.67007537745387E-03  -4.64762847437643E-03   0.00000000000000E+00   1.72439831331830E-12
      1.98957000060440E-22  -6.42083128700614E-09  -6.41910688869262E-09  -1.77211197010221E-18
      1.00938889524889E-08
      0.00000000000000E+00  -8.82738138248981E-12   0.00000000000000E+00  -2.38606749108622E-14   1.23236259861587E-22
      8.82736697546181E-09   8.82734311478703E-09  -5.17226601119104E-19  -3.83965409793908E-01  -3.83965409791476E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.43273999969710E-09   0.00000000000000E+00  -2.43273999969710E-09
      2.23097556961057E-18  -6.08797973660721E-03  -4.07325183803074E-03   0.00000000000000E+00   1.54215396143491E-12
      1.89787619267403E-22  -6.39614526905155E-09  -6.39460311508992E-09  -1.71374896849146E-18
      1.01052795774889E-08
      0.00000000000000E+00  -8.80148116659729E-12   0.00000000000000E+00  -9.74581303210788E-14   1.19147901048806E-22
      8.80158277975571E-09   8.80148532162551E-09  -5.09351283561442E-19  -3.87359765594204E-01  -3.87359765591777E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.42685435873562E-09   0.00000000000000E+00  -2.42685435873562E-09
      2.20333218168059E-18  -5.90859424586854E-03  -3.90015847939280E-03   0.00000000000000E+00   1.51167248560288E-12
      1.84324826126986E-22  -6.37614263537581E-09  -6.37463096289002E-09  -1.69398089811916E-18
      1.01206569212389E-08
      0.00000000000000E+00  -8.74811937427972E-12   0.00000000000000E+00  -1.57358502921892E-13   1.12815406817929E-22
      8.74829542436899E-09   8.74813806586618E-09  -4.99020990700151E-19  -3.91812379114389E-01  -3.91812379112011E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.37872234139908E-09   0.00000000000000E+00  -2.37872234139908E-09
      2.16675375055109E-18  -5.69753124227671E-03  -3.69073804258606E-03   0.00000000000000E+00   1.37349861573535E-12
      1.75416673003513E-22  -6.37078922308297E-09  -6.36941572446706E-09  -1.66773275985094E-18
      1.01414163353014E-08
      0.00000000000000E+00  -8.64497773439566E-12   0.00000000000000E+00  -2.32336257143735E-13   1.03093151118582E-22
      8.64521512922824E-09   8.64498279297120E-09  -4.85816755603256E-19  -3.97503237388876E-01  -3.97503237386598E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.27829738943299E-09   0.00000000000000E+00  -2.27829738943299E-09
      2.11945763168634E-18  -5.44699170281094E-03  -3.44105801673459E-03   0.00000000000000E+00   1.25919057623014E-12
      1.61053133545832E-22  -6.36794459411460E-09  -6.36668540353821E-09  -1.63364087608309E-18
      1.01694415442858E-08
      0.00000000000000E+00  -8.44126610726937E-12   0.00000000000000E+00  -3.47324909653061E-13   8.86531255204928E-23
      8.44161511711691E-09   8.44126779220734E-09  -4.69848830185144E-19  -4.04384559263717E-01  -4.04384559261645E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.07197241723188E-09   0.00000000000000E+00  -2.07197241723188E-09
      2.06139017168356E-18  -5.16350899953145E-03  -3.15675209929656E-03   0.00000000000000E+00   1.08359446669189E-12
      1.38849247249141E-22  -6.37037896944231E-09  -6.36929537497548E-09  -1.59154134149842E-18
      1.02072755764147E-08
      0.00000000000000E+00  -7.99407408180592E-12   0.00000000000000E+00  -5.74704228483481E-13   6.87011877208571E-23
      7.99460351118078E-09   7.99402880695236E-09  -4.53863719472710E-19  -4.11311837720215E-01  -4.11311837718625E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.58946099333174E-09   0.00000000000000E+00  -1.58946099333174E-09
      2.00125445339420E-18  -4.87943320029025E-03  -2.86156205261436E-03   0.00000000000000E+00   7.36678548331892E-13
      1.07158162122470E-22  -6.40530449216906E-09  -6.40456781362062E-09  -1.54739073392149E-18
      1.02572755764147E-08
      0.00000000000000E+00  -6.69520580821708E-12   0.00000000000000E+00  -1.27994419012571E-12   4.39455856300126E-23
      6.69645262777232E-09   6.69517268358224E-09  -4.53982818156807E-19  -4.11688446366681E-01  -4.11688446366472E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.08534457115809E-10   0.00000000000000E+00  -2.08534457115809E-10
      1.99082773053841E-18  -4.65383656600966E-03  -2.61010675694522E-03   0.00000000000000E+00  -6.57236692749247E-14
      6.67540499084135E-23  -6.48657250279723E-09  -6.48663822646643E-09  -1.53684491238161E-18
      1.03072755764147E-08
      0.00000000000000E+00  -4.21199964833718E-12   0.00000000000000E+00  -2.47699276163177E-12   1.96127842571925E-23
      4.21445608313566E-09   4.21197909037405E-09  -4.95518846626667E-19  -3.95289259690407E-01  -3.95289259692717E-01
      0.00000000000000E+00   0.00000000000000E+00   2.31069400121095E-09   0.00000000000000E+00   2.31069400121095E-09
      2.10636243059896E-18  -4.60714374246361E-03  -2.55205584345934E-03   0.00000000000000E+00  -1.53885033071944E-12
      2.55273590284978E-23  -6.52113424125432E-09  -6.52267309158502E-09  -1.61084358397229E-18
      1.03572755764147E-08
      0.00000000000000E+00  -1.44462587153719E-12   0.00000000000000E+00  -2.76918074885167E-12  -9.04287593113998E-24
      1.44736889701396E-09   1.44459971626510E-09  -5.90449734871976E-19  -3.57397060302826E-01  -3.57397060307848E-01
      0.00000000000000E+00   0.00000000000000E+00   5.02160530719833E-09   0.00000000000000E+00   5.02160530719833E-09
      2.35744269595888E-18  -5.32172129094144E-03  -3.28443068205299E-03   0.00000000000000E+00  -4.11209815760278E-12
     -2.61418113502534E-23  -6.46209292530579E-09  -6.46620502346341E-09  -1.76699296108690E-18
      1.04072755764147E-08
      0.00000000000000E+00   2.74064695827260E-13   0.00000000000000E+00  -1.77456004406525E-12  -3.29594669274080E-23
     -2.72209792546522E-10  -2.73984352590621E-10  -7.24889033095928E-19  -3.01701021098017E-01  -3.01701021104484E-01
      0.00000000000000E+00   0.00000000000000E+00   6.46719485137001E-09   0.00000000000000E+00   6.46719485137001E-09
      2.68080243852738E-18  -9.72859421693115E-03  -7.77731848146839E-03   0.00000000000000E+00  -8.31681484663763E-12
     -6.81790417724447E-23  -6.18489368393268E-09  -6.19321049877938E-09  -1.95591340543145E-18
      1.04572755764147E-08
      0.00000000000000E+00   1.40099962136361E-12   0.00000000000000E+00  -1.23002948448323E-12  -4.11600021093361E-23
     -1.39975337594345E-09  -1.40098340542797E-09  -8.62377077153448E-19  -2.39703149842937E-01  -2.39703149849592E-01
      0.00000000000000E+00   0.00000000000000E+00   6.65541670945538E-09   0.00000000000000E+00   6.65541670945538E-09
      3.01357327400015E-18  -2.73124092759157E-02  -2.56569133515079E-02   0.00000000000000E+00  -1.54665522638674E-11
     -8.08274683437421E-23  -5.23896675176345E-09  -5.25443330402740E-09  -2.15119619684670E-18
      1.04822755764147E-08
      0.00000000000000E+00   1.84947747314797E-12   0.00000000000000E+00  -1.03117837553663E-12  -4.25312671400360E-23
     -1.84837530993713E-09  -1.84940648831271E-09  -9.26803594249376E-19  -2.08599566213755E-01  -2.08599566220177E-01
      0.00000000000000E+00   0.00000000000000E+00   6.42247832671397E-09   0.00000000000000E+00   6.42247832671397E-09
      3.17413523216800E-18  -4.06901909268918E-02  -3.92493660067539E-02   0.00000000000000E+00  -2.32210640324768E-11
     -8.47720457417341E-23  -4.54985077436866E-09  -4.57307183840123E-09  -2.24733163791862E-18
      1.05160255764147E-08
      0.00000000000000E+00   2.12758333741236E-12   0.00000000000000E+00  -5.71942669994051E-13  -4.36910361213078E-23
     -2.12700152698378E-09  -2.12757346965382E-09  -1.00656672346846E-18  -1.68228529169509E-01  -1.68228529175579E-01
      0.00000000000000E+00   0.00000000000000E+00   6.06999618887095E-09   0.00000000000000E+00   6.06999618887095E-09
      3.37899760354239E-18  -6.28986106442714E-02  -6.16564809665547E-02   0.00000000000000E+00  -3.18549963488831E-11
     -9.11079702028984E-23  -3.91056772286815E-09  -3.94242271921713E-09  -2.37243088007393E-18
      1.05388068264147E-08
      0.00000000000000E+00   2.13107343742624E-12   0.00000000000000E+00  -1.94492709158321E-13  -4.44344243886283E-23
     -2.13091678536551E-09  -2.13111127807472E-09  -1.05699853065047E-18  -1.41657493403017E-01  -1.41657493408732E-01
      0.00000000000000E+00   0.00000000000000E+00   5.71432516167650E-09   0.00000000000000E+00   5.71432516167650E-09
      3.50917707363183E-18  -7.89779453365846E-02  -7.78489873879998E-02   0.00000000000000E+00  -4.08081749550006E-11
     -9.55959409941843E-23  -3.54240570864668E-09  -3.58321388360178E-09  -2.45217854298136E-18
      1.05541841701647E-08
      0.00000000000000E+00   2.07844640300633E-12   0.00000000000000E+00  -3.10034414197347E-14  -4.49397851338379E-23
     -2.07844689628381E-09  -2.07847789972527E-09  -1.08933237531028E-18  -1.24175409007342E-01  -1.24175409012790E-01
      0.00000000000000E+00   0.00000000000000E+00   5.44844128137562E-09   0.00000000000000E+00   5.44844128137562E-09
      3.59295962811724E-18  -9.01247335938705E-02  -8.90629616956166E-02   0.00000000000000E+00  -4.71934927378253E-11
     -9.86466983327882E-23  -3.32276988891248E-09  -3.36996338165040E-09  -2.50362725280695E-18
      1.05749435842272E-08
      0.00000000000000E+00   1.97769272628967E-12   0.00000000000000E+00   3.31958698870306E-14  -4.56019234557664E-23
     -1.97767764958065E-09  -1.97764445371080E-09  -1.12994499982161E-18  -1.01701537437728E-01  -1.01701537442847E-01
      0.00000000000000E+00   0.00000000000000E+00   5.11868904950359E-09   0.00000000000000E+00   5.11868904950359E-09
      3.69922061355307E-18  -1.05329509798228E-01  -1.04339862580261E-01   0.00000000000000E+00  -5.26105264534201E-11
     -1.02740681485092E-22  -3.08843406933925E-09  -3.14104459579278E-09  -2.56927561373146E-18
      1.06029687932116E-08
      0.00000000000000E+00   1.78004285181908E-12   0.00000000000000E+00   1.40255430086898E-13  -4.64112124864740E-23
     -1.78024411251771E-09  -1.78010385708767E-09  -1.17843543784872E-18  -7.40950551364896E-02  -7.40950551411193E-02
      0.00000000000000E+00   0.00000000000000E+00   4.62974828330247E-09   0.00000000000000E+00   4.62974828330247E-09
      3.82897027673767E-18  -1.25867903898781E-01  -1.24970067775516E-01   0.00000000000000E+00  -5.85959019191262E-11
     -1.08197485469983E-22  -2.79104852429551E-09  -2.84964442621474E-09  -2.65053483888895E-18
      1.06408028253405E-08
      0.00000000000000E+00   1.36260852121087E-12   0.00000000000000E+00   3.66748227072635E-13  -4.72225173877586E-23
     -1.36293507839132E-09  -1.36256833016429E-09  -1.22764291156014E-18  -4.51756178139203E-02  -4.51756178176891E-02
      0.00000000000000E+00   0.00000000000000E+00   3.76880272139190E-09   0.00000000000000E+00   3.76880272139190E-09
      3.97155927998632E-18  -1.53696008447995E-01  -1.52937877474028E-01   0.00000000000000E+00  -6.19136406391591E-11
     -1.15102410398058E-22  -2.34432075058834E-09  -2.40623439122762E-09  -2.74391636842618E-18
      1.06908028253405E-08
      0.00000000000000E+00   7.45411887176287E-13   0.00000000000000E+00   5.09348148319107E-13  -4.77417983567101E-23
     -7.45901086045597E-10  -7.45391737897326E-10  -1.26172930696275E-18  -2.45497433539777E-02  -2.45497433564974E-02
      0.00000000000000E+00   0.00000000000000E+00   2.51963428396320E-09   0.00000000000000E+00   2.51963428396320E-09
      4.09754099418448E-18  -1.89191488070989E-01  -1.88632478660946E-01   0.00000000000000E+00  -5.64671115377885E-11
     -1.22507120249655E-22  -1.71777543452798E-09  -1.77424254606589E-09  -2.83581168722173E-18
      1.07408028253405E-08
      0.00000000000000E+00   3.57827096160524E-13   0.00000000000000E+00   3.42947977643177E-13  -4.79292750329306E-23
     -3.58148432264074E-10  -3.57805484286479E-10  -1.27649163474340E-18  -1.54960337653804E-02  -1.54960337669785E-02
      0.00000000000000E+00   0.00000000000000E+00   1.59809494205513E-09   0.00000000000000E+00   1.59809494205513E-09
      4.17744574128724E-18  -2.19075686371322E-01  -2.18684909334552E-01   0.00000000000000E+00  -4.57008439990722E-11
     -1.27938858019451E-22  -1.19458861376945E-09  -1.24028945776865E-09  -2.90095410654384E-18
      1.07908028253405E-08
      0.00000000000000E+00   2.04079006075124E-13   0.00000000000000E+00   1.37683573109305E-13  -4.79962321342334E-23
     -2.04234977217751E-10  -2.04097293644690E-10  -1.28363290267222E-18  -1.12262211963313E-02  -1.12262211973916E-02
      0.00000000000000E+00   0.00000000000000E+00   1.06029438660157E-09   0.00000000000000E+00   1.06029438660157E-09
      4.23046046061732E-18  -2.40729596148076E-01  -2.40459836150668E-01   0.00000000000000E+00  -3.30355546478148E-11
     -1.31612524919680E-22  -8.23161538308922E-10  -8.56197092956868E-10  -2.94682755794510E-18
      1.08408028253405E-08
      0.00000000000000E+00   1.45390218999515E-13   0.00000000000000E+00   5.32873478307510E-14  -4.80196047751452E-23
     -1.45474722938091E-10  -1.45421435590309E-10  -1.28789600862627E-18  -8.86544830983519E-03  -8.86544831057240E-03
      0.00000000000000E+00   0.00000000000000E+00   7.37211996421859E-10   0.00000000000000E+00   7.37211996421859E-10
      4.26732106043841E-18  -2.55027284663517E-01  -2.54840832737835E-01   0.00000000000000E+00  -2.16075134238908E-11
     -1.33920837196642E-22  -5.70183047407546E-10  -5.91790560831571E-10  -2.97942505181213E-18
      1.08908028253405E-08
      0.00000000000000E+00   1.18112332048879E-13   0.00000000000000E+00   2.63882315713236E-14  -4.80233522608451E-23
     -1.18092907631697E-10  -1.18066519400174E-10  -1.29084093901155E-18  -7.38526886729452E-03  -7.38526886785898E-03
      0.00000000000000E+00   0.00000000000000E+00   5.64462192139280E-10   0.00000000000000E+00   5.64462192139280E-10
      4.29554417004537E-18  -2.65050680129509E-01  -2.64910038855405E-01   0.00000000000000E+00  -1.46052430450445E-11
     -1.35440797829501E-22  -4.31790429693932E-10  -4.46395672739112E-10  -3.00470323103382E-18
      1.09158028253405E-08
      0.00000000000000E+00   1.06723584635146E-13   0.00000000000000E+00   2.34350999736414E-14  -4.80209904313648E-23
     -1.06726531972775E-10  -1.06703096872849E-10  -1.29204117727740E-18  -6.82404211360810E-03  -6.82404211410524E-03
      0.00000000000000E+00   0.00000000000000E+00   4.97145622709101E-10   0.00000000000000E+00   4.97145622709101E-10
      4.30797281061310E-18  -2.69242687275394E-01  -2.69119675579703E-01   0.00000000000000E+00  -1.18026125235900E-11
     -1.36046122374993E-22  -3.78639913312520E-10  -3.90442525836246E-10  -3.01593163333570E-18
      1.09495528253405E-08
      0.00000000000000E+00   9.88249372352988E-14   0.00000000000000E+00   1.34903193024508E-14  -4.80147693847620E-23
     -9.88184749743611E-11  -9.88049846551067E-11  -1.29341627146550E-18  -6.21180263270980E-03  -6.21180263317347E-03
      0.00000000000000E+00   0.00000000000000E+00   4.63666256674932E-10   0.00000000000000E+00   4.63666256674932E-10
      4.32362154677588E-18  -2.74454408812617E-01  -2.74339457230673E-01   0.00000000000000E+00  -1.06383396216362E-11
     -1.36771782042125E-22  -3.54222932398054E-10  -3.64861272019827E-10  -3.03020527531038E-18
      1.09723340753405E-08
      0.00000000000000E+00   9.40490109005074E-14   0.00000000000000E+00   1.28720305947343E-14  -4.80092003785386E-23
     -9.40162913601996E-11  -9.40034193296529E-11  -1.29424463905558E-18  -5.85994002686081E-03  -5.85994002729909E-03
      0.00000000000000E+00   0.00000000000000E+00   4.38279765221053E-10   0.00000000000000E+00   4.38279765221053E-10
      4.33360610767732E-18  -2.77698911989498E-01  -2.77590446287374E-01   0.00000000000000E+00  -9.59257012030544E-12
     -1.37209447326466E-22  -3.34683775770889E-10  -3.44276345891332E-10  -3.03936146862174E-18
      1.09877114190905E-08
      0.00000000000000E+00   9.06507556238289E-14   0.00000000000000E+00   1.35034740854610E-14  -4.80047729642793E-23
     -9.06979217671093E-11  -9.06844182930718E-11  -1.29475709427756E-18  -5.65002367380744E-03  -5.65002367423255E-03
      0.00000000000000E+00   0.00000000000000E+00   4.25107223120934E-10   0.00000000000000E+00   4.25107223120934E-10
      4.34014312757786E-18  -2.79811036057368E-01  -2.79705674993779E-01   0.00000000000000E+00  -9.12667767672704E-12
     -1.37488580142134E-22  -3.25296127150891E-10  -3.34422804827756E-10  -3.04538603330030E-18
      1.10084708331530E-08
      0.00000000000000E+00   8.67932766611128E-14   0.00000000000000E+00   1.24508218616663E-14  -4.79978439293631E-23
     -8.68386322373533E-11  -8.68261814155396E-11  -1.29537683141687E-18  -5.40456111538061E-03  -5.40456111580046E-03
      0.00000000000000E+00   0.00000000000000E+00   4.19844519771816E-10   0.00000000000000E+00   4.19844519771816E-10
      4.34885885380567E-18  -2.82691029006299E-01  -2.82586110453326E-01   0.00000000000000E+00  -9.19828316503235E-12
     -1.37864957129716E-22  -3.23820055191190E-10  -3.33018338356360E-10  -3.05348202238880E-18
      1.10364960421374E-08
      0.00000000000000E+00   8.22928845379440E-14   0.00000000000000E+00   1.17497061599197E-14  -4.79870255022302E-23
     -8.22927916037495E-11  -8.22810418976376E-11  -1.29610108807685E-18  -5.12760486184872E-03  -5.12760486226971E-03
      0.00000000000000E+00   0.00000000000000E+00   4.20989049425772E-10   0.00000000000000E+00   4.20989049425772E-10
      4.36065715989597E-18  -2.86769140988241E-01  -2.86662429736095E-01   0.00000000000000E+00  -9.73746906834054E-12
     -1.38397011622851E-22  -3.28970538459638E-10  -3.38708007528117E-10  -3.06455607181911E-18
      1.10743300742663E-08
      0.00000000000000E+00   7.50371502985494E-14   0.00000000000000E+00   1.40339874650104E-14  -4.79688247386337E-23
     -7.50446447648764E-11  -7.50306107774593E-11  -1.29683444505519E-18  -4.85102474063629E-03  -4.85102474109277E-03
      0.00000000000000E+00   0.00000000000000E+00   4.56480111494929E-10   0.00000000000000E+00   4.56480111494929E-10
      4.37792764310047E-18  -2.93613825581259E-01  -2.93493647337909E-01   0.00000000000000E+00  -1.27525251001818E-11
     -1.39321865020862E-22  -3.68696975617190E-10  -3.81449500717511E-10  -3.08109319804528E-18
      1.11243300742663E-08
      0.00000000000000E+00   6.50260739429289E-14   0.00000000000000E+00   1.55926014296361E-14  -4.79382536453913E-23
     -6.50706667358356E-11  -6.50550741344539E-11  -1.29736576444509E-18  -4.63051052795422E-03  -4.63051052849059E-03
      0.00000000000000E+00   0.00000000000000E+00   5.36375038349619E-10   0.00000000000000E+00   5.36375038349619E-10
      4.40474639501795E-18  -3.06229104876515E-01  -3.06080610316348E-01   0.00000000000000E+00  -1.91540859140637E-11
     -1.41117688873257E-22  -4.52165878300970E-10  -4.71319964215175E-10  -3.10738063057287E-18
      1.11743300742663E-08
      0.00000000000000E+00   5.54742212733462E-14   0.00000000000000E+00   1.63492931302391E-14  -4.79015475039658E-23
     -5.54519404811282E-11  -5.54355911880458E-11  -1.29748248807853E-18  -4.59070853019327E-03  -4.59070853076218E-03
      0.00000000000000E+00   0.00000000000000E+00   5.68911158359075E-10   0.00000000000000E+00   5.68911158359075E-10
      4.43319195293590E-18  -3.20673772415303E-01  -3.20511995562761E-01   0.00000000000000E+00  -2.28622109501541E-11
     -1.43207394071347E-22  -4.90613356220739E-10  -5.13475567171036E-10  -3.13570946485738E-18
      1.12243300742663E-08
      0.00000000000000E+00   2.70941974762204E-14   0.00000000000000E+00   3.90405418974443E-14  -4.78413161881221E-23
     -2.71358451541917E-11  -2.70968046123421E-11  -1.29625658002467E-18  -5.34102533644940E-03  -5.34102533696603E-03
      0.00000000000000E+00   0.00000000000000E+00   5.16629914720715E-10   0.00000000000000E+00   5.16629914720715E-10
      4.45902344867194E-18  -3.35030931284441E-01  -3.34876698412522E-01   0.00000000000000E+00  -2.20672998547985E-11
     -1.45174833172760E-22  -4.67465810253417E-10  -4.89533110108361E-10  -3.16276686864727E-18
      1.12743300742663E-08
      0.00000000000000E+00  -1.04611155679373E-13   0.00000000000000E+00   1.61935916192873E-13  -4.76635165211482E-23
      1.04489386748444E-10   1.04651322664589E-10  -1.28856606356402E-18  -9.93204723682563E-03  -9.93204723710490E-03
      0.00000000000000E+00   0.00000000000000E+00   2.79278102178290E-10   0.00000000000000E+00   2.79278102178290E-10
      4.47298735378086E-18  -3.49049017748326E-01  -3.48928058999354E-01   0.00000000000000E+00  -1.47475847311232E-11
     -1.46469999776462E-22  -3.69181840111611E-10  -3.83929424842880E-10  -3.18442129021684E-18
      1.13243300742663E-08
      0.00000000000000E+00  -5.75223589130740E-13   0.00000000000000E+00   5.65296160197698E-13  -4.70687115520453E-23
      5.74638224879269E-10   5.75203521039419E-10  -1.25778507165816E-18  -2.79610561471221E-02  -2.79610561466234E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.98641209955392E-10   0.00000000000000E+00  -4.98641209955392E-10
      4.44805529328308E-18  -3.63927486434087E-01  -3.63903374725181E-01   0.00000000000000E+00   9.05325771865545E-12
     -1.45719241832584E-22  -8.56155688025029E-11  -7.65623110839932E-11  -3.19027022162492E-18
      1.13493300742663E-08
      0.00000000000000E+00  -9.14130669426514E-13   0.00000000000000E+00   8.07732463504608E-13  -4.66284969369812E-23
      9.13304857904008E-10   9.14112590367465E-10  -1.23418581893247E-18  -4.15036984096648E-02  -4.15036984086238E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.04098844216696E-09   0.00000000000000E+00  -1.04098844216696E-09
      4.42203058222891E-18  -3.71657015694062E-01  -3.71697004709511E-01   0.00000000000000E+00   2.46152505398383E-11
     -1.44667385972356E-22   1.02260601259671E-10   1.26875851799364E-10  -3.18784476329644E-18
      1.13830800742663E-08
      0.00000000000000E+00  -1.18286837049574E-12   0.00000000000000E+00   5.49512882554534E-13  -4.59291440561035E-23
      1.18234341685004E-09   1.18289292973255E-09  -1.19429351244334E-18  -6.38158568291126E-02  -6.38158568276722E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.44043860463371E-09   0.00000000000000E+00  -1.44043860463371E-09
      4.37341577932253E-18  -3.81996654493135E-01  -3.82077816916872E-01   0.00000000000000E+00   3.45335757893531E-11
     -1.42619213636103E-22   2.23012099111920E-10   2.57545674901131E-10  -3.17912226687918E-18
      1.14058613242663E-08
      0.00000000000000E+00  -1.33909626848574E-12   0.00000000000000E+00   4.91538371127874E-13  -4.54354698325630E-23
      1.33861658886131E-09   1.33910812723239E-09  -1.16471588546439E-18  -7.99302022145005E-02  -7.99302022128656E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.63492535166815E-09   0.00000000000000E+00  -1.63492535166815E-09
      4.33617013615483E-18  -3.88755676389893E-01  -3.88848899355421E-01   0.00000000000000E+00   3.78762215275610E-11
     -1.41058538133316E-22   2.57941002908418E-10   2.95817224435838E-10  -3.17145425069044E-18
      1.14212386680163E-08
      0.00000000000000E+00  -1.43966625572798E-12   0.00000000000000E+00   4.70197194939656E-13  -4.50931418391719E-23
      1.43917045830729E-09   1.43964065550219E-09  -1.14384508490445E-18  -9.10897133101305E-02  -9.10897133083956E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.73492937363418E-09   0.00000000000000E+00  -1.73492937363418E-09
      4.30949153079449E-18  -3.93176990207577E-01  -3.93270048699836E-01   0.00000000000000E+00   3.89681042182041E-11
     -1.39949252613573E-22   2.56320613913987E-10   2.95288718132051E-10  -3.16564644589003E-18
      1.14419980820788E-08
      0.00000000000000E+00  -1.56301373779769E-12   0.00000000000000E+00   4.33545767780878E-13  -4.45898874247948E-23
      1.56257206578028E-09   1.56300561154802E-09  -1.11486477684392E-18  -1.06300746483742E-01  -1.06300746481932E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.81061924414360E-09   0.00000000000000E+00  -1.81061924414360E-09
      4.27190413619578E-18  -3.98818862342326E-01  -3.98896904078789E-01   0.00000000000000E+00   3.95076773423430E-11
     -1.38389899410789E-22   2.08105955253202E-10   2.47613632595407E-10  -3.15703935935187E-18
      1.14700232910631E-08
      0.00000000000000E+00  -1.79528907819553E-12   0.00000000000000E+00   5.37877297954232E-13  -4.36345428305062E-23
      1.79473517670488E-09   1.79527305400279E-09  -1.07473286674368E-18  -1.26844680563442E-01  -1.26844680561545E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.89718840334179E-09   0.00000000000000E+00  -1.89718840334179E-09
      4.21873503470940E-18  -4.05611952803254E-01  -4.05644098981968E-01   0.00000000000000E+00   4.00075497812311E-11
     -1.36172380961990E-22   6.19077995579360E-11   1.01915349339031E-10  -3.14400216796572E-18
      1.15078573231921E-08
      0.00000000000000E+00  -2.39880084638618E-12   0.00000000000000E+00   9.01936842193593E-13  -4.05718340509538E-23
      2.39792512755109E-09   2.39882706439324E-09  -1.01842972324026E-18  -1.54688695192515E-01  -1.54688695190450E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.06555475264619E-09   0.00000000000000E+00  -2.06555475264619E-09
      4.14058676983377E-18  -4.12330122945849E-01  -4.12225180096420E-01   0.00000000000000E+00   4.23439246235499E-11
     -1.32809189752130E-22  -3.75616236370418E-10  -3.33272311747001E-10  -3.12215704659350E-18
      1.15578573231921E-08
      0.00000000000000E+00  -4.11335840057629E-12   0.00000000000000E+00   1.78472092076222E-12  -2.69091341562160E-23
      4.11158710108317E-09   4.11337182200391E-09  -9.43394571826296E-19  -1.90102552855883E-01  -1.90102552853541E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.34202931869479E-09   0.00000000000000E+00  -2.34202931869479E-09
      4.02348530389902E-18  -4.12085622437342E-01  -4.11527655624553E-01   0.00000000000000E+00   4.82099217591336E-11
     -1.27251731828091E-22  -1.81955242506810E-09  -1.77134250330909E-09  -3.08009073207273E-18
      1.16078573231921E-08
      0.00000000000000E+00  -7.08407642555375E-12   0.00000000000000E+00   2.99442660772108E-12   5.93184113696192E-24
      7.08107607964115E-09   7.08407050624887E-09  -8.77666812800764E-19  -2.19781883232502E-01  -2.19781883229928E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.57419665034595E-09   0.00000000000000E+00  -2.57419665034595E-09
      3.89477547138173E-18  -3.94710241340450E-01  -3.93289541066588E-01   0.00000000000000E+00   5.40201064598930E-11
     -1.20247381593180E-22  -4.56389396236268E-09  -4.50987385590291E-09  -3.01710865858096E-18
      1.16578573231921E-08
      0.00000000000000E+00  -1.03220626358051E-11   0.00000000000000E+00   3.23344734843203E-12   4.53537120749781E-23
      1.03188292897995E-08   1.03220627371480E-08  -8.29343350471495E-19  -2.41212717403657E-01  -2.41212717400917E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.74031386697721E-09   0.00000000000000E+00  -2.74031386697721E-09
      3.75775977803287E-18  -3.55806604078426E-01  -3.53418105341966E-01   0.00000000000000E+00   5.64926604139831E-11
     -1.12239825585051E-22  -7.63824153058468E-09  -7.58174887017081E-09  -2.92841642756137E-18
      1.17078573231921E-08
      0.00000000000000E+00  -1.23777315439840E-11   0.00000000000000E+00   2.05113012394949E-12   7.20638199433237E-23
      1.23757263804333E-08   1.23777775105573E-08  -7.98296984881687E-19  -2.55347563480142E-01  -2.55347563477282E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.86022156453687E-09   0.00000000000000E+00  -2.86022156453687E-09
      3.61474869980602E-18  -2.99468917357710E-01  -2.96470486112278E-01   0.00000000000000E+00   5.15514405247050E-11
     -1.04318939872112E-22  -9.56910738654506E-09  -9.51755594602046E-09  -2.81645171492434E-18
      1.17578573231921E-08
      0.00000000000000E+00  -1.31873429024683E-11   0.00000000000000E+00   8.12786798783752E-13   8.26567080448737E-23
      1.31865339450409E-08   1.31873467318398E-08  -7.77813054598712E-19  -2.65296380896504E-01  -2.65296380893600E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.90317381172411E-09   0.00000000000000E+00  -2.90317381172411E-09
      3.46959000921982E-18  -2.37366893052489E-01  -2.34126868748237E-01   0.00000000000000E+00   3.95755977791971E-11
     -9.61737359296366E-23  -1.03237485178948E-08  -1.02841729201157E-08  -2.69177695462110E-18
      1.17828573231921E-08
      0.00000000000000E+00  -1.32640332580366E-11   0.00000000000000E+00   1.61916903144087E-13   8.37654868956568E-23
      1.32637833338668E-08   1.32639452507700E-08  -7.69673749773373E-19  -2.69464735569279E-01  -2.69464735566362E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.91648843408500E-09   0.00000000000000E+00  -2.91648843408500E-09
      3.39667779836769E-18  -2.06282988572306E-01  -2.03022994156222E-01   0.00000000000000E+00   3.12709814144850E-11
     -9.22427024979110E-23  -1.03787277980994E-08  -1.03474568166850E-08  -2.62700404859432E-18
      1.18166073231921E-08
      0.00000000000000E+00  -1.32766159870340E-11   0.00000000000000E+00   2.70059630049936E-14   8.26340260789058E-23
      1.32765911184714E-08   1.32766181244345E-08  -7.59943285237934E-19  -2.74656171736538E-01  -2.74656171733648E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.88960869588240E-09   0.00000000000000E+00  -2.88960869588240E-09
      3.29915350488166E-18  -1.65976131628765E-01  -1.62703642395427E-01   0.00000000000000E+00   2.52361897305090E-11
     -8.81341435106693E-23  -1.04122456182824E-08  -1.03870094285520E-08  -2.53921021964373E-18
      1.18393885731921E-08
      0.00000000000000E+00  -1.31696168681873E-11   0.00000000000000E+00  -2.24046715755859E-13   8.06594571625257E-23
      1.31698071637273E-08   1.31695831170116E-08  -7.54127244555359E-19  -2.77892118468011E-01  -2.77892118465133E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.87749554795367E-09   0.00000000000000E+00  -2.87749554795367E-09
      3.23360055942984E-18  -1.39472211360391E-01  -1.36229608964291E-01   0.00000000000000E+00   2.12904467325628E-11
     -8.57997478861271E-23  -1.03133780157904E-08  -1.02920875690580E-08  -2.47947331487448E-18
      1.18547659169421E-08
      0.00000000000000E+00  -1.30642709546102E-11   0.00000000000000E+00  -3.30847377938941E-13   7.90461354429778E-23
      1.30645720880847E-08   1.30642412407068E-08  -7.50426775008406E-19  -2.80000948697800E-01  -2.80000948694934E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.86602052037352E-09   0.00000000000000E+00  -2.86602052037352E-09
      3.18952877669351E-18  -1.22050910916017E-01  -1.18837870795474E-01   0.00000000000000E+00   1.89385604112706E-11
     -8.41410438813896E-23  -1.02171592807445E-08  -1.01982207203333E-08  -2.43910200168510E-18
      1.18755253310046E-08
      0.00000000000000E+00  -1.29274222961710E-11   0.00000000000000E+00  -3.18107712749184E-13   7.71545779774920E-23
      1.29277742555681E-08   1.29274561478554E-08  -7.45394524279725E-19  -2.82880617942430E-01  -2.82880617939592E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.83833809415631E-09   0.00000000000000E+00  -2.83833809415631E-09
      3.13060654094754E-18  -9.96899562457958E-02  -9.65112768452528E-02   0.00000000000000E+00   1.66533706044546E-11
     -8.13671867041818E-23  -1.01057714243034E-08  -1.00891180536990E-08  -2.38521201666782E-18
      1.19035505399889E-08
      0.00000000000000E+00  -1.26570313898321E-11   0.00000000000000E+00  -4.67989703533436E-13   7.52331397340799E-23
      1.26575214992304E-08   1.26570535095270E-08  -7.38107830014869E-19  -2.86973829631103E-01  -2.86973829628312E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.79096361173889E-09   0.00000000000000E+00  -2.79096361173889E-09
      3.05238920246078E-18  -7.23349231890415E-02  -6.92264963366963E-02   0.00000000000000E+00   1.38255227646905E-11
     -7.34871134179999E-23  -9.87991542055269E-09  -9.86608989778808E-09  -2.31428137244591E-18
      1.19413845721178E-08
      0.00000000000000E+00  -1.19512045843922E-11   0.00000000000000E+00  -9.08590292000679E-13   7.63601736761332E-23
      1.19521294173314E-08   1.19512208270395E-08  -7.24509431035638E-19  -2.93888319396012E-01  -2.93888319393335E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.67732937408296E-09   0.00000000000000E+00  -2.67732937408296E-09
      2.95109503690206E-18  -4.39960503186534E-02  -4.10741882563506E-02   0.00000000000000E+00   1.02051886575479E-11
     -4.19608133731299E-23  -9.28409664161412E-09  -9.27389145295662E-09  -2.22658560586642E-18
      1.19913845721178E-08
      0.00000000000000E+00  -1.06927479951747E-11   0.00000000000000E+00  -1.22404811457384E-12   8.88838901522455E-23
      1.06939749947230E-08   1.06927509466085E-08  -6.96539052268081E-19  -3.06585387227173E-01  -3.06585387224712E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.46073195149786E-09   0.00000000000000E+00  -2.46073195149786E-09
      2.82805843932717E-18  -2.40283502573185E-02  -2.14347332679562E-02   0.00000000000000E+00   6.38585547719262E-12
      3.21849308732608E-23  -8.23840485058785E-09  -8.23201899511063E-09  -2.13151938705908E-18
      1.20413845721178E-08
      0.00000000000000E+00  -9.69412016751724E-12   0.00000000000000E+00  -9.66153265967582E-13   1.06942564676741E-22
      9.69504231850542E-09   9.69407616523956E-09  -6.63257637608437E-19  -3.21044629131621E-01  -3.21044629129345E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.27588707752305E-09   0.00000000000000E+00  -2.27588707752305E-09
      2.71426408545101E-18  -1.52669175228235E-02  -1.29297035326756E-02   0.00000000000000E+00   3.95064029826651E-12
      1.00348703050073E-22  -7.42213972801486E-09  -7.41818908771649E-09  -2.05100644784257E-18
      1.20913845721178E-08
      0.00000000000000E+00  -9.09115946774983E-12   0.00000000000000E+00  -5.77124661837409E-13   1.21765560839245E-22
      9.09175092036929E-09   9.09117379570757E-09  -6.29959302952196E-19  -3.35389921116900E-01  -3.35389921114742E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.15779710385359E-09   0.00000000000000E+00  -2.15779710385359E-09
      2.60637423025833E-18  -1.11074127190041E-02  -8.92294269636733E-03   0.00000000000000E+00   2.68220526721748E-12
      1.49233334901231E-22  -6.93605889712133E-09  -6.93337669185397E-09  -1.97641492730614E-18
      1.21413845721178E-08
      0.00000000000000E+00  -8.76630463224681E-12   0.00000000000000E+00  -3.04395024640507E-13   1.29686880507782E-22
      8.76658192436925E-09   8.76627752934474E-09  -5.97508762798132E-19  -3.49409907410095E-01  -3.49409907407969E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.12627878430885E-09   0.00000000000000E+00  -2.12627878430885E-09
      2.50006029104289E-18  -8.79391931938198E-03  -6.70188012276143E-03   0.00000000000000E+00   2.07656491839791E-12
      1.78889968589229E-22  -6.64207530995447E-09  -6.63999874503589E-09  -1.90255152824476E-18
      1.21913845721178E-08
      0.00000000000000E+00  -8.77585648491639E-12   0.00000000000000E+00   2.53295110875072E-14   1.31655579544003E-22
      8.77582135569135E-09   8.77584668520257E-09  -5.62995920589460E-19  -3.64317559367098E-01  -3.64317559364809E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.28910839536685E-09   0.00000000000000E+00  -2.28910839536685E-09
      2.38560487127455E-18  -7.33766260112742E-03  -5.29390852083601E-03   0.00000000000000E+00   1.83974176932191E-12
      1.93720661321250E-22  -6.48857803160524E-09  -6.48673828983573E-09  -1.82260895068509E-18
      1.22163845721178E-08
      0.00000000000000E+00  -8.83941304306400E-12   0.00000000000000E+00   1.41141678034863E-13   1.29671464592674E-22
      8.83927733714614E-09   8.83941847882430E-09  -5.45032586895541E-19  -3.72050287943844E-01  -3.72050287941431E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.41281466372326E-09   0.00000000000000E+00  -2.41281466372326E-09
      2.32528450468147E-18  -6.78362217179985E-03  -4.75881346265513E-03   0.00000000000000E+00   1.74845010645310E-12
      1.94889320235306E-22  -6.42835226520766E-09  -6.42660381510101E-09  -1.78025191778592E-18
      1.22501345721178E-08
      0.00000000000000E+00  -8.83629032199894E-12   0.00000000000000E+00   1.07319142157292E-14   1.22553207312723E-22
      8.83624860452428E-09   8.83625933643862E-09  -5.21050178828803E-19  -3.82376810814133E-01  -3.82376810811696E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.43623896475031E-09   0.00000000000000E+00  -2.43623896475031E-09
      2.24306143962114E-18  -6.17901422984648E-03  -4.16257974977338E-03   0.00000000000000E+00   1.57481797669015E-12
      1.88032309524192E-22  -6.40159518966525E-09  -6.40002037168837E-09  -1.72201126079234E-18
      1.22729158221178E-08
      0.00000000000000E+00  -8.78329590863020E-12   0.00000000000000E+00  -1.00289770342208E-13   1.14782907788712E-22
      8.78340516341826E-09   8.78330487364804E-09  -5.05380357651765E-19  -3.89121298907413E-01  -3.89121298905008E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.40468328959594E-09   0.00000000000000E+00  -2.40468328959594E-09
      2.18827974843004E-18  -5.83168041530705E-03  -3.82198712319601E-03   0.00000000000000E+00   1.46559278673041E-12
      1.77779581192226E-22  -6.38008717683901E-09  -6.37862158405210E-09  -1.68289939077827E-18
      1.22882931658678E-08
      0.00000000000000E+00  -8.72635217156153E-12   0.00000000000000E+00  -1.69202978047564E-13   1.08324263709657E-22
      8.72649148477043E-09   8.72632228179249E-09  -4.95133560508218E-19  -3.93530374337634E-01  -3.93530374335276E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.35843039219797E-09   0.00000000000000E+00  -2.35843039219797E-09
      2.15201335357876E-18  -5.62449718506279E-03  -3.61818389936587E-03   0.00000000000000E+00   1.36895870860630E-12
      1.68536739319925E-22  -6.36926084830326E-09  -6.36789188959448E-09  -1.65687979307054E-18
      1.23090525799303E-08
      0.00000000000000E+00  -8.61760800270782E-12   0.00000000000000E+00  -2.45667037372054E-13   9.85372676175444E-23
      8.61789476554238E-09   8.61764909850511E-09  -4.82067554877992E-19  -3.99150881001908E-01  -3.99150880999656E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.25215111452348E-09   0.00000000000000E+00  -2.25215111452348E-09
      2.10526001606105E-18  -5.38227554303028E-03  -3.37671578075886E-03   0.00000000000000E+00   1.23480234939154E-12
      1.53934558812318E-22  -6.36673278633112E-09  -6.36549798398157E-09  -1.62319246118305E-18
      1.23370777889147E-08
      0.00000000000000E+00  -8.40498743607240E-12   0.00000000000000E+00  -3.63300029236567E-13   8.42176109002713E-23
      8.40536391012941E-09   8.40500061010026E-09  -4.66370000548303E-19  -4.05902560537610E-01  -4.05902560535576E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.03453160892310E-09   0.00000000000000E+00  -2.03453160892310E-09
      2.04824184253566E-18  -5.10934977652526E-03  -3.10222292413292E-03   0.00000000000000E+00   1.05250035823978E-12
      1.31781869848593E-22  -6.37152150153552E-09  -6.37046900117715E-09  -1.58187184198736E-18
      1.23749118210436E-08
      0.00000000000000E+00  -7.93272179735129E-12   0.00000000000000E+00  -6.07594158665979E-13   6.46999654516434E-23
      7.93341358082653E-09   7.93280598666793E-09  -4.51094386546755E-19  -4.12516583538606E-01  -4.12516583537084E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.52163556917218E-09   0.00000000000000E+00  -1.52163556917218E-09
      1.99067223352311E-18  -4.83780342605904E-03  -2.81785184923268E-03   0.00000000000000E+00   6.90335433658919E-13
      1.00668235109664E-22  -6.41186075292950E-09  -6.41117041749574E-09  -1.53957784697636E-18
      1.24249118210436E-08
      0.00000000000000E+00  -6.55183617343613E-12   0.00000000000000E+00  -1.36166705483002E-12   4.06877646560065E-23
      6.55318462417381E-09   6.55182295711902E-09  -4.53455641487274E-19  -4.11959999446863E-01  -4.11959999446804E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.88955731316426E-11   0.00000000000000E+00  -5.88955731316426E-11
      1.98772745486653E-18  -4.62171862838259E-03  -2.57600719166679E-03   0.00000000000000E+00  -1.44414405873957E-13
      6.13863960629625E-23  -6.49278296958158E-09  -6.49292738398739E-09  -1.53427181337926E-18
      1.24749118210436E-08
      0.00000000000000E+00  -3.99671558432273E-12   0.00000000000000E+00  -2.55390870134311E-12   1.68843684915294E-23
      3.99929514227317E-09   3.99674123357185E-09  -4.98606266224467E-19  -3.94099649308294E-01  -3.94099649310820E-01
      0.00000000000000E+00   0.00000000000000E+00   2.52605700551650E-09   0.00000000000000E+00   2.52605700551650E-09
      2.11403030514236E-18  -4.59317887099577E-03  -2.53805003807974E-03   0.00000000000000E+00  -1.66687000769801E-12
      2.08711515854935E-23  -6.52113136908070E-09  -6.52279823908837E-09  -1.61542403891789E-18
      1.25249118210436E-08
      0.00000000000000E+00  -1.26754921820108E-12   0.00000000000000E+00  -2.73381332710545E-12  -1.14189274898543E-23
      1.27024775417559E-09   1.26751394084848E-09  -5.97216797000524E-19  -3.54703515338188E-01  -3.54703515343379E-01
      0.00000000000000E+00   0.00000000000000E+00   5.19142293400929E-09   0.00000000000000E+00   5.19142293400929E-09
      2.37360145184282E-18  -5.39866118563010E-03  -3.36366062790311E-03   0.00000000000000E+00  -4.32752973731907E-12
     -3.02617315746343E-23  -6.45460934512036E-09  -6.45893687485771E-09  -1.77638465484230E-18
      1.25749118210436E-08
      0.00000000000000E+00   3.65725743560372E-13   0.00000000000000E+00  -1.69320775656628E-12  -3.40012851926591E-23
     -3.64023882799480E-10  -3.65717090556080E-10  -7.33380330008559E-19  -2.98079815360299E-01  -2.98079815366826E-01
      0.00000000000000E+00   0.00000000000000E+00   6.52685389449342E-09   0.00000000000000E+00   6.52685389449342E-09
      2.69994414656749E-18  -1.02562973520793E-02  -8.31512717108569E-03   0.00000000000000E+00  -8.66043811159151E-12
     -6.97360886932780E-23  -6.15247636582570E-09  -6.16113680393736E-09  -1.96656381655893E-18
      1.26249118210436E-08
      0.00000000000000E+00   1.47585308218775E-12   0.00000000000000E+00  -1.21559137652961E-12  -4.13829365857736E-23
     -1.47461996491934E-09  -1.47583555629591E-09  -8.70316146086631E-19  -2.35972756733023E-01  -2.35972756739677E-01
      0.00000000000000E+00   0.00000000000000E+00   6.65392882888797E-09   0.00000000000000E+00   6.65392882888797E-09
      3.03264058801189E-18  -2.88782487155002E-02  -2.72468049408325E-02   0.00000000000000E+00  -1.60574476070513E-11
     -8.12741846353899E-23  -5.16203582498492E-09  -5.17809327259205E-09  -2.16232444192526E-18
      1.26499118210436E-08
      0.00000000000000E+00   1.89402217069362E-12   0.00000000000000E+00  -9.73965893802715E-13  -4.26507551528597E-23
     -1.89309249597241E-09  -1.89406646186626E-09  -9.34314442793251E-19  -2.04916900950346E-01  -2.04916900956747E-01
      0.00000000000000E+00   0.00000000000000E+00   6.40014082407278E-09   0.00000000000000E+00   6.40014082407278E-09
      3.19264410861371E-18  -4.26319211161966E-02  -4.12122046587566E-02   0.00000000000000E+00  -2.40647753109552E-11
     -8.53196755947055E-23  -4.48200958689558E-09  -4.50607436220662E-09  -2.25832966582046E-18
      1.26836618210436E-08
      0.00000000000000E+00   2.13768625850519E-12   0.00000000000000E+00  -5.23614047810444E-13  -4.37899155395203E-23
     -2.13711809870974E-09  -2.13764171275760E-09  -1.01350003288529E-18  -1.64657966252901E-01  -1.64657966258933E-01
      0.00000000000000E+00   0.00000000000000E+00   6.03177751786928E-09   0.00000000000000E+00   6.03177751786928E-09
      3.39621659984180E-18  -6.50731428970364E-02  -6.38462266265837E-02   0.00000000000000E+00  -3.27979709617908E-11
     -9.17167156080911E-23  -3.86133783414974E-09  -3.89413580511163E-09  -2.38271656695651E-18
      1.27064430710436E-08
      0.00000000000000E+00   2.12675673477749E-12   0.00000000000000E+00  -1.65316746302993E-13  -4.45350774213010E-23
     -2.12658916654520E-09  -2.12675448329155E-09  -1.06351251106371E-18  -1.38197562463378E-01  -1.38197562469048E-01
      0.00000000000000E+00   0.00000000000000E+00   5.66991843160316E-09   0.00000000000000E+00   5.66991843160316E-09
      3.52538442911176E-18  -8.12291496387826E-02  -8.01128099032828E-02   0.00000000000000E+00  -4.18128727106480E-11
     -9.62079179236816E-23  -3.50135107560086E-09  -3.54316394831160E-09  -2.46187191804805E-18
      1.27218204147936E-08
      0.00000000000000E+00   2.06705765559260E-12   0.00000000000000E+00  -1.02383961376499E-14  -4.50401002153473E-23
     -2.06708730235612E-09  -2.06709754075230E-09  -1.09553582526537E-18  -1.20813893192691E-01  -1.20813893198092E-01
      0.00000000000000E+00   0.00000000000000E+00   5.40081155043760E-09   0.00000000000000E+00   5.40081155043760E-09
      3.60843456485181E-18  -9.24026296155057E-02  -9.13522785315917E-02   0.00000000000000E+00  -4.81876515272673E-11
     -9.92580863263388E-23  -3.28552635815801E-09  -3.33371400968537E-09  -2.51289873958644E-18
      1.27425798288561E-08
      0.00000000000000E+00   1.95923193411096E-12   0.00000000000000E+00   4.88919184460762E-14  -4.56976550682389E-23
     -1.95923700534725E-09  -1.95918811342884E-09  -1.13566850497771E-18  -9.85212468053445E-02  -9.85212468104110E-02
      0.00000000000000E+00   0.00000000000000E+00   5.06650558269886E-09   0.00000000000000E+00   5.06650558269886E-09
      3.71361225209302E-18  -1.07618675431115E-01  -1.06639654414352E-01   0.00000000000000E+00  -5.35199012874504E-11
     -1.03350694117544E-22  -3.05379756798244E-09  -3.10731746927000E-09  -2.57794374711531E-18
      1.27706050378405E-08
      0.00000000000000E+00   1.75101991486150E-12   0.00000000000000E+00   1.59694050219700E-13  -4.64929770662860E-23
     -1.75113418985874E-09  -1.75097449580857E-09  -1.18328954504914E-18  -7.13174876732685E-02  -7.13174876778339E-02
      0.00000000000000E+00   0.00000000000000E+00   4.56537028891200E-09   0.00000000000000E+00   4.56537028891200E-09
      3.84155770853084E-18  -1.28166443419568E-01  -1.27279712939768E-01   0.00000000000000E+00  -5.92688585399459E-11
     -1.08797278318983E-22  -2.75512693456339E-09  -2.81439579310344E-09  -2.65826816348169E-18
      1.28084390699694E-08
      0.00000000000000E+00   1.31815566840242E-12   0.00000000000000E+00   3.91167175160087E-13  -4.72734487374481E-23
     -1.31851946902972E-09  -1.31812830185461E-09  -1.23079878953259E-18  -4.33209186578234E-02  -4.33209186615048E-02
      0.00000000000000E+00   0.00000000000000E+00   3.68140491180901E-09   0.00000000000000E+00   3.68140491180901E-09
      3.98084010024373E-18  -1.56024445817228E-01  -1.55279849436351E-01   0.00000000000000E+00  -6.19634040933114E-11
     -1.15640099242629E-22  -2.30131320586098E-09  -2.36327660995441E-09  -2.75004131071115E-18
      1.28584390699694E-08
      0.00000000000000E+00   7.10143508088597E-13   0.00000000000000E+00   5.05446725309414E-13  -4.77615695683405E-23
     -7.10627840717878E-10  -7.10122393992617E-10  -1.26312008373200E-18  -2.37303455045237E-02  -2.37303455069685E-02
      0.00000000000000E+00   0.00000000000000E+00   2.44482781272960E-09   0.00000000000000E+00   2.44482781272960E-09
      4.10308149088021E-18  -1.91319269533036E-01  -1.90772717021716E-01   0.00000000000000E+00  -5.59074975610368E-11
     -1.22917439311268E-22  -1.67879792117580E-09  -1.73470541873696E-09  -2.83996140714820E-18
      1.29084390699694E-08
      0.00000000000000E+00   3.42948248732905E-13   0.00000000000000E+00   3.25341244402769E-13  -4.79369496602866E-23
     -3.43211427606172E-10  -3.42886086361817E-10  -1.27713722719600E-18  -1.51346975925680E-02  -1.51346975941230E-02
      0.00000000000000E+00   0.00000000000000E+00   1.55495156205630E-09   0.00000000000000E+00   1.55495156205630E-09
      4.18082906898303E-18  -2.20723949759578E-01  -2.20342065290252E-01   0.00000000000000E+00  -4.49364221919178E-11
     -1.28230309366470E-22  -1.16712905350242E-09  -1.21206547569447E-09  -2.90369184178702E-18
      1.29584390699694E-08
      0.00000000000000E+00   1.98752011317088E-13   0.00000000000000E+00   1.29121833847035E-13  -4.79998002192320E-23
     -1.98881487110670E-10  -1.98752365276871E-10  -1.28401172320541E-18  -1.10380545895609E-02  -1.10380545905960E-02
      0.00000000000000E+00   0.00000000000000E+00   1.03505496333839E-09   0.00000000000000E+00   1.03505496333839E-09
      4.23258181714995E-18  -2.41861168508371E-01  -2.41597676762903E-01   0.00000000000000E+00  -3.22594733172601E-11
     -1.31805510712973E-22  -8.04043124744154E-10  -8.36302598061546E-10  -2.94857009394453E-18
      1.30084390699694E-08
      0.00000000000000E+00   1.43185945306534E-13   0.00000000000000E+00   5.05283003778947E-14  -4.80214958079980E-23
     -1.43273772462619E-10  -1.43223244162289E-10  -1.28816490542777E-18  -8.75173398163519E-03  -8.75173398235762E-03
      0.00000000000000E+00   0.00000000000000E+00   7.22427210726618E-10   0.00000000000000E+00   7.22427210726618E-10
      4.26870317768628E-18  -2.55785956141611E-01  -2.55603469965652E-01   0.00000000000000E+00  -2.10175171467987E-11
     -1.34046160954583E-22  -5.58186449417353E-10  -5.79203966564286E-10  -2.98053827225850E-18
      1.30584390699694E-08
      0.00000000000000E+00   1.16918350465182E-13   0.00000000000000E+00   2.55425446395026E-14  -4.80243569794679E-23
     -1.16924938803119E-10  -1.16899396258527E-10  -1.29105128710568E-18  -7.30929363730301E-03  -7.30929363786057E-03
      0.00000000000000E+00   0.00000000000000E+00   5.57562433975706E-10   0.00000000000000E+00   5.57562433975706E-10
      4.29658129938506E-18  -2.65642528345863E-01  -2.65503693303869E-01   0.00000000000000E+00  -1.43264373693143E-11
     -1.35534596364214E-22  -4.26336600347757E-10  -4.40663037717207E-10  -3.00553001227938E-18
      1.30834390699694E-08
      0.00000000000000E+00   1.05988826737486E-13   0.00000000000000E+00   2.26466830123410E-14  -4.80217486860153E-23
     -1.06007101523806E-10  -1.05984454840841E-10  -1.29223343439725E-18  -6.75934984912433E-03  -6.75934984961716E-03
      0.00000000000000E+00   0.00000000000000E+00   4.92834598285983E-10   0.00000000000000E+00   4.92834598285983E-10
      4.30890216434221E-18  -2.69781475267671E-01  -2.69659595461644E-01   0.00000000000000E+00  -1.16246315656128E-11
     -1.36129915399014E-22  -3.75225511879446E-10  -3.86850143445195E-10  -3.01666872994496E-18
      1.31171890699694E-08
      0.00000000000000E+00   9.81820240748461E-14   0.00000000000000E+00   1.33831803547202E-14  -4.80152373227733E-23
     -9.82250967157086E-11  -9.82117135354019E-11  -1.29358831506602E-18  -6.15922271067669E-03  -6.15922271113736E-03
      0.00000000000000E+00   0.00000000000000E+00   4.60670537717805E-10   0.00000000000000E+00   4.60670537717805E-10
      4.32444979499019E-18  -2.74946949343414E-01  -2.74832754728270E-01   0.00000000000000E+00  -1.05201474288957E-11
     -1.36846513349933E-22  -3.51938676753352E-10  -3.62458824182384E-10  -3.03086147992417E-18
      1.31399703199694E-08
      0.00000000000000E+00   9.34979424772622E-14   0.00000000000000E+00   1.28374427264707E-14  -4.80094892330237E-23
     -9.34713770667836E-11  -9.34585396241052E-11  -1.29440414149355E-18  -5.81459477349366E-03  -5.81459477392976E-03
      0.00000000000000E+00   0.00000000000000E+00   4.36097841537676E-10   0.00000000000000E+00   4.36097841537676E-10
      4.33438464894272E-18  -2.78171911860296E-01  -2.78063961962598E-01   0.00000000000000E+00  -9.51494229154316E-12
     -1.37280048155175E-22  -3.33124359621897E-10  -3.42639301913577E-10  -3.03998050744916E-18
      1.31553476637194E-08
      0.00000000000000E+00   9.01915319377913E-14   0.00000000000000E+00   1.34422416975932E-14  -4.80049517597445E-23
     -9.01922185508984E-11  -9.01787763092489E-11  -1.29490873830759E-18  -5.60905557051402E-03  -5.60905557093754E-03
      0.00000000000000E+00   0.00000000000000E+00   4.23521946041493E-10   0.00000000000000E+00   4.23521946041493E-10
      4.34089729149267E-18  -2.80276629797657E-01  -2.80171608910287E-01   0.00000000000000E+00  -9.08086224948725E-12
     -1.37557396764362E-22  -3.24262307482570E-10  -3.33343169732195E-10  -3.04598855318508E-18
      1.31761070777819E-08
      0.00000000000000E+00   8.63340529750751E-14   0.00000000000000E+00   1.24241857626056E-14  -4.79978855436547E-23
     -8.63691546751910E-11  -8.63567304894764E-11  -1.29551863196455E-18  -5.36880254273755E-03  -5.36880254315654E-03
      0.00000000000000E+00   0.00000000000000E+00   4.18991613898445E-10   0.00000000000000E+00   4.18991613898445E-10
      4.34959531189430E-18  -2.83156582670714E-01  -2.83051784941347E-01   0.00000000000000E+00  -9.19438675067243E-12
     -1.37933088694582E-22  -3.23440496658130E-10  -3.32634883408941E-10  -3.05407667992975E-18
      1.32041322867663E-08
      0.00000000000000E+00   8.17418161146988E-14   0.00000000000000E+00   1.18719541492373E-14  -4.79868599026032E-23
     -8.17913334984695E-11  -8.17794615443682E-11  -1.29622877189180E-18  -5.09837751717167E-03  -5.09837751759364E-03
      0.00000000000000E+00   0.00000000000000E+00   4.21978695274793E-10   0.00000000000000E+00   4.21978695274793E-10
      4.36142135301633E-18  -2.87273474948330E-01  -2.87166293844054E-01   0.00000000000000E+00  -9.85339388376687E-12
     -1.38470625051063E-22  -3.30345839846511E-10  -3.40199233730416E-10  -3.06519258112453E-18
      1.32419663188952E-08
      0.00000000000000E+00   7.43942371380967E-14   0.00000000000000E+00   1.42786484343310E-14  -4.79682952100124E-23
     -7.44218888669162E-11  -7.44076102185299E-11  -1.29693880655509E-18  -4.82997674750146E-03  -4.82997674796305E-03
      0.00000000000000E+00   0.00000000000000E+00   4.61592802098107E-10   0.00000000000000E+00   4.61592802098107E-10
      4.37888526992138E-18  -2.94290582780856E-01  -2.94168597338090E-01   0.00000000000000E+00  -1.31515864300496E-11
     -1.39422741487198E-22  -3.74033605449324E-10  -3.87185191879513E-10  -3.08194646336629E-18
      1.32919663188952E-08
      0.00000000000000E+00   6.45668502568913E-14   0.00000000000000E+00   1.55182827351523E-14  -4.79373887693720E-23
     -6.45863218440621E-11  -6.45708035613748E-11  -1.29744672843305E-18  -4.61674968495225E-03  -4.61674968549314E-03
      0.00000000000000E+00   0.00000000000000E+00   5.40883971369400E-10   0.00000000000000E+00   5.40883971369400E-10
      4.40592946848985E-18  -3.07102884436968E-01  -3.06952816626142E-01   0.00000000000000E+00  -1.95313363359764E-11
     -1.41250884898736E-22  -4.56781831471946E-10  -4.76313167808063E-10  -3.10848274005680E-18
      1.33419663188952E-08
      0.00000000000000E+00   5.46476186384784E-14   0.00000000000000E+00   1.67035450030100E-14  -4.79001054535755E-23
     -5.47156452750723E-11  -5.46989417301171E-11  -1.29752769282263E-18  -4.59622734869892E-03  -4.59622734926745E-03
      0.00000000000000E+00   0.00000000000000E+00   5.68531164433369E-10   0.00000000000000E+00   5.68531164433369E-10
      4.43435602671152E-18  -3.21581918018223E-01  -3.21420028803282E-01   0.00000000000000E+00  -2.29449649076174E-11
     -1.43344555115008E-22  -4.90887257795454E-10  -5.13832222703214E-10  -3.13682833388889E-18
      1.33919663188952E-08
      0.00000000000000E+00   2.38796316739570E-14   0.00000000000000E+00   4.19992491137676E-14  -4.78370225525650E-23
     -2.39249046801514E-11  -2.38829054310855E-11  -1.29614312055095E-18  -5.44103080482737E-03  -5.44103080533763E-03
      0.00000000000000E+00   0.00000000000000E+00   5.10257373429113E-10   0.00000000000000E+00   5.10257373429113E-10
      4.45986889538297E-18  -3.35911022879920E-01  -3.35757785254338E-01   0.00000000000000E+00  -2.18877997521699E-11
     -1.45292957863994E-22  -4.64486668245712E-10  -4.86374467998027E-10  -3.16372577483202E-18
      1.34419663188952E-08
      0.00000000000000E+00  -1.20224761004653E-13   0.00000000000000E+00   1.76619194049187E-13  -4.76451673380119E-23
      1.20074707741675E-10   1.20251326935677E-10  -1.28768126554163E-18  -1.04878259495442E-02  -1.04878259497968E-02
      0.00000000000000E+00   0.00000000000000E+00   2.52625848073414E-10   0.00000000000000E+00   2.52625848073414E-10
      4.47250018778665E-18  -3.49937515621622E-01  -3.49820039276922E-01   0.00000000000000E+00  -1.39176710626815E-11
     -1.46515250542822E-22  -3.58959503946247E-10  -3.72877175009075E-10  -3.18481892224501E-18
      1.34919663188952E-08
      0.00000000000000E+00  -6.11043036641675E-13   0.00000000000000E+00   5.89990965212809E-13  -4.70195257218210E-23
      6.10409272986022E-10   6.10999263951188E-10  -1.25515588187367E-18  -2.95108553652113E-02  -2.95108553646548E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.56555694210406E-10   0.00000000000000E+00  -5.56555694210406E-10
      4.44467240307613E-18  -3.64890062554089E-01  -3.64872920181746E-01   0.00000000000000E+00   1.07850823919604E-11
     -1.45615778332413E-22  -6.52286521326465E-11  -5.44435697408317E-11  -3.18951652120246E-18
      1.35169663188952E-08
      0.00000000000000E+00  -9.42602537960847E-13   0.00000000000000E+00   7.95865510224786E-13  -4.65692335569486E-23
      9.41834623111559E-10   9.42630488621737E-10  -1.23088789654843E-18  -4.34039728504400E-02  -4.34039728493546E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.08536965061719E-09   0.00000000000000E+00  -1.08536965061719E-09
      4.41753816181070E-18  -3.72627275343016E-01  -3.72672262715310E-01   0.00000000000000E+00   2.58001293548862E-11
     -1.44510585010682E-22   1.16939032640811E-10   1.42739161995552E-10  -3.18665026526227E-18
      1.35507163188952E-08
      0.00000000000000E+00  -1.20151285214887E-12   0.00000000000000E+00   5.35069642613503E-13  -4.58649607018687E-23
      1.20094772618363E-09   1.20148279582620E-09  -1.19050413023296E-18  -6.59287632011870E-02  -6.59287631997221E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.46487961410592E-09   0.00000000000000E+00  -1.46487961410592E-09
      4.36809847483462E-18  -3.82933544493231E-01  -3.83016550719740E-01   0.00000000000000E+00   3.50328717933684E-11
     -1.42426875451652E-22   2.28363946486436E-10   2.63396818279662E-10  -3.17759434460166E-18
      1.35734975688952E-08
      0.00000000000000E+00  -1.35526094223426E-12   0.00000000000000E+00   4.85467120429534E-13  -4.53700394145596E-23
      1.35480165841787E-09   1.35528712553826E-09  -1.16071400355804E-18  -8.21111421491199E-02  -8.21111421474690E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.65094391306711E-09   0.00000000000000E+00  -1.65094391306711E-09
      4.33048790881506E-18  -3.89655692006132E-01  -3.89748864788599E-01   0.00000000000000E+00   3.80840519288941E-11
     -1.40852123679782E-22   2.57572735600138E-10   2.95656787528891E-10  -3.16977390525702E-18
      1.35888749126452E-08
      0.00000000000000E+00  -1.45619830842534E-12   0.00000000000000E+00   4.70220502294175E-13  -4.50252722423665E-23
      1.45572367440802E-09   1.45619389491027E-09  -1.13973834710574E-18  -9.32931075011823E-02  -9.32931074994351E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.74716247086887E-09   0.00000000000000E+00  -1.74716247086887E-09
      4.30362119091341E-18  -3.94045894266236E-01  -3.94137592097255E-01   0.00000000000000E+00   3.90555628854627E-11
     -1.39735950287233E-22   2.51913013073202E-10   2.90968575958525E-10  -3.16388284380767E-18
      1.36096343267077E-08
      0.00000000000000E+00  -1.58340326945776E-12   0.00000000000000E+00   4.41259097886733E-13  -4.45100094336623E-23
      1.58292764164603E-09   1.58336890074388E-09  -1.11065613707939E-18  -1.08511725543916E-01  -1.08511725542096E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.82049942416238E-09   0.00000000000000E+00  -1.82049942416238E-09
      4.26582868956668E-18  -3.99633220055097E-01  -3.99707959634953E-01   0.00000000000000E+00   3.95383274619734E-11
     -1.38168596897944E-22   1.97592195956845E-10   2.37130523418681E-10  -3.15517255248729E-18
      1.36376595356921E-08
      0.00000000000000E+00  -1.82862871780186E-12   0.00000000000000E+00   5.59538746644375E-13  -4.34979328897145E-23
      1.82811971446087E-09   1.82867925320747E-09  -1.07038945937331E-18  -1.29062001132258E-01  -1.29062001130350E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.90869338883404E-09   0.00000000000000E+00  -1.90869338883404E-09
      4.21233715845751E-18  -4.06319865083540E-01  -4.06345112221711E-01   0.00000000000000E+00   4.00970206661582E-11
     -1.35935396620616E-22   3.99171149604953E-11   8.00141356265175E-11  -3.14194769908421E-18
      1.36754935678210E-08
      0.00000000000000E+00  -2.46942944929877E-12   0.00000000000000E+00   9.49264457475996E-13  -4.01689536101112E-23
      2.46849895370733E-09   2.46944821816477E-09  -1.01386284891729E-18  -1.56928514040679E-01  -1.56928514038595E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.08411985747383E-09   0.00000000000000E+00  -2.08411985747383E-09
      4.13348650080936E-18  -4.12768123556044E-01  -4.12646782305523E-01   0.00000000000000E+00   4.26426019568056E-11
     -1.32529786356996E-22  -4.27970962647618E-10  -3.85328360690945E-10  -3.11962365189207E-18
      1.37254935678210E-08
      0.00000000000000E+00  -4.26030998010834E-12   0.00000000000000E+00   1.85833450793698E-12  -2.55691786909568E-23
      4.25844038826482E-09   4.26029872277273E-09  -9.39033086535063E-19  -1.92136710552994E-01  -1.92136710550635E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.35905430695161E-09   0.00000000000000E+00  -2.35905430695161E-09
      4.01553378546178E-18  -4.11716788676519E-01  -4.11117899179686E-01   0.00000000000000E+00   4.86140850404397E-11
     -1.26888513672139E-22  -1.94985850086143E-09  -1.90124441582112E-09  -3.07650069892671E-18
      1.37754935678210E-08
      0.00000000000000E+00  -7.28797174215446E-12   0.00000000000000E+00   3.04884943845438E-12   8.21191841718332E-24
      7.28487403848860E-09   7.28792288792706E-09  -8.74202800704029E-19  -2.21349508610272E-01  -2.21349508607686E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.58528826605854E-09   0.00000000000000E+00  -2.58528826605854E-09
      3.88626937215885E-18  -3.93095485736159E-01  -3.91614057702304E-01   0.00000000000000E+00   5.43300538689077E-11
     -1.19798094187372E-22  -4.75696467573732E-09  -4.70263462186853E-09  -3.01206657145482E-18
      1.38254935678210E-08
      0.00000000000000E+00  -1.04893119022600E-11   0.00000000000000E+00   3.19610484057553E-12   4.71983757616319E-23
      1.04860814500398E-08   1.04892775548804E-08  -8.27002027533068E-19  -2.42284082668258E-01  -2.42284082665510E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.74855038027598E-09   0.00000000000000E+00  -2.74855038027598E-09
      3.74884185314505E-18  -3.52933820640526E-01  -3.50495233700630E-01   0.00000000000000E+00   5.64562177818958E-11
     -1.11767569409654E-22  -7.79718339238621E-09  -7.74072717460442E-09  -2.92183982561198E-18
      1.38754935678210E-08
      0.00000000000000E+00  -1.24543300548150E-11   0.00000000000000E+00   1.96095009782555E-12   7.27932023611602E-23
      1.24523576235898E-08   1.24543185736877E-08  -7.96822588583396E-19  -2.56065934857052E-01  -2.56065934854187E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.86495302706479E-09   0.00000000000000E+00  -2.86495302706479E-09
      3.60559420179181E-18  -2.95875312354377E-01  -2.92854253371579E-01   0.00000000000000E+00   5.10079456405211E-11
     -1.03851865577685E-22  -9.64037349226329E-09  -9.58936554662287E-09  -2.80877161320841E-18
      1.39254935678210E-08
      0.00000000000000E+00  -1.32124165157260E-11   0.00000000000000E+00   7.61609711092632E-13   8.25940743501629E-23
      1.32116163404430E-08   1.32123779501542E-08  -7.76735764813325E-19  -2.65861044109852E-01  -2.65861044106949E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.90286287852687E-09   0.00000000000000E+00  -2.90286287852687E-09
      3.46045105786547E-18  -2.33767094020832E-01  -2.30519081781952E-01   0.00000000000000E+00   3.88103322535128E-11
     -9.57012941440080E-23  -1.03483254038807E-08  -1.03095150716273E-08  -2.68371529305214E-18
      1.39504935678210E-08
      0.00000000000000E+00  -1.32709216133272E-11   0.00000000000000E+00   1.26191431485335E-13   8.34189660496395E-23
      1.32708581880493E-08   1.32709843794809E-08  -7.68727880438692E-19  -2.69980319619380E-01  -2.69980319616465E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.91469372764316E-09   0.00000000000000E+00  -2.91469372764316E-09
      3.38758371467439E-18  -2.02755219208349E-01  -1.99492438410368E-01   0.00000000000000E+00   3.06515995258503E-11
     -9.18407040694443E-23  -1.03869422513635E-08  -1.03562906518377E-08  -2.61885583423569E-18
      1.39842435678210E-08
      0.00000000000000E+00  -1.32695439422691E-11   0.00000000000000E+00   6.16440612027934E-15   8.20880060949611E-23
      1.32694879985271E-08   1.32694941629333E-08  -7.59118136160795E-19  -2.75128434476081E-01  -2.75128434473194E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.88717609147261E-09   0.00000000000000E+00  -2.88717609147261E-09
      3.29014152158719E-18  -1.62570933373130E-01  -1.59299919640650E-01   0.00000000000000E+00   2.47749014979463E-11
     -8.78310432214713E-23  -1.04070929729587E-08  -1.03823180714608E-08  -2.53102338542639E-18
      1.40070248178210E-08
      0.00000000000000E+00  -1.31559320023433E-11   0.00000000000000E+00  -2.38277582872385E-13   8.00600622301552E-23
      1.31561633690958E-08   1.31559250915130E-08  -7.53355363568172E-19  -2.78346239757980E-01  -2.78346239755105E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.87452182315921E-09   0.00000000000000E+00  -2.87452182315921E-09
      3.22465632130334E-18  -1.36179432692415E-01  -1.32940194306258E-01   0.00000000000000E+00   2.09107300108982E-11
     -8.54954578744807E-23  -1.03023139983645E-08  -1.02814032683537E-08  -2.47130095773517E-18
      1.40224021615710E-08
      0.00000000000000E+00  -1.30464530755920E-11   0.00000000000000E+00  -3.44084344147653E-13   7.84404357084010E-23
      1.30468119991025E-08   1.30464679147585E-08  -7.49676004855817E-19  -2.80448455311536E-01  -2.80448455308673E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.86257304619753E-09   0.00000000000000E+00  -2.86257304619753E-09
      3.18063755156248E-18  -1.18855763552799E-01  -1.15647234965071E-01   0.00000000000000E+00   1.85936223302945E-11
     -8.38032949183672E-23  -1.02024884908912E-08  -1.01838948685610E-08  -2.43096154670666E-18
      1.40431615756335E-08
      0.00000000000000E+00  -1.29028997513366E-11   0.00000000000000E+00  -3.34120034134269E-13   7.65655530938890E-23
      1.29032704251460E-08   1.29029363051120E-08  -7.44644574636561E-19  -2.83329307525595E-01  -2.83329307522761E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.83417738601155E-09   0.00000000000000E+00  -2.83417738601155E-09
      3.12180168967969E-18  -9.66730652356070E-02  -9.35007984697956E-02   0.00000000000000E+00   1.63256532910705E-11
     -8.08727877615314E-23  -1.00850845723914E-08  -1.00687589191004E-08  -2.37715711504313E-18
      1.40711867846178E-08
      0.00000000000000E+00  -1.26139562080817E-11   0.00000000000000E+00  -5.00508289745739E-13   7.47531850770291E-23
      1.26144615096944E-08   1.26139610014048E-08  -7.37245624165605E-19  -2.87464922775918E-01  -2.87464922773134E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.78441652146241E-09   0.00000000000000E+00  -2.78441652146241E-09
      3.04376783476616E-18  -6.97157352528974E-02  -6.66188210670632E-02   0.00000000000000E+00   1.35083137407610E-11
     -7.21176927871152E-23  -9.84305279368304E-09  -9.82954447994235E-09  -2.30652221060055E-18
      1.41090208167468E-08
      0.00000000000000E+00  -1.18715751972333E-11   0.00000000000000E+00  -9.55779954072947E-13   7.64069255788666E-23
      1.18725485948892E-08   1.18715928149352E-08  -7.23153863656586E-19  -2.94557368099431E-01  -2.94557368096767E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.66473648686733E-09   0.00000000000000E+00  -2.66473648686733E-09
      2.94295010890695E-18  -4.22690789066523E-02  -3.93683362220518E-02   0.00000000000000E+00   9.91589040169278E-12
     -3.83572647509429E-23  -9.21677221846953E-09  -9.20685632806787E-09  -2.21979624525037E-18
      1.41590208167468E-08
      0.00000000000000E+00  -1.06161494843436E-11   0.00000000000000E+00  -1.22080779785010E-12   8.95697330955805E-23
      1.06173606908763E-08   1.06161398830785E-08  -6.94617838568444E-19  -3.07450221546739E-01  -3.07450221544292E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.44715696300264E-09   0.00000000000000E+00  -2.44715696300264E-09
      2.82059226075682E-18  -2.32689765408970E-02  -2.06952194872227E-02   0.00000000000000E+00   6.18594792707706E-12
      3.64215146060211E-23  -8.17516886800302E-09  -8.16898292007590E-09  -2.12597442218838E-18
      1.42090208167468E-08
      0.00000000000000E+00  -9.64746304101582E-12   0.00000000000000E+00  -9.36631397032408E-13   1.07632365339034E-22
      9.64835000694362E-09   9.64741337554669E-09  -6.61218034681981E-19  -3.21941865815770E-01  -3.21941865813503E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.26668363670213E-09   0.00000000000000E+00  -2.26668363670213E-09
      2.70725807892171E-18  -1.49303617213031E-02  -1.26049495988329E-02   0.00000000000000E+00   3.84321939841748E-12
      1.03401910862304E-22  -7.38457295824309E-09  -7.38072973884457E-09  -2.04604004423973E-18
      1.42590208167468E-08
      0.00000000000000E+00  -9.06351420185036E-12   0.00000000000000E+00  -5.58517219974477E-13   1.22075235875769E-22
      9.06403215976223E-09   9.06347364254237E-09  -6.27980368528410E-19  -3.36259000869310E-01  -3.36259000867158E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.15249406248215E-09   0.00000000000000E+00  -2.15249406248215E-09
      2.59963337579761E-18  -1.09314192379117E-02  -8.75400559964050E-03   0.00000000000000E+00   2.63141384707946E-12
      1.51010457724641E-22  -6.91361099390747E-09  -6.91097958006024E-09  -1.97165300726920E-18
      1.43090208167468E-08
      0.00000000000000E+00  -8.75620171115398E-12   0.00000000000000E+00  -2.87015984858431E-13   1.29605373801011E-22
      8.75653556528393E-09   8.75624854929920E-09  -5.95501007997906E-19  -3.50291287961794E-01  -3.50291287959664E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.12930506258568E-09   0.00000000000000E+00  -2.12930506258568E-09
      2.49316812266832E-18  -8.68750057701979E-03  -6.59957451436513E-03   0.00000000000000E+00   2.05392361122214E-12
      1.79628223629094E-22  -6.62899741032491E-09  -6.62694348671351E-09  -1.89766711467042E-18
      1.43590208167468E-08
      0.00000000000000E+00  -8.78329590863020E-12   0.00000000000000E+00   4.26287610301979E-14   1.31218270021331E-22
      8.78329564533298E-09   8.78333827409414E-09  -5.60797566804867E-19  -3.65275600914891E-01  -3.65275600912588E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.30238604283063E-09   0.00000000000000E+00  -2.30238604283063E-09
      2.37804882052679E-18  -7.26658682118344E-03  -5.22465561323918E-03   0.00000000000000E+00   1.83126586886677E-12
      1.93610399271936E-22  -6.48278349713259E-09  -6.48095223126353E-09  -1.81725125372192E-18
      1.43840208167468E-08
      0.00000000000000E+00  -8.84235207465464E-12   0.00000000000000E+00   1.32168723073738E-13   1.28925152322696E-22
      8.84222976908059E-09   8.84236193780379E-09  -5.42813604748732E-19  -3.73015327733345E-01  -3.73015327730926E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.41923910841539E-09   0.00000000000000E+00  -2.41923910841539E-09
      2.31756784281641E-18  -6.72294569447108E-03  -4.69923360537707E-03   0.00000000000000E+00   1.73693271539822E-12
      1.94175239950619E-22  -6.42485976210392E-09  -6.42312282938833E-09  -1.77475423806767E-18
      1.44177708167468E-08
      0.00000000000000E+00  -8.83022856934325E-12   0.00000000000000E+00  -2.49234267355618E-15   1.21351860513374E-22
      8.83022995335424E-09   8.83022746101169E-09  -5.18909264086598E-19  -3.83306222396304E-01  -3.83306222393871E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.43262550939837E-09   0.00000000000000E+00  -2.43262550939837E-09
      2.23546673187421E-18  -6.12976285242383E-03  -4.11409021932886E-03   0.00000000000000E+00   1.56035433691295E-12
      1.86443863319639E-22  -6.39916230595043E-09  -6.39760195161333E-09  -1.71655746778761E-18
      1.44405520667468E-08
      0.00000000000000E+00  -8.77209085069088E-12   0.00000000000000E+00  -1.11603927181666E-13   1.13314376057468E-22
      8.77222304538232E-09   8.77211144145525E-09  -5.03326640103129E-19  -3.90011823256269E-01  -3.90011823253874E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.39520120369758E-09   0.00000000000000E+00  -2.39520120369758E-09
      2.18090105445248E-18  -5.78932078168647E-03  -3.78016656578344E-03   0.00000000000000E+00   1.44930321811639E-12
      1.75667172578787E-22  -6.37835954097596E-09  -6.37691023775767E-09  -1.67757441434935E-18
      1.44559294104968E-08
      0.00000000000000E+00  -8.71165701360833E-12   0.00000000000000E+00  -1.80568510917650E-13   1.06708397780084E-22
      8.71181142675661E-09   8.71163085824580E-09  -4.93153748473338E-19  -3.94388117640772E-01  -3.94388117638427E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.34490359077682E-09   0.00000000000000E+00  -2.34490359077682E-09
      2.14484266587649E-18  -5.58631515680599E-03  -3.58036869700666E-03   0.00000000000000E+00   1.35151802655144E-12
      1.66129110065867E-22  -6.36807878549565E-09  -6.36672726746893E-09  -1.65168891740315E-18
      1.44766888245593E-08
      0.00000000000000E+00  -8.59767769473379E-12   0.00000000000000E+00  -2.58305707594353E-13   9.67871870449345E-23
      8.59796459193588E-09   8.59770628622838E-09  -4.80218366211114E-19  -3.99951028148823E-01  -3.99951028146590E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.23266443849351E-09   0.00000000000000E+00  -2.23266443849351E-09
      2.09849386033518E-18  -5.34909694830619E-03  -3.34368079758607E-03   0.00000000000000E+00   1.21565061423931E-12
      1.51242379714915E-22  -6.36625749834936E-09  -6.36504184773497E-09  -1.61827549412407E-18
      1.45047140335436E-08
      0.00000000000000E+00  -8.37587265437761E-12   0.00000000000000E+00  -3.79595596819870E-13   8.24030190582758E-23
      8.37629118799409E-09   8.37591159239735E-09  -4.64781730882258E-19  -4.06589703844327E-01  -4.06589703842323E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.00394872259250E-09   0.00000000000000E+00  -2.00394872259250E-09
      2.04233277859056E-18  -5.08256936316445E-03  -3.07497174779350E-03   0.00000000000000E+00   1.02759926622773E-12
      1.28911367185792E-22  -6.37299046907120E-09  -6.37196286980484E-09  -1.57755104770830E-18
      1.45425480656725E-08
      0.00000000000000E+00  -7.87825786818723E-12   0.00000000000000E+00  -6.41083757083486E-13   6.29514948812789E-23
      7.87890837697947E-09   7.87826729322244E-09  -4.50194165678701E-19  -4.12914743999945E-01  -4.12914743998483E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.46143092063323E-09   0.00000000000000E+00  -1.46143092063323E-09
      1.98704095418514E-18  -4.81904356659480E-03  -2.79730675078339E-03   0.00000000000000E+00   6.50220443804579E-13
      9.78365807706790E-23  -6.41748659303312E-09  -6.41683637258921E-09  -1.53684678850644E-18
      1.45925480656725E-08
      0.00000000000000E+00  -6.42224324923631E-12   0.00000000000000E+00  -1.43632085696343E-12   3.90878454814931E-23
      6.42371964738050E-09   6.42228332652358E-09  -4.54658880705206E-19  -4.11497780627758E-01  -4.11497780627833E-01
      0.00000000000000E+00   0.00000000000000E+00   7.52496218478577E-11   0.00000000000000E+00   7.52496218478577E-11
      1.99080343527754E-18  -4.61037221056468E-03  -2.56320966941682E-03   0.00000000000000E+00  -2.17432722425318E-13
      5.87329667501886E-23  -6.49731551564910E-09  -6.49753294837147E-09  -1.53614455457233E-18
      1.46425480656725E-08
      0.00000000000000E+00  -3.81072999147749E-12   0.00000000000000E+00  -2.61654614105492E-12   1.51886149820493E-23
      3.81333981765632E-09   3.81072327151528E-09  -5.03090455474957E-19  -3.92321195329396E-01  -3.92321195332107E-01
      0.00000000000000E+00   0.00000000000000E+00   2.71127512905862E-09   0.00000000000000E+00   2.71127512905862E-09
      2.12636719173047E-18  -4.60385572923141E-03  -2.54897716498578E-03   0.00000000000000E+00  -1.78985665619538E-12
      1.78895976826178E-23  -6.52020854391768E-09  -6.52199840057386E-09  -1.62327673625551E-18
      1.46925480656725E-08
      0.00000000000000E+00  -1.12518987552941E-12   0.00000000000000E+00  -2.69296851714545E-12  -1.32647031500685E-23
      1.12784960813665E-09   1.12515663961950E-09  -6.04885124761346E-19  -3.51608446672214E-01  -3.51608446677539E-01
      0.00000000000000E+00   0.00000000000000E+00   5.32531467698501E-09   0.00000000000000E+00   5.32531467698501E-09
      2.39263292557972E-18  -5.51728296190749E-03  -3.48494978271034E-03   0.00000000000000E+00  -4.54171398171142E-12
     -3.35855479223970E-23  -6.44592960262279E-09  -6.45047131660453E-09  -1.78774780081837E-18
      1.47425480656725E-08
      0.00000000000000E+00   4.37364638582242E-13   0.00000000000000E+00  -1.62616985614644E-12  -3.48458822107352E-23
     -4.35749956733787E-10  -4.37376126589968E-10  -7.42234474415855E-19  -2.94247313722126E-01  -2.94247313728688E-01
      0.00000000000000E+00   0.00000000000000E+00   6.56196359773729E-09   0.00000000000000E+00   6.56196359773729E-09
      2.72073110546658E-18  -1.08915966204086E-02  -8.96194215732394E-03   0.00000000000000E+00  -9.00968631941144E-12
     -7.10574780749649E-23  -6.11557778482780E-09  -6.12458747114728E-09  -1.97849663105073E-18
      1.47925480656725E-08
      0.00000000000000E+00   1.54225682718879E-12   0.00000000000000E+00  -1.21251194358465E-12  -4.15772576483899E-23
     -1.54106906305554E-09  -1.54228157499917E-09  -8.78340087505363E-19  -2.32147224456673E-01  -2.32147224463314E-01
      0.00000000000000E+00   0.00000000000000E+00   6.64145221153593E-09   0.00000000000000E+00   6.64145221153593E-09
      3.05280371604338E-18  -3.05729915549647E-02  -2.89664136204898E-02   0.00000000000000E+00  -1.66681983387689E-11
     -8.17426811404509E-23  -5.08250243819795E-09  -5.09917063653680E-09  -2.17446362853802E-18
      1.48175480656725E-08
      0.00000000000000E+00   1.93232142610916E-12   0.00000000000000E+00  -9.20661314656552E-13  -4.27656449066549E-23
     -1.93142371439654E-09  -1.93234437571124E-09  -9.41850898272628E-19  -2.01169256922997E-01  -2.01169256929368E-01
      0.00000000000000E+00   0.00000000000000E+00   6.37139437362618E-09   0.00000000000000E+00   6.37139437362618E-09
      3.21208857538403E-18  -4.46898695905545E-02  -4.32912700705809E-02   0.00000000000000E+00  -2.49326079700202E-11
     -8.58878894530808E-23  -4.41411738994484E-09  -4.43904999791494E-09  -2.27023767711141E-18
      1.48512980656725E-08
      0.00000000000000E+00   2.14429907958413E-12   0.00000000000000E+00  -4.79634421761458E-13  -4.38900904611013E-23
     -2.14385712807974E-09  -2.14433676250155E-09  -1.02042723714267E-18  -1.61041073946654E-01  -1.61041073952644E-01
      0.00000000000000E+00   0.00000000000000E+00   5.99035788270031E-09   0.00000000000000E+00   5.99035788270031E-09
      3.41426315392517E-18  -6.73466134611160E-02  -6.61348563389993E-02   0.00000000000000E+00  -3.37609614595639E-11
     -9.23352422229125E-23  -3.81226015873910E-09  -3.84602112019876E-09  -2.39383591678250E-18
      1.48740793156725E-08
      0.00000000000000E+00   2.12032760317296E-12   0.00000000000000E+00  -1.38937775909465E-13  -4.46360496343280E-23
     -2.12020425845852E-09  -2.12034319623448E-09  -1.07000483616439E-18  -1.34701444506846E-01  -1.34701444512470E-01
      0.00000000000000E+00   0.00000000000000E+00   5.62342471511110E-09   0.00000000000000E+00   5.62342471511110E-09
      3.54237179821629E-18  -8.35699445247520E-02  -8.24662332476499E-02   0.00000000000000E+00  -4.28293005478433E-11
     -9.68289322620217E-23  -3.46025221832867E-09  -3.50308151887661E-09  -2.47236696205191E-18
      1.49048340031725E-08
      0.00000000000000E+00   1.99541876057073E-12   0.00000000000000E+00  -2.41197960266331E-15  -4.56170822441780E-23
     -1.99545856737540E-09  -1.99546097935505E-09  -1.13069251561399E-18  -1.01318363297560E-01  -1.01318363302715E-01
      0.00000000000000E+00   0.00000000000000E+00   5.15547881869992E-09   0.00000000000000E+00   5.15547881869992E-09
      3.70092693819828E-18  -1.05909727711822E-01  -1.04914104270064E-01   0.00000000000000E+00  -5.09103740953951E-11
     -1.02848862138249E-22  -3.10910746524942E-09  -3.16001783934492E-09  -2.57023442258429E-18
      1.49463528312975E-08
      0.00000000000000E+00   1.68378956722559E-12   0.00000000000000E+00   1.69155114789453E-13  -4.67440095466292E-23
     -1.68394559277032E-09  -1.68377643765557E-09  -1.19825865184595E-18  -6.26006347745162E-02  -6.26006347789279E-02
      0.00000000000000E+00   0.00000000000000E+00   4.41167219826717E-09   0.00000000000000E+00   4.41167219826717E-09
      3.88409439794198E-18  -1.36059836325524E-01  -1.35200360939873E-01   0.00000000000000E+00  -5.90235633007547E-11
     -1.10765048477454E-22  -2.66887219731067E-09  -2.72789576061154E-09  -2.68583574609602E-18
      1.49963528312975E-08
      0.00000000000000E+00   1.06539895160731E-12   0.00000000000000E+00   4.67395834341069E-13  -4.75476889760577E-23
     -1.06587776256343E-09  -1.06541036672914E-09  -1.24834753107129E-18  -3.27558864773798E-02  -3.27558864805477E-02
      0.00000000000000E+00   0.00000000000000E+00   3.16790571588531E-09   0.00000000000000E+00   3.16790571588531E-09
      4.04248968373624E-18  -1.72335213896482E-01  -1.71672782617835E-01   0.00000000000000E+00  -5.99385289727273E-11
     -1.19124512482828E-22  -2.04255682018334E-09  -2.10249534915619E-09  -2.79414215266495E-18
      1.50000000000000E-08
      0.00000000000000E+00   9.57114006439636E-13   0.00000000000000E+00   1.31670869412376E-12  -4.75952079459695E-23
     -9.58472036678756E-10  -9.57155327984679E-10  -1.25160583665945E-18  -3.07879011062665E-02  -3.07879011092112E-02
      0.00000000000000E+00   0.00000000000000E+00   2.94461772751758E-09   0.00000000000000E+00   2.94461772751758E-09
      4.05322920135275E-18  -1.74995049288951E-01  -1.74368856535331E-01   0.00000000000000E+00  -6.44354099678888E-11
     -1.19739848014945E-22  -1.92302698956532E-09  -1.98746239953333E-09  -2.80162336469330E-18
}
